/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.tcl.internal.ui.navigation.ElementsView;

public class FunctionsView
extends ElementsView {
    private boolean processNamespaceMethods = false;

    public String getElementName(Object element) {
        if (element instanceof IMethod) {
            String buffer = "";
            IModelElement el = (IModelElement)element;
            while (el != null) {
                String str = this.getOriginalElementText(el);
                buffer = str.startsWith("::") ? String.valueOf(str) + buffer : "::" + str + buffer;
                if (el instanceof IParent) {
                    IModelElement parent = el.getParent();
                    if (parent instanceof IType) {
                        el = parent;
                        continue;
                    }
                    el = null;
                    continue;
                }
                el = null;
            }
            String from = ((IMethod)element).getAncestor(4).getElementName();
            if (from.length() > 0) {
                return String.valueOf(buffer) + " (" + from + ")";
            }
            return buffer;
        }
        return null;
    }

    public String getJobTitle() {
        return "Functions view search...";
    }

    public boolean isElement(IModelElement e) {
        return e instanceof IMethod;
    }

    public boolean needProcessChildren(IModelElement e) {
        if (e instanceof IType) {
            return this.processNamespaceMethods;
        }
        return !(e instanceof IMethod) && !(e instanceof IField);
    }

    protected String getPreferencesId() {
        return "FunctionsView_";
    }
}

