/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.documentation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPageFolder;
import org.eclipse.dltk.tcl.internal.ui.documentation.ManPageFolderXML;
import org.eclipse.dltk.ui.documentation.IScriptDocumentationProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class TclManPagesDocumentationProvider
implements IScriptDocumentationProvider {
    private List folders = null;
    private IPropertyChangeListener changeListener = null;

    public Reader getInfo(IMember element, boolean lookIntoParents, boolean lookIntoExternal) {
        return null;
    }

    public Reader getInfo(String content) {
        this.initalizeLocations(false);
        if (this.folders != null) {
            Iterator iterator = this.folders.iterator();
            while (iterator.hasNext()) {
                ManPageFolder f = (ManPageFolder)iterator.next();
                Map pages = f.getPages();
                String ans = (String)pages.get(content);
                if (ans == null && content.indexOf(32) != -1) {
                    String subContent = content.substring(0, content.indexOf(32));
                    ans = (String)pages.get(subContent);
                }
                if (ans == null) continue;
                File file = new File(f.getPath(), ans);
                if (!file.isFile()) break;
                try {
                    return new FileReader(file);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }
        return null;
    }

    private void initalizeLocations(boolean force) {
        if (!force && this.folders != null) {
            return;
        }
        IPreferenceStore prefStore = TclUI.getDefault().getPreferenceStore();
        String value = prefStore.getString("doc_man_pages_locations");
        this.folders = ManPageFolderXML.read(value);
        if (this.folders != null && this.changeListener == null) {
            this.changeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    TclManPagesDocumentationProvider.this.initalizeLocations(true);
                }
            };
            prefStore.addPropertyChangeListener(this.changeListener);
        }
    }
}

