/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parser;

import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.compiler.SourceElementRequestVisitor;
import org.eclipse.dltk.compiler.problem.IProblemReporter;
import org.eclipse.dltk.compiler.task.ITaskReporter;
import org.eclipse.dltk.compiler.task.TodoTaskPreferences;
import org.eclipse.dltk.core.AbstractSourceElementParser;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceElementParserExtension;
import org.eclipse.dltk.core.ISourceModuleInfoCache;
import org.eclipse.dltk.core.SourceParserUtil;
import org.eclipse.dltk.tcl.core.TclParseUtil;
import org.eclipse.dltk.tcl.core.TclPlugin;
import org.eclipse.dltk.tcl.internal.parser.TclSourceElementRequestVisitor;
import org.eclipse.dltk.tcl.internal.parser.TclTodoTaskAstParser;

public class TclSourceElementParser
extends AbstractSourceElementParser
implements ISourceElementParserExtension {
    private IScriptProject scriptProject = null;
    static /* synthetic */ Class class$0;

    protected SourceElementRequestVisitor createVisitor() {
        return new TclSourceElementRequestVisitor(this.getRequestor(), this.getProblemReporter());
    }

    public void parseSourceModule(char[] contents, ISourceModuleInfoCache.ISourceModuleInfo astCache, char[] filename) {
        ModuleDeclaration moduleDeclaration;
        block8: {
            boolean markersCleaned;
            moduleDeclaration = SourceParserUtil.getModuleDeclaration((char[])filename, (char[])contents, (String)this.getNatureId(), (IProblemReporter)this.getProblemReporter(), (ISourceModuleInfoCache.ISourceModuleInfo)astCache, (int)0);
            TclSourceElementRequestVisitor requestor = (TclSourceElementRequestVisitor)this.createVisitor();
            requestor.setScriptProject(null);
            if (this.getProblemReporter() != null && this.scriptProject != null && (markersCleaned = this.getProblemReporter().isMarkersCleaned())) {
                TclParseUtil.CodeModel model = new TclParseUtil.CodeModel(new String(contents));
                requestor.setCodeModel(model);
                requestor.setScriptProject(this.scriptProject);
            }
            try {
                moduleDeclaration.traverse((ASTVisitor)requestor);
            }
            catch (Exception e) {
                if (!DLTKCore.DEBUG) break block8;
                e.printStackTrace();
            }
        }
        if (this.getProblemReporter() != null) {
            ITaskReporter taskReporter;
            IProblemReporter iProblemReporter = this.getProblemReporter();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dltk.compiler.task.ITaskReporter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((taskReporter = (ITaskReporter)iProblemReporter.getAdapter((Class)clazz)) != null) {
                taskReporter.clearTasks();
                this.parseTasks(taskReporter, contents, moduleDeclaration);
            }
        }
    }

    protected void parseTasks(ITaskReporter taskReporter, char[] content, ModuleDeclaration moduleDeclaration) {
        TclTodoTaskAstParser taskParser;
        TodoTaskPreferences preferences = new TodoTaskPreferences(TclPlugin.getDefault().getPluginPreferences());
        if (preferences.isEnabled() && (taskParser = new TclTodoTaskAstParser(taskReporter, preferences, moduleDeclaration)).isValid()) {
            taskParser.parse(content);
        }
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public void setScriptProject(IScriptProject project) {
        this.scriptProject = project;
    }
}

