/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.search.indexing.SourceIndexerRequestor;

public class TclSourceIndexerRequestor
extends SourceIndexerRequestor {
    protected String[] realEnclosingTypeNames = new String[5];
    protected int realdepth = 0;

    public void acceptMethodReference(char[] methodName, int argCount, int sourcePosition, int sourceEndPosition) {
        String mName = new String(methodName);
        String[] ns = mName.split("::");
        if (ns.length > 0) {
            this.indexer.addMethodReference(ns[ns.length - 1].toCharArray(), argCount);
        }
        int i = 0;
        while (i < ns.length - 1) {
            if (ns[i].length() > 0) {
                this.indexer.addTypeReference(ns[i].toCharArray());
            }
            ++i;
        }
    }

    public boolean enterTypeAppend(String fullName, String delimiter) {
        if (fullName.startsWith("::")) {
            String name = fullName.substring(2);
            String[] split = name.split("::");
            ArrayList cEnclodingNames = new ArrayList();
            int i = 0;
            while (i < split.length) {
                this.indexer.addTypeDeclaration(4096, this.pkgName, split[i], this.eclosingTypeNamesFrom(cEnclodingNames, split, i), null);
                ++i;
            }
            this.pushTypeName(name.toCharArray());
        } else {
            List cEnclodingNames = this.enclosingTypeNamesAsList();
            String[] split = fullName.split("::");
            int i = 0;
            while (i < split.length) {
                this.indexer.addTypeDeclaration(4096, this.pkgName, split[i], this.eclosingTypeNamesFrom(cEnclodingNames, split, i), null);
                ++i;
            }
            this.pushTypeName(fullName.toCharArray());
        }
        return true;
    }

    private char[][] eclosingTypeNamesFrom(List enclosingNames, String[] split, int i) {
        char[][] result = new char[enclosingNames.size() + i][];
        int index = 0;
        Iterator iterator = enclosingNames.iterator();
        while (iterator.hasNext()) {
            String name = (String)iterator.next();
            result[index++] = name.toCharArray();
        }
        int j = 0;
        while (j < i) {
            result[index++] = split[j].toCharArray();
            ++j;
        }
        if (result.length > 0) {
            return result;
        }
        return null;
    }

    private List enclosingTypeNamesAsList() {
        ArrayList<String> cEnclosingNames = new ArrayList<String>();
        char[][] enclosingTypeNames2 = this.enclosingTypeNames();
        if (enclosingTypeNames2 == null) {
            return cEnclosingNames;
        }
        int i = 0;
        while (i < enclosingTypeNames2.length) {
            cEnclosingNames.add(new String(enclosingTypeNames2[i]));
            ++i;
        }
        return cEnclosingNames;
    }

    public boolean enterTypeAppend(ISourceElementRequestor.TypeInfo info, String fullName, String delimiter) {
        return false;
    }

    public void enterMethodRemoveSame(ISourceElementRequestor.MethodInfo info) {
        this.enterMethod(info);
    }

    public boolean enterMethodWithParentType(ISourceElementRequestor.MethodInfo info, String parentName, String delimiter) {
        this.enterMethod(info);
        return false;
    }

    public void popTypeName() {
        if (this.depth > 0) {
            String name = this.realEnclosingTypeNames[this.realdepth - 1];
            this.realEnclosingTypeNames[--this.realdepth] = null;
            String[] split = name.split("::");
            int i = 0;
            while (i < split.length) {
                super.popTypeName();
                ++i;
            }
        }
    }

    public void pushTypeName(char[] typeName) {
        String type = new String(typeName);
        String[] split = type.split("::");
        int i = 0;
        while (i < split.length) {
            super.pushTypeName(split[i].toCharArray());
            ++i;
        }
        if (this.realdepth == this.realEnclosingTypeNames.length) {
            this.realEnclosingTypeNames = new String[this.depth * 2];
            System.arraycopy(this.realEnclosingTypeNames, 0, this.realEnclosingTypeNames, 0, this.realdepth);
        }
        this.realEnclosingTypeNames[this.realdepth++] = type;
    }

    public void enterType(ISourceElementRequestor.TypeInfo typeInfo) {
        if ((typeInfo.modifiers & 0x20000) == 0 && (typeInfo.modifiers & 0x10000) == 0) {
            super.enterType(typeInfo);
        } else {
            this.pushTypeName(typeInfo.name.toCharArray());
        }
    }
}

