/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.tcl.ui.semantilhighlighting.ISemanticHighlightingExtension;
import org.eclipse.dltk.ui.editor.highlighting.ASTSemanticHighlighter;
import org.eclipse.dltk.ui.editor.highlighting.ISemanticHighlightingRequestor;

public class TclSemanticPositionUpdater
extends ASTSemanticHighlighter {
    private final ISemanticHighlightingExtension[] extensions;
    private final ISemanticHighlightingRequestor[] requestors;

    public TclSemanticPositionUpdater(ISemanticHighlightingExtension[] extensions) {
        this.extensions = extensions;
        this.requestors = new ISemanticHighlightingRequestor[extensions.length];
        int offset = 0;
        int i = 0;
        while (i < extensions.length) {
            this.requestors[i] = new SemanticPositionRequestorExtension((ISemanticHighlightingRequestor)this, offset);
            offset += extensions[i].getHighlightings().length;
            ++i;
        }
    }

    protected ASTVisitor createVisitor(ISourceModule sourceCode) throws ModelException {
        return new ASTVisitor(){

            public boolean visitGeneral(ASTNode node) throws Exception {
                int i = 0;
                while (i < TclSemanticPositionUpdater.this.extensions.length) {
                    TclSemanticPositionUpdater.this.extensions[i].processNode(node, TclSemanticPositionUpdater.this.requestors[i]);
                    ++i;
                }
                return true;
            }
        };
    }

    protected String getNature() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    private static class SemanticPositionRequestorExtension
    implements ISemanticHighlightingRequestor {
        private final ISemanticHighlightingRequestor requestor;
        private final int offset;

        public SemanticPositionRequestorExtension(ISemanticHighlightingRequestor requestor, int offset) {
            this.offset = offset;
            this.requestor = requestor;
        }

        public void addPosition(int start, int end, int highlightingIndex) {
            this.requestor.addPosition(start, end, highlightingIndex + this.offset);
        }
    }
}

