/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.core;

import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.core.AbstractLanguageToolkit;
import org.eclipse.dltk.core.DLTKContentTypeManager;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.core.environment.IFileHandle;

public class TclLanguageToolkit
extends AbstractLanguageToolkit {
    private static final String TCL_CONTENT_TYPE = "org.eclipse.dltk.tclContentType";
    protected static IDLTKLanguageToolkit sInstance = new TclLanguageToolkit();

    private boolean acceptDir(IFileHandle f, IEnvironment environment) {
        IFileHandle[] listFiles;
        if (f.isDirectory() && (listFiles = f.getChildren()) != null) {
            int i = 0;
            while (i < listFiles.length) {
                if (listFiles[i].isFile() && DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)TclLanguageToolkit.getDefault(), (String)listFiles[i].getName())) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean validateSourcePackage(IPath path, IEnvironment environment) {
        IFileHandle file = environment.getFile(path);
        if (file.isDirectory()) {
            IFileHandle[] members = file.getChildren();
            int i = 0;
            while (i < members.length) {
                String name = members[i].getName();
                if (DLTKContentTypeManager.isValidFileNameForContentType((IDLTKLanguageToolkit)this, (IPath)members[i].getPath())) {
                    return true;
                }
                if (name.toLowerCase().equals("pkgindex.tcl") || name.toLowerCase().equals("tclindex")) {
                    return true;
                }
                if (this.acceptDir(members[i], environment)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public static IDLTKLanguageToolkit getDefault() {
        return sInstance;
    }

    public String getLanguageName() {
        return "Tcl";
    }

    public String getLanguageContentType() {
        return TCL_CONTENT_TYPE;
    }
}

