/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.testing.util;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.dltk.debug.ui.ScriptDebugConsole;
import org.eclipse.dltk.internal.testing.util.ConsoleLineNotifier;
import org.eclipse.dltk.testing.ITestingProcessor;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;

public class TestingConsoleListener
implements IConsoleListener {
    private ILaunch launch;
    private ITestingProcessor processor;
    private boolean initialized = false;
    private boolean finalized = false;

    public TestingConsoleListener(ILaunch launch, ITestingProcessor processor) {
        this.launch = launch;
        this.processor = processor;
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        this.checkConsoles(consoles);
    }

    public synchronized void consolesAdded(IConsole[] consoles) {
        this.checkConsoles(consoles);
    }

    private synchronized void checkConsoles(IConsole[] consoles) {
        if (this.initialized) {
            return;
        }
        int i = 0;
        while (i < consoles.length) {
            if (consoles[i] instanceof ProcessConsole) {
                ProcessConsole pc = (ProcessConsole)consoles[i];
                IProcess process = pc.getProcess();
                if (process != null && process.getLaunch().getAttribute("org.eclipse.dltk.testing.TEST_KIND").equals(this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND"))) {
                    this.process((TextConsole)pc, this.launch);
                    this.initialized = true;
                }
            } else if (consoles[i] instanceof ScriptDebugConsole) {
                ScriptDebugConsole cl = (ScriptDebugConsole)consoles[i];
                ILaunch launch2 = cl.getLaunch();
                String attribute = launch2.getAttribute("org.eclipse.dltk.testing.TEST_KIND");
                if (launch2 != null && attribute != null && attribute.equals(this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND"))) {
                    this.process((TextConsole)cl, this.launch);
                    this.initialized = true;
                }
            }
            ++i;
        }
    }

    private synchronized void done() {
        if (!this.finalized) {
            this.finalized = true;
            this.processor.done();
            ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
        }
    }

    private void process(TextConsole pc, ILaunch launch) {
        pc.addPatternMatchListener((IPatternMatchListener)new ConsoleLineNotifier(){
            private boolean first = true;

            public void connect(TextConsole console) {
                super.connect(console);
            }

            public synchronized void lineAppended(IRegion region, String content) {
                if (this.first) {
                    this.first = false;
                    TestingConsoleListener.this.processor.start();
                }
                TestingConsoleListener.this.processor.processLine(content);
            }

            public synchronized void disconnect() {
                super.disconnect();
                TestingConsoleListener.this.done();
            }

            public synchronized void consoleClosed() {
                super.consoleClosed();
                TestingConsoleListener.this.done();
            }
        });
    }

    public void consolesRemoved(IConsole[] consoles) {
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND") == null ? 0 : this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND").hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TestingConsoleListener other = (TestingConsoleListener)obj;
        return !(this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND") == null ? other.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND") != null : !this.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND").equals(other.launch.getAttribute("org.eclipse.dltk.testing.TEST_KIND")));
    }
}

