/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.mixin.MixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyObjectMixinClass;

public class RubyMixinMethod
implements IRubyMixinElement {
    private final String key;
    protected final RubyMixinModel model;
    private IMethod[] sourceMethods;

    public RubyMixinMethod(RubyMixinModel model, String key) {
        this.model = model;
        this.key = key;
    }

    public String getName() {
        return this.key.substring(this.key.lastIndexOf(MixinModel.SEPARATOR) + 1);
    }

    public RubyMixinMethod(RubyMixinModel model, String key, IMethod[] sourceMethods) {
        this.model = model;
        this.key = key;
        this.sourceMethods = sourceMethods;
    }

    public String getKey() {
        return this.key;
    }

    public RubyMixinClass getSelfType() {
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement parent = mixinElement.getParent();
        if (parent == null) {
            return new RubyObjectMixinClass(this.model, true);
        }
        IRubyMixinElement rubyParent = this.model.createRubyElement(parent);
        if (rubyParent instanceof RubyMixinClass) {
            return (RubyMixinClass)rubyParent;
        }
        return null;
    }

    public void setSourceMethods(IMethod[] sourceMethods) {
        this.sourceMethods = sourceMethods;
    }

    public IMethod[] getSourceMethods() {
        if (this.sourceMethods != null) {
            return this.sourceMethods;
        }
        return RubyMixinMethod.getSourceMethods(this.model, this.key);
    }

    protected static IMethod[] getSourceMethods(RubyMixinModel model, String key) {
        IMixinElement mixinElement = model.getRawModel().get(key);
        if (mixinElement != null) {
            Object[] allObjects = mixinElement.getAllObjects();
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < allObjects.length) {
                RubyMixinElementInfo info = (RubyMixinElementInfo)allObjects[i];
                if (info.getKind() == 2) {
                    result.add(info.getObject());
                }
                ++i;
            }
            return result.toArray(new IMethod[result.size()]);
        }
        return new IMethod[0];
    }

    public RubyMixinVariable[] getVariables() {
        ArrayList<IRubyMixinElement> result = new ArrayList<IRubyMixinElement>();
        IMixinElement mixinElement = this.model.getRawModel().get(this.key);
        IMixinElement[] children = mixinElement.getChildren();
        int i = 0;
        while (i < children.length) {
            IRubyMixinElement element = this.model.createRubyElement(children[i]);
            if (element instanceof RubyMixinVariable) {
                result.add(element);
            }
            ++i;
        }
        return result.toArray(new RubyMixinVariable[result.size()]);
    }

    public String toString() {
        return "RubyMixinMethod[" + this.key + "]";
    }
}

