/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.dltk.ui.wizards;

import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.dltk.MylynDLTKPlugin;
import org.eclipse.mylyn.internal.dltk.ui.DLTKUiUtil;
import org.eclipse.mylyn.internal.dltk.ui.wizards.MylynPreferenceWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.dialogs.IWorkingSetNewWizard;

public class MylynPreferenceWizard
extends Wizard
implements INewWizard {
    private MylynPreferenceWizardPage preferencePage;
    public static final String MYLYN_FIRST_RUN = "org.eclipse.dltk.mylyn.ui.first.run";
    private IPreferenceStore scriptPrefs = DLTKUIPlugin.getDefault().getPreferenceStore();

    public void init() {
        this.setWindowTitle("Mylyn Recommended Preferences");
        super.setDefaultPageImageDescriptor(MylynDLTKPlugin.imageDescriptorFromPlugin((String)"org.eclipse.dltk.mylyn", (String)"icons/wizban/banner-prefs.gif"));
        this.preferencePage = new MylynPreferenceWizardPage("Automatic preference settings");
    }

    public MylynPreferenceWizard() {
        this.init();
    }

    public MylynPreferenceWizard(String htmlDocs) {
        this.init();
    }

    public boolean performFinish() {
        this.setPreferences();
        this.preferencePage.isOpenTaskList();
        return true;
    }

    private void setPreferences() {
        boolean mylarContentAssist = this.preferencePage.isMylynContentAssistDefault();
        DLTKUiUtil.installContentAssist(this.scriptPrefs, mylarContentAssist);
        if (this.preferencePage.isAutoFolding()) {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.dltk.mylyn.active.folding.enabled", true);
            this.scriptPrefs.setValue("editor_folding_enabled", true);
        } else {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.dltk.mylyn.active.folding.enabled", false);
        }
        if (this.preferencePage.closeEditors()) {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.dltk.mylyn.auto.manage.editors", true);
        } else {
            ContextUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.dltk.mylyn.auto.manage.editors", false);
        }
        if (this.preferencePage.isCreateWorkingSet()) {
            IWorkingSetManager workingSetManager = ContextUiPlugin.getDefault().getWorkbench().getWorkingSetManager();
            IWorkingSetNewWizard wizard = workingSetManager.createWorkingSetNewWizard(new String[]{"org.eclipse.mylyn.workingSetPage"});
            if (wizard != null && workingSetManager.getWorkingSet("Task Context (for search)") == null) {
                IWorkingSet workingSet;
                WizardDialog dialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0 && (workingSet = wizard.getSelection()) != null) {
                    workingSetManager.addWorkingSet(workingSet);
                }
            }
        } else {
            IWorkingSetManager workingSetManager = ContextUiPlugin.getDefault().getWorkbench().getWorkingSetManager();
            IWorkingSet workingSet = workingSetManager.getWorkingSet("Task Context (for search)");
            if (workingSet != null) {
                workingSetManager.removeWorkingSet(workingSet);
            }
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.preferencePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

