/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.library.build.model;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.tea.library.build.jar.JarManager;
import org.eclipse.tea.library.build.jar.ZipExec;
import org.eclipse.tea.library.build.jar.ZipExecFactory;
import org.eclipse.tea.library.build.jar.ZipExecPart;
import org.eclipse.tea.library.build.model.BundleBuild;
import org.eclipse.tea.library.build.model.BundleData;
import org.eclipse.tea.library.build.model.FeatureData;
import org.eclipse.tea.library.build.model.PlatformTriple;
import org.eclipse.tea.library.build.model.PluginBuild;
import org.eclipse.tea.library.build.model.PluginData;
import org.eclipse.tea.library.build.model.PluginInfo;
import org.eclipse.tea.library.build.model.WorkspaceBuild;
import org.eclipse.tea.library.build.util.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FeatureBuild
extends BundleBuild<FeatureData> {
    protected final WorkspaceBuild workspace;

    protected FeatureBuild(FeatureData data, WorkspaceBuild workspace) {
        super(data);
        this.workspace = workspace;
    }

    public final String getFeatureName() {
        return ((FeatureData)this.data).getBundleName();
    }

    public final Set<PluginBuild> getIncludedPlugins() {
        TreeSet<PluginBuild> result = new TreeSet<PluginBuild>();
        for (PluginInfo info : ((FeatureData)this.data).getPluginInfos()) {
            PluginBuild plugin = this.workspace.getSourcePlugin(info.id);
            if (plugin != null) {
                result.add(plugin);
                continue;
            }
            throw new IllegalStateException("cannot find plugin " + info.id);
        }
        return result;
    }

    @Override
    public String getJarFileName(String buildVersion) {
        return String.valueOf(this.getFeatureName()) + '_' + buildVersion + ".jar";
    }

    public static void generateProperty(File propFile, JarManager jarManager, FeatureBuild feature) throws Exception {
        Properties props = new Properties();
        String buildVersion = ((FeatureData)feature.getData()).getBundleVersion();
        props.setProperty(feature.getFeatureName(), buildVersion);
        FeatureBuild.updateProperties(propFile, props);
    }

    public static void updateProperties(File propFile, Properties props) throws Exception {
        Properties propsExists = new Properties();
        if (propFile.exists()) {
            propsExists.putAll((Map<?, ?>)FileUtils.readProperties(propFile));
        }
        propsExists.putAll((Map<?, ?>)props);
        FileUtils.writeProperties(propsExists, propFile);
    }

    public void backupFeatureXml() throws IOException {
        File f = ((FeatureData)this.data).getFeatureXmlFile();
        if (f.exists()) {
            FileUtils.moveFile(f, new File(f.getParentFile(), String.valueOf(f.getName()) + "._bak_"));
        }
    }

    public void restoreFeatureXml() throws IOException {
        File f = ((FeatureData)this.data).getFeatureXmlFile();
        File bak = new File(f.getParentFile(), String.valueOf(f.getName()) + "._bak_");
        if (bak.exists()) {
            FileUtils.delete(f);
            FileUtils.moveFile(bak, f);
            ((FeatureData)this.data).reloadFeatureXml();
        }
    }

    public void generateFeatureXml(JarManager jm, Iterable<PluginBuild> plugins, Iterable<PluginBuild> strictPlugins) throws Exception {
        Document doc = ((FeatureData)this.data).generateFeatureHeader();
        Element root = doc.getDocumentElement();
        for (PluginBuild plugin : plugins) {
            this.genSinglePluginElement(jm, doc, root, plugin, false);
        }
        for (PluginBuild plugin : strictPlugins) {
            this.genSinglePluginElement(jm, doc, root, plugin, true);
        }
        File xmlFile = ((FeatureData)this.data).getFeatureXmlFile();
        FeatureData.writeXml(doc, xmlFile);
        ((FeatureData)this.data).reloadFeatureXml();
    }

    private void genSinglePluginElement(JarManager jm, Document doc, Element root, PluginBuild plugin, boolean strictVersion) throws Exception {
        String platformFilter = ((PluginData)plugin.getData()).getPlatformFilter();
        Element pluginElement = null;
        if (platformFilter != null) {
            PlatformTriple[] platforms = PlatformTriple.getAllPlatforms();
            boolean used = false;
            PlatformTriple[] platformTripleArray = platforms;
            int n = platforms.length;
            int n2 = 0;
            while (n2 < n) {
                PlatformTriple platform = platformTripleArray[n2];
                boolean match = platform.matchFilter(platformFilter);
                if (match) {
                    pluginElement = this.generatePluginElement(doc, plugin);
                    pluginElement.setAttribute("os", platform.os);
                    pluginElement.setAttribute("ws", platform.ws);
                    pluginElement.setAttribute("arch", platform.arch);
                    root.appendChild(pluginElement);
                    used = true;
                }
                ++n2;
            }
            if (!used) {
                System.out.println("Warning: ignoring plugin " + plugin.getPluginName() + ". No supported platform found.");
            }
        } else {
            pluginElement = this.generatePluginElement(doc, plugin);
            root.appendChild(pluginElement);
        }
        if (strictVersion && pluginElement != null) {
            String version = jm.getBundleVersion((BundleData)plugin.getData());
            pluginElement.setAttribute("version", version);
        }
    }

    private Element generatePluginElement(Document doc, PluginBuild plugin) {
        Element pluginElement = doc.createElement("plugin");
        pluginElement.setAttribute("id", plugin.getPluginName());
        pluginElement.setAttribute("download-size", "0");
        pluginElement.setAttribute("install-size", "0");
        pluginElement.setAttribute("version", "0.0.0");
        pluginElement.setAttribute("unpack", Boolean.toString(plugin.needUnpack()));
        if (((PluginData)plugin.getData()).getFragmentHost() != null) {
            pluginElement.setAttribute("fragment", "true");
        }
        return pluginElement;
    }

    @Override
    public File execJarCommands(ZipExecFactory zip, File distDirectory, String buildVersion, JarManager jarManager) throws Exception {
        File jarFile = new File(distDirectory, this.getJarFileName(buildVersion));
        FileUtils.delete(jarFile);
        File tmpDir = new File(distDirectory, "jar_" + this.getFeatureName());
        FileUtils.mkdirs(tmpDir);
        File tmpFile = this.writeUpdatedFeatureXml(tmpDir, buildVersion, jarManager);
        ZipExec exec = zip.createZipExec();
        exec.setZipFile(jarFile);
        exec.setJarMode(true);
        ZipExecPart part = new ZipExecPart();
        part.sourceDirectory = tmpDir;
        part.relativePaths.add(tmpFile.getName());
        exec.addPart(part);
        File featureProps = new File(((FeatureData)this.getData()).getFeatureXmlFile().getParentFile(), "feature.properties");
        if (featureProps.exists()) {
            ZipExecPart propPart = new ZipExecPart();
            propPart.sourceDirectory = featureProps.getParentFile();
            propPart.relativePaths.add(featureProps.getName());
            exec.addPart(propPart);
        }
        exec.createZip();
        FileUtils.delete(tmpFile);
        FileUtils.delete(tmpDir);
        return jarFile;
    }

    public File writeUpdatedFeatureXml(File targetDir, String buildVersion, JarManager jarManager) throws Exception {
        Document document = ((FeatureData)this.data).readFeatureXml();
        Element rootElement = document.getDocumentElement();
        rootElement.setAttribute("version", buildVersion);
        File targetFile = new File(targetDir, "feature.xml");
        FileUtils.writeXml(document, targetFile);
        return targetFile;
    }
}

