/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.export.extended.awt;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ILineSeries;
import org.eclipse.swtchart.ISeries;
import org.eclipse.swtchart.LineStyle;
import org.eclipse.swtchart.export.extended.awt.SwtToAwtUtils;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.CompressScatterSeries;
import org.eclipse.swtchart.internal.series.BarSeries;
import org.eclipse.swtchart.internal.series.LineSeries;

public class ChartToGraphics2D {
    private Chart chart;
    private Axis xAxis;
    private Axis yAxis;
    private Graphics2D graphics2D;
    private int height;
    private int width;
    private int xBorder;
    private int yBorder;

    public ChartToGraphics2D(Chart chart, int indexAxisX, int indexAxisY, Graphics2D g2d) {
        this.chart = chart;
        this.graphics2D = g2d;
        this.xAxis = (Axis)chart.getAxisSet().getXAxis(indexAxisX);
        this.yAxis = (Axis)chart.getAxisSet().getYAxis(indexAxisY);
        this.width = chart.getSize().x;
        this.height = chart.getSize().y;
        this.xBorder = 50;
        this.yBorder = 50;
        this.init();
    }

    public Graphics2D getGraphics2D() {
        return this.graphics2D;
    }

    private void init() {
        ISeries[] series;
        this.graphics2D.translate(50, 0);
        this.graphics2D.setClip(new Rectangle(this.xBorder, this.yBorder, this.width - 2 * this.xBorder, this.height - 2 * this.yBorder));
        ISeries[] iSeriesArray = series = this.chart.getSeriesSet().getSeries();
        int n = series.length;
        int n2 = 0;
        while (n2 < n) {
            ISeries dataSeries = iSeriesArray[n2];
            if (dataSeries != null) {
                if (dataSeries.getType() == ISeries.SeriesType.LINE) {
                    this.drawLineSeries(dataSeries);
                } else if (dataSeries.getType() == ISeries.SeriesType.BAR) {
                    this.drawBarSeries(dataSeries);
                } else {
                    return;
                }
            }
            ++n2;
        }
        this.graphics2D.setClip(null);
        this.graphics2D.setColor(Color.BLACK);
        int x11 = this.xBorder;
        int y11 = this.height - this.yBorder;
        int x12 = this.width - this.xBorder;
        int y12 = this.height - this.yBorder;
        this.graphics2D.drawLine(x11, y11, x12, y12);
        int x21 = this.xBorder;
        int y21 = this.yBorder;
        int x22 = this.xBorder;
        int y22 = this.height - this.yBorder;
        this.graphics2D.drawLine(x21, y21, x22, y22);
        this.drawGridAndTicks(this.xAxis);
        this.drawGridAndTicks(this.yAxis);
        this.drawTickLabelsOnXAxis();
        this.drawTickLabelsOnYAxis();
        this.graphics2D.translate(0, 0);
        String labelX = this.xAxis.getTitle().getText();
        String labelY = this.yAxis.getTitle().getText();
        this.graphics2D.setFont(SwtToAwtUtils.toAwtFont((Device)this.chart.getDisplay(), this.chart.getAxisSet().getAxes()[0].getTitle().getFont()));
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        Font font = this.graphics2D.getFont();
        int textwidth = (int)font.getStringBounds(labelX, fontRenderContext).getWidth();
        int textheight = (int)font.getStringBounds(labelX, fontRenderContext).getHeight();
        int x1 = this.width / 2 - textwidth / 2;
        int y1 = this.height - textheight / 2 + 5;
        this.graphics2D.drawString(labelX, x1, y1);
        affineTransform.rotate(Math.toRadians(-90.0), 0.0, 0.0);
        Font rotatedFont = font.deriveFont(affineTransform);
        this.graphics2D.setFont(rotatedFont);
        int textwidthY = (int)font.getStringBounds(labelY, fontRenderContext).getWidth();
        this.graphics2D.drawString(labelY, -5, this.height / 2 + textwidthY / 2);
    }

    private void drawBarSeries(ISeries dataSeries) {
        BarSeries barSeries = (BarSeries)dataSeries;
        this.graphics2D.setColor(SwtToAwtUtils.toAwtColor(barSeries.getBarColor()));
        org.eclipse.swt.graphics.Rectangle[] rs = barSeries.getBoundsForCompressedSeries();
        int i = 0;
        while (i < rs.length) {
            this.graphics2D.fillRect(rs[i].x + this.xBorder, rs[i].y + this.yBorder, rs[i].width, rs[i].height);
            this.graphics2D.drawRect(rs[i].x + this.xBorder, rs[i].y + this.yBorder, rs[i].width, rs[i].height);
            ++i;
        }
    }

    private void drawLineSeries(ISeries dataSeries) {
        LineSeries lineSeries = (LineSeries)dataSeries;
        if (lineSeries.getLineStyle() != LineStyle.NONE) {
            this.graphics2D.setColor(SwtToAwtUtils.toAwtColor(lineSeries.getLineColor()));
            double[] xSeries = dataSeries.getXSeries();
            double[] ySeries = dataSeries.getYSeries();
            double xMin = Arrays.stream(xSeries).min().getAsDouble();
            double xMax = Arrays.stream(xSeries).max().getAsDouble();
            double yMin = Arrays.stream(ySeries).min().getAsDouble();
            double yMax = Arrays.stream(ySeries).max().getAsDouble();
            double xDenumerator = xMax - xMin;
            double yDenumerator = yMax - yMin;
            if (xMax > 0.0 && yMax > 0.0) {
                double factorX = (double)(this.width - 2 * this.xBorder) / xDenumerator;
                double factorY = (double)(this.height - 2 * this.yBorder) / yDenumerator;
                int nPoints = xSeries.length - 1;
                int i = 0;
                while (i < nPoints) {
                    int x1 = (int)(factorX * (xSeries[i] - xMin) + (double)this.xBorder);
                    int y1 = (int)((double)this.height - factorY * (ySeries[i] - yMin) - (double)this.yBorder);
                    int x2 = (int)(factorX * (xSeries[i + 1] - xMin) + (double)this.xBorder);
                    int y2 = (int)((double)this.height - factorY * (ySeries[i + 1] - yMin) - (double)this.yBorder);
                    this.graphics2D.drawLine(x1, y1, x2, y2);
                    ++i;
                }
            }
            return;
        }
        if (lineSeries.getSymbolType() != ILineSeries.PlotSymbolType.NONE) {
            ILineSeries.PlotSymbolType symbolType = lineSeries.getSymbolType();
            int symbolSize = lineSeries.getSymbolSize();
            Color symbolColor = SwtToAwtUtils.toAwtColor(lineSeries.getSymbolColor());
            CompressScatterSeries compressor = new CompressScatterSeries();
            compressor.setXSeries(dataSeries.getXSeries());
            compressor.setYSeries(dataSeries.getYSeries());
            double[] xseries = compressor.getCompressedXSeries();
            double[] yseries = compressor.getCompressedYSeries();
            int i = 0;
            while (i < xseries.length) {
                int v;
                int h;
                if (this.xAxis.isHorizontalAxis()) {
                    h = this.xAxis.getPixelCoordinate(xseries[i]) + this.xBorder;
                    v = this.yAxis.getPixelCoordinate(yseries[i]) + this.yBorder;
                } else {
                    v = this.xAxis.getPixelCoordinate(xseries[i]) + this.xBorder;
                    h = this.yAxis.getPixelCoordinate(yseries[i]) + this.yBorder;
                }
                this.graphics2D.setColor(symbolColor);
                switch (symbolType) {
                    case CIRCLE: {
                        this.graphics2D.fillOval(h - symbolSize, v - symbolSize, symbolSize * 2, symbolSize * 2);
                        break;
                    }
                    case SQUARE: {
                        this.graphics2D.fillRect(h - symbolSize, v - symbolSize, symbolSize * 2, symbolSize * 2);
                        break;
                    }
                    case TRIANGLE: {
                        int[] triangleXPoints = new int[]{h, h + symbolSize, h - symbolSize};
                        int[] triangleYPoints = new int[]{v - symbolSize, v + symbolSize, v + symbolSize};
                        this.graphics2D.fillPolygon(triangleXPoints, triangleYPoints, 3);
                        break;
                    }
                    case INVERTED_TRIANGLE: {
                        int[] invertedTriangleXPoints = new int[]{h, h + symbolSize, h - symbolSize};
                        int[] invertedTriangleYPoints = new int[]{v + symbolSize, v - symbolSize, v - symbolSize};
                        this.graphics2D.fillPolygon(invertedTriangleXPoints, invertedTriangleYPoints, 3);
                        break;
                    }
                    case CROSS: {
                        this.graphics2D.drawLine(h - symbolSize, v - symbolSize, h + symbolSize, v + symbolSize);
                        this.graphics2D.drawLine(h - symbolSize, v + symbolSize, h + symbolSize, v - symbolSize);
                        break;
                    }
                    case PLUS: {
                        this.graphics2D.drawLine(h, v - symbolSize, h, v + symbolSize);
                        this.graphics2D.drawLine(h - symbolSize, v, h + symbolSize, v);
                        break;
                    }
                    case DIAMOND: {
                        int[] diamondXPoints = new int[]{h, h + symbolSize, h, h - symbolSize};
                        int[] diamondYPoints = new int[]{v - symbolSize, v, v + symbolSize, v};
                        this.graphics2D.fillPolygon(diamondXPoints, diamondYPoints, 4);
                        break;
                    }
                }
                ++i;
            }
        }
    }

    private void drawTickLabelsOnXAxis() {
        int offset = this.xAxis.getTick().getAxisTickMarks().getBounds().x;
        this.graphics2D.setFont(SwtToAwtUtils.toAwtFont((Device)this.chart.getDisplay(), this.xAxis.getTick().getFont()));
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        Font font = this.graphics2D.getFont();
        int angle = this.xAxis.getTick().getTickLabelAngle();
        ArrayList tickLabelPositions = this.xAxis.getTick().getAxisTickLabels().getTickLabelPositions();
        ArrayList tickVisibilities = this.xAxis.getTick().getAxisTickLabels().getTickVisibilities();
        ArrayList tickLabels = this.xAxis.getTick().getAxisTickLabels().getTickLabels();
        org.eclipse.swt.graphics.Rectangle bounds = this.xAxis.getTick().getAxisTickLabels().getBounds();
        IAxis.Position position = this.xAxis.getPosition();
        int i = 0;
        while (i < tickLabelPositions.size()) {
            if (this.xAxis.isValidCategoryAxis() || ((Boolean)tickVisibilities.get(i)).booleanValue()) {
                String text = (String)tickLabels.get(i);
                int textWidth = (int)font.getStringBounds(text, fontRenderContext).getWidth();
                int textHeight = (int)font.getStringBounds(text, fontRenderContext).getHeight();
                if (angle == 0) {
                    int x = (int)((double)((Integer)tickLabelPositions.get(i)).intValue() - (double)textWidth / 2.0 + (double)offset);
                    this.graphics2D.drawString(text, bounds.x + x - this.xBorder, bounds.y + this.yBorder / 2 + 5);
                } else {
                    float y;
                    float x;
                    if (position == IAxis.Position.Primary) {
                        x = (float)((double)(offset + bounds.x + (Integer)tickLabelPositions.get(i)) - (double)textWidth * Math.cos(Math.toRadians(angle)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)bounds.y + (double)textWidth * Math.sin(Math.toRadians(angle)));
                    } else {
                        x = (float)((double)(offset + bounds.x + (Integer)tickLabelPositions.get(i)) - (double)textHeight / 2.0 * Math.sin(Math.toRadians(angle)));
                        y = (float)((double)bounds.y + (double)bounds.height * Math.sin(Math.toRadians(angle)));
                    }
                    this.drawRotatedText(this.graphics2D, text, x - (float)this.xBorder, y + (float)(this.yBorder / 2) + 5.0f, angle);
                }
            }
            ++i;
        }
    }

    private void drawTickLabelsOnYAxis() {
        this.graphics2D.setFont(SwtToAwtUtils.toAwtFont((Device)this.chart.getDisplay(), this.yAxis.getTick().getFont()));
        AffineTransform affineTransform = new AffineTransform();
        FontRenderContext fontRenderContext = new FontRenderContext(affineTransform, true, true);
        Font font = this.graphics2D.getFont();
        int figureHeight = (int)font.getStringBounds("dummy", fontRenderContext).getHeight();
        ArrayList tickLabelPositions = this.yAxis.getTick().getAxisTickLabels().getTickLabelPositions();
        ArrayList tickVisibilities = this.yAxis.getTick().getAxisTickLabels().getTickVisibilities();
        ArrayList tickLabels = this.yAxis.getTick().getAxisTickLabels().getTickLabels();
        org.eclipse.swt.graphics.Rectangle bounds = this.yAxis.getTick().getAxisTickLabels().getBounds();
        int i = 0;
        while (i < tickLabelPositions.size()) {
            if (tickVisibilities.size() == 0 || tickLabels.size() == 0) break;
            if (((Boolean)tickVisibilities.get(i)).booleanValue()) {
                String text = (String)tickLabels.get(i);
                int x = 5;
                if (((String)tickLabels.get(0)).startsWith("-") && !text.startsWith("-")) {
                    x += (int)font.getStringBounds("-", fontRenderContext).getWidth();
                }
                int y = (int)((double)(bounds.height - 1 - (Integer)tickLabelPositions.get(i)) - (double)figureHeight / 2.0);
                this.graphics2D.drawString(text, bounds.x + x - this.xBorder, bounds.y + y + this.yBorder / 2);
            }
            ++i;
        }
    }

    private void drawRotatedText(Graphics2D g2d, String text, float x, float y, int angle) {
        AffineTransform original = g2d.getTransform();
        g2d.rotate(Math.PI * (double)(angle / 180));
        g2d.drawString(text, x, y);
        g2d.setTransform(original);
    }

    private void drawGridAndTicks(Axis axis) {
        int xWidth = axis.isHorizontalAxis() ? this.width - 2 * this.xBorder : this.height - 2 * this.yBorder;
        ArrayList tickLabelPosition = axis.getTick().getAxisTickLabels().getTickLabelPositions();
        if (axis.isValidCategoryAxis()) {
            int step = 0;
            step = tickLabelPosition.size() > 1 ? (Integer)tickLabelPosition.get(1) - (Integer)tickLabelPosition.get(0) : xWidth;
            int x = (int)((double)((Integer)tickLabelPosition.get(0)).intValue() - (double)step / 2.0);
            int i = 0;
            while (i < tickLabelPosition.size() + 1) {
                if ((x += step) < xWidth) {
                    int y2;
                    int x2;
                    int y1;
                    int x1;
                    if (axis.isHorizontalAxis()) {
                        x1 = x + this.xBorder;
                        y1 = this.yBorder;
                        x2 = x1;
                        y2 = this.height - this.yBorder;
                        this.drawDashedLine(x1, y1, x2, y2);
                        this.graphics2D.drawLine(x1, y2, x2, y2 + 5);
                    } else {
                        x1 = this.xBorder;
                        y1 = this.height - this.yBorder - x;
                        x2 = this.width - this.xBorder;
                        y2 = y1;
                        this.drawDashedLine(x1, y1, x2, y2);
                        this.graphics2D.drawLine(this.xBorder - 5, y1, this.xBorder, y2);
                    }
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < tickLabelPosition.size()) {
                int x = (Integer)tickLabelPosition.get(i);
                if (x < xWidth) {
                    int y2;
                    int x2;
                    int y1;
                    int x1;
                    if (axis.isHorizontalAxis()) {
                        x1 = x + this.xBorder;
                        y1 = this.yBorder;
                        x2 = x1;
                        y2 = this.height - this.yBorder;
                        this.drawDashedLine(x1, y1, x2, y2);
                        this.graphics2D.drawLine(x1, this.height - this.yBorder, x2, this.height - this.yBorder + 5);
                    } else {
                        x1 = this.xBorder;
                        y1 = this.height - this.yBorder - x;
                        x2 = this.width - this.xBorder;
                        y2 = y1;
                        this.drawDashedLine(x1, y1, x2, y2);
                        this.graphics2D.drawLine(this.xBorder - 5, y1, this.xBorder, y2);
                    }
                }
                ++i;
            }
        }
    }

    private void drawDashedLine(int x1, int y1, int x2, int y2) {
        Graphics2D g2d = (Graphics2D)this.graphics2D.create();
        g2d.setColor(Color.GRAY);
        BasicStroke dashed = new BasicStroke(1.0f, 1, 2, 0.0f, new float[]{2.0f, 4.0f}, 0.0f);
        g2d.setStroke(dashed);
        g2d.drawLine(x1, y1, x2, y2);
        g2d.dispose();
    }
}

