/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.resource.BasicResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.resource.IResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.resource.XMLResourceProblemMarkerFactory;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.resources.MarkerJob;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class ResourceProblemMarkerService {
    public static final String PROXY_URI_INTEGRITY_PROBLEM = "org.eclipse.sphinx.emf.proxyuriintegrityproblemmarker";
    public static ResourceProblemMarkerService INSTANCE = new ResourceProblemMarkerService();

    private ResourceProblemMarkerService() {
    }

    public void updateProblemMarkers(Map<IFile, Exception> filesWithErrors, IProgressMonitor monitor) {
        Assert.isNotNull(filesWithErrors);
        if (!filesWithErrors.isEmpty() && Platform.isRunning()) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)filesWithErrors.size());
            for (IFile file : filesWithErrors.keySet()) {
                if (progress.isCanceled()) {
                    return;
                }
                try {
                    Exception error;
                    if (file.isAccessible()) {
                        this.getResourceProblemMarkerFactory(file).deleteMarkers((IResource)file);
                    }
                    if ((error = filesWithErrors.get(file)) instanceof Resource.Diagnostic) {
                        this.createProblemMarkerForDiagnostic(file, null, (Resource.Diagnostic)error, 2);
                    } else {
                        this.createProblemMarkerForException(file, error, 2);
                    }
                }
                catch (CoreException ex) {
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
                }
                progress.worked(1);
            }
            MarkerJob.INSTANCE.schedule();
        }
    }

    public void updateProblemMarkers(Resource resource, IProgressMonitor monitor) {
        if (resource != null) {
            this.updateProblemMarkers(Collections.singleton(resource), monitor);
        }
    }

    public void updateProblemMarkers(Collection<Resource> resources, IProgressMonitor monitor) {
        Assert.isNotNull(resources);
        if (!resources.isEmpty() && Platform.isRunning()) {
            HashMap<TransactionalEditingDomain, Collection<Resource>> resourcesToUpdate = new HashMap<TransactionalEditingDomain, Collection<Resource>>();
            for (Resource resource : resources) {
                TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)resource);
                HashSet<Resource> resourcesToUpdateInEditingDomain = (HashSet<Resource>)resourcesToUpdate.get(editingDomain);
                if (resourcesToUpdateInEditingDomain == null) {
                    resourcesToUpdateInEditingDomain = new HashSet<Resource>();
                    resourcesToUpdate.put(editingDomain, resourcesToUpdateInEditingDomain);
                }
                resourcesToUpdateInEditingDomain.add(resource);
            }
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToUpdate.keySet().size());
            if (progress.isCanceled()) {
                return;
            }
            for (TransactionalEditingDomain editingDomain : resourcesToUpdate.keySet()) {
                this.updateProblemMarkersInEditingDomain(editingDomain, resourcesToUpdate, (IProgressMonitor)progress.newChild(1));
            }
            MarkerJob.INSTANCE.schedule();
        }
    }

    private void updateProblemMarkersInEditingDomain(final TransactionalEditingDomain editingDomain, final Map<TransactionalEditingDomain, Collection<Resource>> resourcesToUpdate, final IProgressMonitor monitor) {
        Assert.isNotNull(resourcesToUpdate);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Collection resourcesToUpdateInEditingDomain = (Collection)resourcesToUpdate.get(editingDomain);
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)resourcesToUpdateInEditingDomain.size());
                if (progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                for (Resource resource : resourcesToUpdateInEditingDomain) {
                    IFile file = EcorePlatformUtil.getFile(resource);
                    if (file != null) {
                        ExtendedResource extendedResource;
                        if (file.isAccessible()) {
                            ResourceProblemMarkerService.this.getResourceProblemMarkerFactory(file).deleteMarkers((IResource)file);
                        }
                        int maxCount = (extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt((Notifier)resource)) != null ? (Integer)extendedResource.getProblemHandlingOptions().get("MAX_PROBLEM_MARKER_COUNT") : ExtendedResource.OPTION_MAX_PROBLEM_MARKER_COUNT_UNLIMITED;
                        int count = 0;
                        ArrayList safeErrors = new ArrayList(resource.getErrors());
                        Iterator iter = safeErrors.iterator();
                        while (iter.hasNext() && count != maxCount) {
                            try {
                                ResourceProblemMarkerService.this.createProblemMarkerForDiagnostic(file, extendedResource, (Resource.Diagnostic)iter.next(), 2);
                            }
                            catch (Exception ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                            }
                            ++count;
                        }
                        ArrayList safeWarnings = new ArrayList(resource.getWarnings());
                        Iterator iter2 = safeWarnings.iterator();
                        while (iter2.hasNext() && count != maxCount) {
                            try {
                                ResourceProblemMarkerService.this.createProblemMarkerForDiagnostic(file, extendedResource, (Resource.Diagnostic)iter2.next(), 1);
                            }
                            catch (Exception ex) {
                                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                            }
                            ++count;
                        }
                    }
                    progress.worked(1);
                    if (!progress.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
            }
        };
        if (editingDomain != null) {
            try {
                editingDomain.runExclusive(runnable);
            }
            catch (InterruptedException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getDefault(), (Object)ex);
            }
        } else {
            runnable.run();
        }
    }

    protected void createProblemMarkerForDiagnostic(IFile file, ExtendedResource extendedResource, Resource.Diagnostic diagnostic, int severity) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)diagnostic);
        IResourceProblemMarkerFactory resourceProblemMarkerFactory = this.getResourceProblemMarkerFactory(file);
        resourceProblemMarkerFactory.createProblemMarker((IResource)file, diagnostic, severity, this.getProblemHandlingOptions(file));
    }

    protected void createProblemMarkerForException(IFile file, Exception exception, int severity) throws CoreException {
        Assert.isNotNull((Object)file);
        Assert.isNotNull((Object)exception);
        IResourceProblemMarkerFactory resourceProblemMarkerFactory = this.getResourceProblemMarkerFactory(file);
        resourceProblemMarkerFactory.createProblemMarker((IResource)file, exception, severity);
    }

    private IResourceProblemMarkerFactory getResourceProblemMarkerFactory(IFile file) {
        Object markerFactory;
        Map<Object, Object> problemHandlingOptions = this.getProblemHandlingOptions(file);
        if (problemHandlingOptions != null && (markerFactory = problemHandlingOptions.get("PROBLEM_MARKER_FACTORY")) instanceof IResourceProblemMarkerFactory) {
            return (IResourceProblemMarkerFactory)markerFactory;
        }
        return this.createResourceProblemMarkerFactory(file);
    }

    private IResourceProblemMarkerFactory createResourceProblemMarkerFactory(IFile file) {
        if (EcorePlatformUtil.getResource(file) instanceof XMLResource) {
            return new XMLResourceProblemMarkerFactory();
        }
        return new BasicResourceProblemMarkerFactory();
    }

    private Map<Object, Object> getProblemHandlingOptions(IFile file) {
        ExtendedResource extendedResource;
        Resource resource = EcorePlatformUtil.getResource(file);
        if (resource != null && (extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt((Notifier)resource)) != null) {
            return extendedResource.getProblemHandlingOptions();
        }
        return null;
    }
}

