/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.platform.util;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ExtensionClassDescriptor<T> {
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_OVERRIDE = "override";
    private String contributorPluginId;
    private String id;
    private String className = null;
    private String override;
    private T instance;

    public ExtensionClassDescriptor(IConfigurationElement configurationElement) {
        Assert.isNotNull((Object)configurationElement);
        this.contributorPluginId = configurationElement.getContributor().getName();
        Assert.isNotNull((Object)this.contributorPluginId);
        this.className = configurationElement.getAttribute(ATTR_CLASS);
        Assert.isNotNull((Object)this.className);
        this.id = configurationElement.getAttribute(ATTR_ID);
        this.override = configurationElement.getAttribute(ATTR_OVERRIDE);
    }

    public String getContributorPluginId() {
        return this.contributorPluginId;
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className != null ? this.className : null;
    }

    public String getOverride() {
        return this.override;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getInstance() throws Exception {
        if (this.instance == null) {
            ExtensionClassDescriptor extensionClassDescriptor = this;
            synchronized (extensionClassDescriptor) {
                this.instance = this.newInstance();
            }
        }
        return this.instance;
    }

    public T newInstance() throws Exception {
        Bundle bundle = Platform.getBundle((String)this.contributorPluginId);
        if (bundle == null) {
            throw new IllegalStateException("Cannot locate contributor plug-in '" + this.contributorPluginId + "'");
        }
        Class clazz = bundle.loadClass(this.className);
        return clazz.newInstance();
    }

    public boolean overrides(ExtensionClassDescriptor<?> otherDescriptor) {
        if (otherDescriptor == null) {
            return true;
        }
        return otherDescriptor.getId().equals(this.getOverride());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.contributorPluginId.hashCode();
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + this.className.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtensionClassDescriptor other = (ExtensionClassDescriptor)obj;
        if (!this.contributorPluginId.equals(other.contributorPluginId)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.className.equals(other.className);
    }
}

