/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.metamodel.services;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.internal.messages.Messages;
import org.eclipse.sphinx.emf.internal.metamodel.services.ServiceClassDescriptor;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.services.IMetaModelService;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.sphinx.platform.util.StatusUtil;

public class MetaModelServiceRegistry {
    private static final String EXTP_META_MODEL_SERVICES = String.valueOf(Activator.INSTANCE.getSymbolicName()) + ".metaModelServices";
    private static final String NODE_SERVICE = "service";
    static final MetaModelServiceRegistry INSTANCE = new MetaModelServiceRegistry(Platform.getExtensionRegistry(), PlatformLogUtil.getLog((Plugin)Activator.getPlugin()));
    private Map<IMetaModelDescriptor, Map<Class<IMetaModelService>, ServiceClassDescriptor>> mmServices = null;
    private IExtensionRegistry extensionRegistry;
    private ILog logger;

    private MetaModelServiceRegistry(IExtensionRegistry extensionRegistry, ILog logger) {
        Assert.isNotNull((Object)extensionRegistry);
        Assert.isNotNull((Object)logger);
        this.extensionRegistry = extensionRegistry;
        this.logger = logger;
    }

    private Map<IMetaModelDescriptor, Map<Class<IMetaModelService>, ServiceClassDescriptor>> getMetaModelServices() {
        this.initialize();
        return this.mmServices != null ? this.mmServices : Collections.emptyMap();
    }

    private void initialize() {
        if (this.extensionRegistry == null) {
            return;
        }
        if (this.mmServices == null) {
            this.mmServices = new HashMap<IMetaModelDescriptor, Map<Class<IMetaModelService>, ServiceClassDescriptor>>();
            HashMap<String, ServiceClassDescriptor> mmServiceIdToMMServiceClassDescriptorMap = new HashMap<String, ServiceClassDescriptor>();
            IConfigurationElement[] iConfigurationElementArray = this.extensionRegistry.getConfigurationElementsFor(EXTP_META_MODEL_SERVICES);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement mmServiceConfigurationElement = iConfigurationElementArray[n2];
                try {
                    if (NODE_SERVICE.equals(mmServiceConfigurationElement.getName())) {
                        ServiceClassDescriptor mmServiceClassDescriptor = new ServiceClassDescriptor(mmServiceConfigurationElement);
                        String mmServiceId = mmServiceClassDescriptor.getId();
                        if (mmServiceIdToMMServiceClassDescriptorMap.containsKey(mmServiceId)) {
                            this.logWarning(Messages.warning_serviceIdNotUnique, mmServiceId);
                        } else {
                            mmServiceIdToMMServiceClassDescriptorMap.put(mmServiceId, mmServiceClassDescriptor);
                        }
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
                ++n2;
            }
            for (ServiceClassDescriptor mmServiceClassDescriptor : mmServiceIdToMMServiceClassDescriptorMap.values()) {
                try {
                    String override = mmServiceClassDescriptor.getOverride();
                    if (override != null && !mmServiceIdToMMServiceClassDescriptorMap.containsKey(override)) {
                        this.logWarning(Messages.warning_noServiceToOverride, mmServiceClassDescriptor.getId(), override);
                        continue;
                    }
                    List<IMetaModelDescriptor> mmDescriptors = mmServiceClassDescriptor.getMetaModelDescriptors();
                    Set<String> unknownMMDescriptorIdPatterns = mmServiceClassDescriptor.getUnknownMetaModelDescIdPatterns();
                    if (mmDescriptors.isEmpty() && unknownMMDescriptorIdPatterns.isEmpty()) {
                        this.logWarning(Messages.error_missingMetaModelDescriptor, mmServiceClassDescriptor.getContributorPluginId());
                        continue;
                    }
                    if (!unknownMMDescriptorIdPatterns.isEmpty()) {
                        this.logWarning(Messages.error_unknownMetaModel, mmServiceClassDescriptor.getContributorPluginId(), EXTP_META_MODEL_SERVICES, unknownMMDescriptorIdPatterns);
                    }
                    for (IMetaModelDescriptor mmDescriptor : mmDescriptors) {
                        this.addService(mmDescriptor, mmServiceClassDescriptor);
                    }
                }
                catch (Exception ex) {
                    this.logError(ex);
                }
            }
            mmServiceIdToMMServiceClassDescriptorMap.clear();
        }
    }

    private void addService(IMetaModelDescriptor mmDescriptor, ServiceClassDescriptor newMMServiceClassDescriptor) {
        try {
            ServiceClassDescriptor existingMMServiceClassDescriptor;
            Map<Class<IMetaModelService>, ServiceClassDescriptor> mmServicesForMetaModel = this.mmServices.get(mmDescriptor);
            if (mmServicesForMetaModel == null) {
                mmServicesForMetaModel = new HashMap<Class<IMetaModelService>, ServiceClassDescriptor>();
                this.mmServices.put(mmDescriptor, mmServicesForMetaModel);
            }
            if ((existingMMServiceClassDescriptor = mmServicesForMetaModel.get(newMMServiceClassDescriptor.getServiceType())) == null) {
                mmServicesForMetaModel.put(newMMServiceClassDescriptor.getServiceType(), newMMServiceClassDescriptor);
            } else if (newMMServiceClassDescriptor.overrides(existingMMServiceClassDescriptor)) {
                mmServicesForMetaModel.put(newMMServiceClassDescriptor.getServiceType(), newMMServiceClassDescriptor);
            } else if (!existingMMServiceClassDescriptor.overrides(newMMServiceClassDescriptor)) {
                this.logWarning(Messages.error_metaModelServiceAlreadyExists, newMMServiceClassDescriptor.getServiceType(), mmDescriptor.getIdentifier());
            }
        }
        catch (IllegalArgumentException ex) {
            this.logWarning(ex);
        }
    }

    protected <T extends IMetaModelService> T getService(IMetaModelDescriptor mmDescriptor, Class<T> mmServiceType) {
        ServiceClassDescriptor mmServiceClassDescriptor;
        Map<Class<IMetaModelService>, ServiceClassDescriptor> mmServicesForMetaModel = this.getMetaModelServices().get(mmDescriptor);
        if (mmServicesForMetaModel != null && (mmServiceClassDescriptor = mmServicesForMetaModel.get(mmServiceType)) != null) {
            try {
                IMetaModelService mmService = (IMetaModelService)mmServiceClassDescriptor.getInstance();
                if (mmServiceType.isInstance(mmService)) {
                    return (T)mmService;
                }
                this.logError(Messages.error_invalidMetaModelServiceClass, mmServiceType.getName(), mmService.getClass().getName());
            }
            catch (Throwable ex) {
                this.logError(ex);
            }
        }
        return null;
    }

    private void logWarning(String msg, Object ... objects) {
        this.logWarning(new RuntimeException(NLS.bind((String)msg, (Object[])objects)));
    }

    private void logWarning(Throwable throwable) {
        this.logger.log(StatusUtil.createWarningStatus((Plugin)Activator.getDefault(), (Object)throwable));
    }

    private void logError(String msg, Object ... objects) {
        this.logError(new RuntimeException(NLS.bind((String)msg, (Object[])objects)));
    }

    private void logError(Throwable throwable) {
        this.logger.log(StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)throwable));
    }
}

