/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.internal.DefaultSWTFontRegistry;
import org.eclipse.swt.internal.SWTFontRegistry;
import org.eclipse.swt.internal.ScalingSWTFontRegistry;
import org.eclipse.swt.widgets.Display;

public class SWTFontProvider {
    private static final Map<Device, SWTFontRegistry> fontRegistries = new ConcurrentHashMap<Device, SWTFontRegistry>();

    private static SWTFontRegistry getFontRegistry(Device device) {
        return fontRegistries.computeIfAbsent(device, SWTFontProvider::newFontRegistry);
    }

    public static Font getSystemFont(Device device, int zoom) {
        return SWTFontProvider.getFontRegistry(device).getSystemFont(zoom);
    }

    public static long getSystemFontHandle(Device device, int zoom) {
        return Font.win32_getHandle(SWTFontProvider.getSystemFont(device, zoom));
    }

    public static Font getFont(Device device, FontData fontData, int zoom) {
        return SWTFontProvider.getFontRegistry(device).getFont(fontData, zoom);
    }

    public static long getFontHandle(Device device, FontData fontData, int zoom) {
        return Font.win32_getHandle(SWTFontProvider.getFont(device, fontData, zoom));
    }

    public static long getFontHandle(Font font, int zoom) {
        if (font == null) {
            SWT.error(4);
        }
        return Font.win32_getHandle(SWTFontProvider.getFont(font.getDevice(), font.getFontData()[0], zoom));
    }

    public static Font getFont(Device device, long fontHandle, int zoom) {
        return SWTFontProvider.getFontRegistry(device).getFont(fontHandle, zoom);
    }

    public static void disposeFontRegistry(Device device) {
        SWTFontRegistry fontRegistry = fontRegistries.remove(device);
        if (fontRegistry != null) {
            fontRegistry.dispose();
        }
    }

    private static SWTFontRegistry newFontRegistry(Device device) {
        Display display;
        if (device instanceof Display && (display = (Display)device).isRescalingAtRuntime()) {
            return new ScalingSWTFontRegistry(device);
        }
        return new DefaultSWTFontRegistry(device);
    }
}

