/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.initializationservice;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Set;
import org.eclipse.set.core.services.initialization.InitializationService;
import org.eclipse.set.core.services.initialization.InitializationStep;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true)
public class InitializationServiceImpl
implements InitializationService {
    private final Set<InitializationStep> steps = Sets.newHashSet();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void addStep(InitializationStep step) {
        this.steps.add(step);
    }

    public <M, C extends InitializationStep.Configuration> void init(M model, C configuaration) {
        this.steps.stream().sorted(new StepComparator()).forEach(step -> step.init(model, configuaration));
    }

    public void removeStep(InitializationStep step) {
        this.steps.remove(step);
    }

    static class StepComparator
    implements Comparator<InitializationStep> {
        StepComparator() {
        }

        @Override
        public int compare(InitializationStep s1, InitializationStep s2) {
            return Integer.compare(s2.getPriority(), s1.getPriority());
        }
    }
}

