/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table.sorting;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.sort.SortDirectionEnum;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.CompareTableCellContent;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

abstract class AbstractCellComparator
implements Comparator<TableCell> {
    protected SortDirectionEnum direction;

    public AbstractCellComparator(SortDirectionEnum direction) {
        this.direction = direction;
    }

    @Override
    public int compare(TableCell cell1, TableCell cell2) {
        return this.compareDispatch(cell1.getContent(), cell2.getContent());
    }

    private int _compareDispatch(CellContent c1, CellContent c2) {
        StringConcatenation _builder = new StringConcatenation();
        String _simpleName = c1.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(" vs. ");
        String _simpleName_1 = c2.getClass().getSimpleName();
        _builder.append(_simpleName_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    private int _compareDispatch(Void c1, Void c2) {
        return 0;
    }

    private int _compareDispatch(Void c1, CellContent c2) {
        return -1;
    }

    private int _compareDispatch(CellContent c1, Void c2) {
        return 1;
    }

    private int _compareDispatch(StringCellContent c1, StringCellContent c2) {
        return this.compareCell((Iterable<String>)c1.getValue(), (Iterable<String>)c2.getValue());
    }

    private int _compareDispatch(CompareCellContent c1, CompareCellContent c2) {
        return this.compareCell(this.compareCellContentString(c1), this.compareCellContentString(c2));
    }

    private int _compareDispatch(List<String> value1, List<String> value2) {
        if (StringExtensions.isNullOrEmpty((String)IterableExtensions.join(value1)) || StringExtensions.isNullOrEmpty((String)IterableExtensions.join(value2))) {
            return 0;
        }
        return this.compareCell(value1, value2);
    }

    private int _compareDispatch(StringCellContent c1, CompareCellContent c2) {
        return this.compareCell((Iterable<String>)c1.getValue(), this.compareCellContentString(c2));
    }

    private int _compareDispatch(CompareCellContent c1, StringCellContent c2) {
        return this.compareCell(this.compareCellContentString(c1), (Iterable<String>)c2.getValue());
    }

    private int _compareDispatch(CompareTableCellContent c1, CellContent c2) {
        return this.compareDispatch(c1.getMainPlanCellContent(), c2);
    }

    private int _compareDispatch(CellContent c1, CompareTableCellContent c2) {
        return this.compareDispatch(c1, c2.getMainPlanCellContent());
    }

    private int _compareDispatch(CompareTableCellContent c1, CompareTableCellContent c2) {
        return this.compareDispatch(c1.getMainPlanCellContent(), c2.getMainPlanCellContent());
    }

    private Iterable<String> compareCellContentString(CompareCellContent content) {
        EList _newValue = content.getNewValue();
        EList _oldValue = content.getOldValue();
        return IterableExtensions.toSet((Iterable)Iterables.concat(Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new EList[]{_newValue, _oldValue}))));
    }

    private boolean isInteger(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (Throwable _t) {
            if (_t instanceof NumberFormatException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private Pair<String, String> splitNumericPrefix(String text) {
        boolean _equals;
        if (text == null) {
            return Pair.of((Object)"", (Object)"");
        }
        String[] result = text.split("((?=\\D)|(?<=\\D))", 2);
        String first = result[0];
        int _length = result.length;
        boolean bl = _equals = _length == 1;
        if (_equals) {
            Pair _xifexpression = null;
            boolean _isInteger = this.isInteger(first);
            if (_isInteger) {
                String _get = result[0];
                _xifexpression = Pair.of((Object)_get, (Object)"");
            } else {
                String _get_1 = result[0];
                _xifexpression = Pair.of((Object)"", (Object)_get_1);
            }
            return _xifexpression;
        }
        String second = result[1];
        Pair _xifexpression_1 = null;
        boolean _isInteger_1 = this.isInteger(first);
        _xifexpression_1 = _isInteger_1 ? Pair.of((Object)first, (Object)second) : Pair.of((Object)"", (Object)(first + second));
        return _xifexpression_1;
    }

    public int compareCell(Iterable<String> iterable1, Iterable<String> iterable2) {
        int intCompare;
        Pair<String, String> text1 = this.splitNumericPrefix(CellContentExtensions.iterableToString(iterable1, (String)""));
        Pair<String, String> text2 = this.splitNumericPrefix(CellContentExtensions.iterableToString(iterable2, (String)""));
        int minPrefixLength = Math.min(((String)text1.getKey()).length(), ((String)text2.getKey()).length());
        String intPrefix1 = ((String)text1.getKey()).substring(0, minPrefixLength);
        String intPrefix2 = ((String)text2.getKey()).substring(0, minPrefixLength);
        String _substring = ((String)text1.getKey()).substring(minPrefixLength);
        String _value = (String)text1.getValue();
        String textSuffix1 = _substring + _value;
        String _substring_1 = ((String)text2.getKey()).substring(minPrefixLength);
        String _value_1 = (String)text2.getValue();
        String textSuffix2 = _substring_1 + _value_1;
        if (minPrefixLength > 0 && (intCompare = this.compareInt(Integer.parseInt(intPrefix1), Integer.parseInt(intPrefix2))) != 0) {
            return intCompare;
        }
        return this.compareString(textSuffix1, textSuffix2);
    }

    public abstract int compareString(String var1, String var2);

    public int compareInt(int number1, int number2) {
        boolean _equals = Objects.equals(this.direction, SortDirectionEnum.ASC);
        if (_equals) {
            return Integer.valueOf(number1).compareTo(number2);
        }
        return Integer.valueOf(number2).compareTo(number1);
    }

    @XbaseGenerated
    private int compareDispatch(Object value1, Object value2) {
        if (value1 instanceof List && value2 instanceof List) {
            return this._compareDispatch((List)value1, (List)value2);
        }
        if (value1 instanceof CompareCellContent && value2 instanceof CompareCellContent) {
            return this._compareDispatch((CompareCellContent)value1, (CompareCellContent)value2);
        }
        if (value1 instanceof CompareCellContent && value2 instanceof StringCellContent) {
            return this._compareDispatch((CompareCellContent)value1, (StringCellContent)value2);
        }
        if (value1 instanceof CompareTableCellContent && value2 instanceof CompareTableCellContent) {
            return this._compareDispatch((CompareTableCellContent)value1, (CompareTableCellContent)value2);
        }
        if (value1 instanceof StringCellContent && value2 instanceof CompareCellContent) {
            return this._compareDispatch((StringCellContent)value1, (CompareCellContent)value2);
        }
        if (value1 instanceof StringCellContent && value2 instanceof StringCellContent) {
            return this._compareDispatch((StringCellContent)value1, (StringCellContent)value2);
        }
        if (value1 instanceof CompareTableCellContent && value2 instanceof CellContent) {
            return this._compareDispatch((CompareTableCellContent)value1, (CellContent)value2);
        }
        if (value1 instanceof CellContent && value2 instanceof CompareTableCellContent) {
            return this._compareDispatch((CellContent)value1, (CompareTableCellContent)value2);
        }
        if (value1 instanceof CellContent && value2 instanceof CellContent) {
            return this._compareDispatch((CellContent)value1, (CellContent)value2);
        }
        if (value1 instanceof CellContent && value2 == null) {
            return this._compareDispatch((CellContent)value1, (Void)null);
        }
        if (value1 == null && value2 instanceof CellContent) {
            return this._compareDispatch((Void)null, (CellContent)value2);
        }
        if (value1 == null && value2 == null) {
            return this._compareDispatch((Void)null, (Void)null);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(value1, value2).toString());
    }
}

