/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.table;

import com.google.common.collect.Streams;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.CompareTableCellContent;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.table.Pt1TableChangeProperties;
import org.eclipse.set.utils.table.TableSpanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableModelInstanceBodyDataProvider
implements ISpanningDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(TableModelInstanceBodyDataProvider.class);
    private static final String NULL_VALUE = "";
    private final List<TableRow> instances;
    private final int propertyCount;
    private final TableSpanUtils spanUtils;
    private final SessionService sessionService;

    public TableModelInstanceBodyDataProvider(int propertyCount, List<TableRow> instances, SessionService sessionService) {
        this.instances = instances;
        this.propertyCount = propertyCount;
        this.spanUtils = new TableSpanUtils(instances);
        this.sessionService = sessionService;
    }

    public int getColumnCount() {
        return this.propertyCount;
    }

    public Object getDataValue(int columnIndex, int rowIndex) {
        String value = TableRowExtensions.getRichTextValue((TableRow)this.instances.get(rowIndex), (int)columnIndex);
        if (value == null) {
            logger.debug("column={} row={} is empty", (Object)columnIndex, (Object)rowIndex);
            return NULL_VALUE;
        }
        return value;
    }

    public int getRowCount() {
        return this.instances.size();
    }

    public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
    }

    public DataCell getCellByPosition(int column, int row) {
        if (!this.spanUtils.isMergeAllowed(column, row)) {
            return new DataCell(column, row, 1, 1);
        }
        int spanUp = this.spanUtils.getRowSpanUp(column, row);
        int spanDown = this.spanUtils.getRowSpanDown(column, row);
        int startRow = row - spanUp;
        int spanSize = spanUp + spanDown + 1;
        return new DataCell(column, startRow, 1, spanSize);
    }

    public void updateContent(TableType tableType, Pt1TableChangeProperties properties) {
        if (tableType != TableType.DIFF) {
            if (tableType.getContainerForTable() == properties.getContainerType()) {
                Optional<TableRow> first = this.instances.stream().filter(e -> e.equals(properties.getRow())).findFirst();
                if (first.isEmpty()) {
                    return;
                }
                TableRowExtensions.set((TableRow)first.get(), (ColumnDescriptor)properties.getChangeDataColumn(), properties.getNewValues(), (String)properties.getSeparator());
            }
            return;
        }
        List<TableRow> filterRows = this.instances.stream().filter(e -> TableRowExtensions.getLeadingObjectGuid((TableRow)e).equals(TableRowExtensions.getLeadingObjectGuid((TableRow)properties.getRow()))).filter(e -> {
            Optional<String> cellContent = Optional.ofNullable(TableRowExtensions.getPlainStringValue((TableRow)e, (ColumnDescriptor)properties.getChangeDataColumn()));
            return !cellContent.isEmpty() && !cellContent.get().isBlank() && !cellContent.get().isEmpty();
        }).toList();
        if (filterRows.isEmpty()) {
            return;
        }
        filterRows.forEach(row -> {
            TableCell cell = TableRowExtensions.getCell((TableRow)row, (ColumnDescriptor)properties.getChangeDataColumn());
            CellContent newContent = this.getNewContent(cell.getContent(), properties);
            cell.setContent(newContent);
        });
    }

    private CellContent getNewContent(CellContent oldContent, Pt1TableChangeProperties properties) {
        CellContent cellContent = oldContent;
        Objects.requireNonNull(cellContent);
        CellContent cellContent2 = cellContent;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringCellContent.class, CompareCellContent.class, CompareTableCellContent.class}, (Object)cellContent2, 0)) {
            case 0 -> {
                StringCellContent stringContent = (StringCellContent)cellContent2;
                yield TableModelInstanceBodyDataProvider.getNewContent(stringContent, properties);
            }
            case 1 -> {
                CompareCellContent compareContent = (CompareCellContent)cellContent2;
                yield TableModelInstanceBodyDataProvider.getNewContent(compareContent, properties);
            }
            case 2 -> {
                CompareTableCellContent compareTableContent = (CompareTableCellContent)cellContent2;
                yield this.getNewContent(compareTableContent, properties);
            }
            default -> throw new UnsupportedOperationException();
        };
    }

    private static CellContent getNewContent(StringCellContent oldContent, Pt1TableChangeProperties properties) {
        List<String> currentValues = StreamSupport.stream(CellContentExtensions.getStringValueIterable((CellContent)oldContent).spliterator(), false).toList();
        if (currentValues.size() == 1 && ((String)currentValues.getFirst()).equals("\u23f3")) {
            StringCellContent newContent = TablemodelFactory.eINSTANCE.createStringCellContent();
            newContent.getValue().addAll(properties.getNewValues());
            newContent.setSeparator(properties.getSeparator());
            return newContent;
        }
        if (!TableModelInstanceBodyDataProvider.equalsValues(currentValues, properties.getNewValues())) {
            if (properties.getContainerType() == ContainerType.INITIAL) {
                return TableModelInstanceBodyDataProvider.createCompareCellContent(properties.getNewValues(), currentValues, oldContent.getSeparator());
            }
            return TableModelInstanceBodyDataProvider.createCompareCellContent(currentValues, properties.getNewValues(), oldContent.getSeparator());
        }
        return oldContent;
    }

    private static CellContent getNewContent(CompareCellContent oldContent, Pt1TableChangeProperties properties) {
        ContainerType containerType = properties.getContainerType();
        switch (containerType) {
            case FINAL: {
                if (TableModelInstanceBodyDataProvider.equalsValues((List<String>)oldContent.getNewValue(), properties.getNewValues())) break;
                return TableModelInstanceBodyDataProvider.createCompareCellContent((List<String>)oldContent.getOldValue(), properties.getNewValues(), oldContent.getSeparator());
            }
            case INITIAL: {
                if (TableModelInstanceBodyDataProvider.equalsValues((List<String>)oldContent.getOldValue(), properties.getNewValues())) break;
                return TableModelInstanceBodyDataProvider.createCompareCellContent(properties.getNewValues(), (List<String>)oldContent.getNewValue(), oldContent.getSeparator());
            }
            default: {
                throw new IllegalArgumentException("SingelState can't have compare cell content");
            }
        }
        return null;
    }

    private CellContent getNewContent(CompareTableCellContent oldContent, Pt1TableChangeProperties properties) {
        PlanPro_Schnittstelle planProSchnittstelle = properties.getPlanProSchnittstelle();
        Optional<Map.Entry> targetSession = this.sessionService.getLoadedSessions().entrySet().stream().filter(entry -> ((IModelSession)entry.getValue()).getPlanProSchnittstelle().equals(planProSchnittstelle)).findFirst();
        if (targetSession.isEmpty()) {
            return null;
        }
        CompareTableCellContent clone = (CompareTableCellContent)EcoreUtil.copy((EObject)oldContent);
        switch ((ToolboxFileRole)targetSession.get().getKey()) {
            case SESSION: {
                clone.setMainPlanCellContent(this.getNewContent(oldContent.getMainPlanCellContent(), properties));
                break;
            }
            case COMPARE_PLANNING: {
                clone.setComparePlanCellContent(this.getNewContent(oldContent.getComparePlanCellContent(), properties));
                break;
            }
            default: {
                return null;
            }
        }
        Set mainPlanCellValues = Streams.stream((Iterable)CellContentExtensions.getStringValueIterable((CellContent)clone.getMainPlanCellContent())).filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
        Set comparePlanCellValues = Streams.stream((Iterable)CellContentExtensions.getStringValueIterable((CellContent)clone.getComparePlanCellContent())).filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
        return mainPlanCellValues.equals(comparePlanCellValues) ? clone.getMainPlanCellContent() : clone;
    }

    private static CompareCellContent createCompareCellContent(List<String> oldValues, List<String> newValues, String separator) {
        CompareCellContent compareContent = TablemodelFactory.eINSTANCE.createCompareCellContent();
        compareContent.getOldValue().addAll(oldValues);
        compareContent.getNewValue().addAll(newValues);
        compareContent.setSeparator(separator);
        return compareContent;
    }

    private static boolean equalsValues(List<String> oldValues, List<String> newValues) {
        if (oldValues.size() == newValues.size()) {
            if (oldValues.stream().allMatch(newValues::contains)) {
                return true;
            }
        }
        return false;
    }
}

