/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.Aprational;

class ContinuedFractionHelper {
    private ContinuedFractionHelper() {
    }

    public static Iterator<Apint> continuedFraction(Apfloat x) throws ApfloatRuntimeException {
        return new ContinuedFractionIterator<Apfloat>(x){

            @Override
            protected Apfloat subtract(Apfloat x, Apint y) {
                return x.subtract(y);
            }

            @Override
            protected Apfloat inverse(Apfloat x) {
                return ApfloatMath.inverseRoot(x, 1L);
            }
        };
    }

    public static Iterator<Apint> continuedFraction(Aprational x) throws ApfloatRuntimeException {
        return new ContinuedFractionIterator<Aprational>(x){

            @Override
            protected Aprational subtract(Aprational x, Apint y) {
                return x.subtract(y);
            }

            @Override
            protected Aprational inverse(Aprational x) {
                return Aprational.ONE.divide(x);
            }
        };
    }

    public static Iterator<Aprational> convergents(final Iterator<Apint> continuedFraction, final int radix) {
        return new Iterator<Aprational>(){
            private Apint h1;
            private Apint h2;
            private Apint k1;
            private Apint k2;
            {
                this.h1 = Apint.ONES[radix];
                this.h2 = Apint.ZEROS[radix];
                this.k1 = Apint.ZEROS[radix];
                this.k2 = Apint.ONES[radix];
            }

            @Override
            public boolean hasNext() {
                return continuedFraction.hasNext();
            }

            @Override
            public Aprational next() {
                Apint a = (Apint)continuedFraction.next();
                Apint numerator = a.multiply(this.h1).add(this.h2);
                Apint denominator = a.multiply(this.k1).add(this.k2);
                this.h2 = this.h1;
                this.k2 = this.k1;
                this.h1 = numerator;
                this.k1 = denominator;
                return new Aprational(numerator, denominator);
            }
        };
    }

    private static abstract class ContinuedFractionIterator<T extends Apfloat>
    implements Iterator<Apint> {
        private Apint i;
        private T f;

        public ContinuedFractionIterator(T x) {
            this.i = ((Apfloat)x).truncate();
            this.f = this.subtract(x, this.i);
        }

        @Override
        public boolean hasNext() {
            return this.i != null;
        }

        @Override
        public Apint next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Apint next = this.i;
            if (((Apfloat)this.f).signum() == 0) {
                this.i = null;
            } else {
                T x = this.inverse(this.f);
                this.i = ((Apfloat)x).truncate();
                this.f = this.subtract(x, this.i);
            }
            return next;
        }

        protected abstract T subtract(T var1, Apint var2);

        protected abstract T inverse(T var1);
    }
}

