/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.validation;

import org.eclipse.set.basis.constants.ValidationResult;
import org.eclipse.set.basis.exceptions.CustomValidationProblem;
import org.eclipse.set.basis.files.PlanProFileResource;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.validation.CustomValidator;
import org.eclipse.set.feature.validation.AbstractCustomValidator;
import org.eclipse.set.feature.validation.CustomValidationProblemImpl;
import org.eclipse.set.model.validationreport.ValidationSeverity;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CustomValidator.class})
public class LayoutInfoRequired
extends AbstractCustomValidator {
    public static final String LAYOUT_VALIDATION_TYPE = "Metainformationen";

    public void validate(ToolboxFile toolboxFile, ValidationResult result, CustomValidator.FileType type) {
        try {
            if (type == CustomValidator.FileType.Layout) {
                result.addCustomProblem((CustomValidationProblem)new CustomValidationProblemImpl("Layoutinformationen sind vorhanden", ValidationSeverity.SUCCESS, this.validationType(), null, null, null));
            } else if (type == CustomValidator.FileType.Model) {
                toolboxFile.openLayout();
                PlanProFileResource layoutResource = toolboxFile.getLayoutResource();
                if (layoutResource == null) {
                    result.addCustomProblem((CustomValidationProblem)this.layoutMissing());
                }
            }
        }
        catch (Exception ex) {
            result.addCustomProblem((CustomValidationProblem)this.layoutMissing());
        }
    }

    private CustomValidationProblemImpl layoutMissing() {
        return new CustomValidationProblemImpl("Layoutinformationen fehlen", ValidationSeverity.WARNING, this.validationType(), null, null, null);
    }

    public String validationType() {
        return LAYOUT_VALIDATION_TYPE;
    }
}

