/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.tablediff;

import com.google.common.collect.Streams;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.Basisobjekte.Bearbeitungsvermerk;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.CompareCellContent;
import org.eclipse.set.model.tablemodel.CompareFootnoteContainer;
import org.eclipse.set.model.tablemodel.CompareTableCellContent;
import org.eclipse.set.model.tablemodel.FootnoteContainer;
import org.eclipse.set.model.tablemodel.MultiColorCellContent;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.SimpleFootnoteContainer;
import org.eclipse.set.model.tablemodel.StringCellContent;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.CellContentExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableCellExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.services.table.TableDiffService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class CustomTableDiffService
implements TableDiffService {
    @Reference
    SessionService sessionService;

    private static void addEmptyValue(TableRow row, ColumnDescriptor descriptor) {
        TableCell cell = TablemodelFactory.eINSTANCE.createTableCell();
        cell.setColumndescriptor(descriptor);
        StringCellContent content = TablemodelFactory.eINSTANCE.createStringCellContent();
        content.getValue().add((Object)"");
        cell.setContent((CellContent)content);
        row.getCells().add((Object)cell);
    }

    private static void addMissingRowGroup(RowGroup group, Table table) {
        int groupId;
        RowGroup match;
        Identitaet_TypeClass identitaet;
        String groupGuid = null;
        Ur_Objekt leadingObject = group.getLeadingObject();
        if (leadingObject != null && (identitaet = leadingObject.getIdentitaet()) != null) {
            groupGuid = identitaet.getWert();
        }
        if ((match = TableExtensions.getGroupById((Table)table, groupGuid, (int)(groupId = group.getLeadingObjectIndex()))) == null) {
            RowGroup newRowGroup = TablemodelFactory.eINSTANCE.createRowGroup();
            newRowGroup.setLeadingObject(group.getLeadingObject());
            newRowGroup.setLeadingObjectIndex(group.getLeadingObjectIndex());
            for (TableRow element : group.getRows()) {
                TableRow newRow = TablemodelFactory.eINSTANCE.createTableRow();
                newRowGroup.getRows().add((Object)newRow);
                List columns = TableExtensions.getColumns((Table)table);
                columns.forEach(column -> CustomTableDiffService.addEmptyValue(newRow, column));
            }
            if (table.getTablecontent() == null) {
                table.setTablecontent(TablemodelFactory.eINSTANCE.createTableContent());
            }
            table.getTablecontent().getRowgroups().add((Object)newRowGroup);
        }
    }

    private static void createDiffContent(int i, TableRow row, TableRow match, BiFunction<TableCell, TableCell, CellContent> createCompareContent) {
        TableCell oldCell = (TableCell)row.getCells().get(i);
        TableCell newCell = TablemodelFactory.eINSTANCE.createTableCell();
        newCell.setContent((CellContent)TablemodelFactory.eINSTANCE.createStringCellContent());
        if (match != null) {
            newCell = (TableCell)match.getCells().get(i);
        }
        if (oldCell.getContent() instanceof MultiColorCellContent) {
            CustomTableDiffService.createMultiColorDiffCotent(oldCell, newCell);
            return;
        }
        CellContent compareCellContent = createCompareContent.apply(oldCell, newCell);
        if (compareCellContent == null) {
            return;
        }
        oldCell.setContent(compareCellContent);
    }

    private static void createMultiColorDiffCotent(TableCell oldCell, TableCell newCell) {
        if (oldCell.getContent() instanceof MultiColorCellContent) {
            CellContent cellContent;
            if (newCell != null && (cellContent = newCell.getContent()) instanceof MultiColorCellContent) {
                MultiColorCellContent newCellContent = (MultiColorCellContent)cellContent;
                MultiColorCellContent clone = (MultiColorCellContent)EcoreUtil.copy((EObject)newCellContent);
                oldCell.setContent((CellContent)clone);
            }
            MultiColorCellContent oldCellContent = (MultiColorCellContent)oldCell.getContent();
            oldCellContent.getValue().forEach(e -> e.setDisableMultiColor(false));
        }
    }

    private static CompareCellContent createCompareCellContent(TableCell oldCell, TableCell newCell) {
        Set newValues;
        Set oldValues = TableCellExtensions.getIterableStringValue((TableCell)oldCell);
        Set set = newValues = newCell == null ? Collections.emptySet() : TableCellExtensions.getIterableStringValue((TableCell)newCell);
        if (oldValues.equals(newValues)) {
            return null;
        }
        CompareCellContent compareContent = TablemodelFactory.eINSTANCE.createCompareCellContent();
        compareContent.getOldValue().addAll((Collection)oldValues);
        compareContent.getNewValue().addAll((Collection)newValues);
        compareContent.setSeparator((String)EObjectExtensions.getNullableObject((Object)oldCell, c -> c.getContent().getSeparator()).orElse(null));
        return compareContent;
    }

    private CompareTableCellContent createTableCompareCellContent(TableCell mainTableCell, TableCell compareTableCell) {
        if (this.isSameValue((CellContent)EObjectExtensions.getNullableObject((Object)mainTableCell, TableCell::getContent).orElse(null), (CellContent)EObjectExtensions.getNullableObject((Object)compareTableCell, TableCell::getContent).orElse(null))) {
            return null;
        }
        CompareTableCellContent compareTableCellContent = TablemodelFactory.eINSTANCE.createCompareTableCellContent();
        compareTableCellContent.setMainPlanCellContent(mainTableCell.getContent());
        compareTableCellContent.setComparePlanCellContent(compareTableCell == null || compareTableCell.getContent() == null ? null : compareTableCell.getContent());
        return compareTableCellContent;
    }

    private boolean isSameValue(CellContent first, CellContent second) {
        if (first == null || second == null) {
            return first == second;
        }
        CellContent cellContent = first;
        Objects.requireNonNull(cellContent);
        CellContent cellContent2 = cellContent;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringCellContent.class, CompareCellContent.class, MultiColorCellContent.class}, (Object)cellContent2, 0)) {
            case 0 -> {
                StringCellContent stringContent = (StringCellContent)cellContent2;
                yield this.isSameValue(stringContent, second);
            }
            case 1 -> {
                CompareCellContent compareContent = (CompareCellContent)cellContent2;
                yield this.isSameValue(compareContent, second);
            }
            case 2 -> {
                MultiColorCellContent multiColorContent = (MultiColorCellContent)cellContent2;
                yield this.isSameValue(multiColorContent, second);
            }
            default -> true;
        };
    }

    private boolean isSameValue(CompareCellContent firstCellContent, CellContent secondCellContent) {
        TableType tableType = this.sessionService.getLoadedSession(ToolboxFileRole.SESSION).getTableType();
        StringCellContent compareCellStringContent = TablemodelFactory.eINSTANCE.createStringCellContent();
        if (tableType == TableType.INITIAL) {
            compareCellStringContent.getValue().addAll((Collection)firstCellContent.getOldValue());
        } else {
            compareCellStringContent.getValue().addAll((Collection)firstCellContent.getNewValue());
        }
        return this.isSameValue(compareCellStringContent, secondCellContent);
    }

    private boolean isSameValue(MultiColorCellContent firstCellContent, CellContent secondCellContent) {
        return firstCellContent.getValue().stream().allMatch(value -> {
            StringCellContent stringCellContent = TablemodelFactory.eINSTANCE.createStringCellContent();
            if (value.getMultiColorValue() == null || value.getMultiColorValue().isEmpty()) {
                stringCellContent.getValue().add((Object)value.getStringFormat());
            } else {
                stringCellContent.getValue().add((Object)String.format(value.getStringFormat(), value.getMultiColorValue()));
            }
            return this.isSameValue(stringCellContent, secondCellContent);
        });
    }

    private boolean isSameValue(StringCellContent firstCellContent, CellContent secondCellContent) {
        Set firstValues = Streams.stream((Iterable)CellContentExtensions.getStringValueIterable((CellContent)firstCellContent)).filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
        if (firstValues.contains("\u23f3")) {
            return false;
        }
        CellContent cellContent = secondCellContent;
        Objects.requireNonNull(cellContent);
        CellContent cellContent2 = cellContent;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StringCellContent.class, CompareCellContent.class, MultiColorCellContent.class}, (Object)cellContent2, 0)) {
            case 0 -> {
                StringCellContent stringContent = (StringCellContent)cellContent2;
                Set secondValues = Streams.stream((Iterable)CellContentExtensions.getStringValueIterable((CellContent)stringContent)).filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
                yield firstValues.equals(secondValues);
            }
            case 1 -> {
                CompareCellContent compareContent = (CompareCellContent)cellContent2;
                TableType tableType = this.sessionService.getLoadedSession(ToolboxFileRole.SESSION).getTableType();
                Set v2 = switch (tableType) {
                    case TableType.INITIAL -> compareContent.getOldValue().stream().filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
                    default -> compareContent.getNewValue().stream().filter(value -> value != null && !value.trim().isEmpty()).collect(Collectors.toSet());
                };
                Set values = v2;
                yield firstValues.equals(values);
            }
            case 2 -> {
                MultiColorCellContent multiColorContent = (MultiColorCellContent)cellContent2;
                Set values = multiColorContent.getValue().stream().map(content -> {
                    if (content.getMultiColorValue() == null || content.getMultiColorValue().isEmpty()) {
                        return content.getStringFormat();
                    }
                    return String.format(content.getStringFormat(), content.getMultiColorValue());
                }).collect(Collectors.toSet());
                yield firstValues.equals(values);
            }
            default -> false;
        };
    }

    private static Table expandNewRowGroups(Table oldTable, Table newTable) {
        Table result = (Table)EcoreUtil.copy((EObject)oldTable);
        EList newRowGroups = newTable.getTablecontent().getRowgroups();
        newRowGroups.forEach(group -> CustomTableDiffService.addMissingRowGroup(group, result));
        return result;
    }

    private static void matchRow(TableRow row, Table newTable) {
        TableRow match = TableExtensions.getMatchingRow((Table)newTable, (TableRow)row);
        int i = 0;
        while (i < row.getCells().size()) {
            CustomTableDiffService.createDiffContent(i, row, match, (a, b) -> CustomTableDiffService.createCompareCellContent(a, b));
            ++i;
        }
        CompareFootnoteContainer diffFootnotes = TablemodelFactory.eINSTANCE.createCompareFootnoteContainer();
        List<Bearbeitungsvermerk> oldFootnotes = CustomTableDiffService.getFootnotes(row);
        List<Bearbeitungsvermerk> newFootnotes = CustomTableDiffService.getFootnotes(match);
        for (Bearbeitungsvermerk footnote : oldFootnotes) {
            if (newFootnotes.stream().anyMatch(c -> c.getIdentitaet().getWert().equals(footnote.getIdentitaet().getWert()))) {
                diffFootnotes.getUnchangedFootnotes().add((Object)footnote);
                continue;
            }
            diffFootnotes.getOldFootnotes().add((Object)footnote);
        }
        for (Bearbeitungsvermerk footnote : newFootnotes) {
            if (oldFootnotes.stream().anyMatch(c -> c.getIdentitaet().getWert().equals(footnote.getIdentitaet().getWert()))) continue;
            diffFootnotes.getNewFootnotes().add((Object)footnote);
        }
        row.setFootnotes((FootnoteContainer)diffFootnotes);
    }

    private static List<Bearbeitungsvermerk> getFootnotes(TableRow row) {
        if (row == null || row.getFootnotes() == null || ((SimpleFootnoteContainer)row.getFootnotes()).getFootnotes() == null) {
            return List.of();
        }
        return ((SimpleFootnoteContainer)row.getFootnotes()).getFootnotes();
    }

    private static Table matchRows(Table expanded, Table newTable) {
        Table result = (Table)EcoreUtil.copy((EObject)expanded);
        List rows = TableExtensions.getTableRows((Table)result);
        rows.forEach(row -> CustomTableDiffService.matchRow(row, newTable));
        return result;
    }

    public Table createDiffTable(Table oldTable, Table newTable) {
        Table expanded = CustomTableDiffService.expandNewRowGroups(oldTable, newTable);
        return CustomTableDiffService.matchRows(expanded, newTable);
    }

    public Table createCompareTable(Table mainPlanTable, Table comparePlanTable) {
        Table copy = (Table)EcoreUtil.copy((EObject)mainPlanTable);
        Table expandedTable = CustomTableDiffService.expandNewRowGroups(comparePlanTable, copy);
        List rows = TableExtensions.getTableRows((Table)copy);
        rows.forEach(row -> {
            TableRow match = TableExtensions.getMatchingRow((Table)expandedTable, (TableRow)row);
            int i = 0;
            while (i < row.getCells().size()) {
                CustomTableDiffService.createDiffContent(i, row, match, this::createTableCompareCellContent);
                ++i;
            }
        });
        return copy;
    }
}

