/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.fop;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.apps.FopFactoryBuilder;
import org.apache.fop.apps.io.ResourceResolverFactory;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.render.intermediate.AbstractIFDocumentHandlerMaker;
import org.apache.xmlgraphics.io.Resource;
import org.apache.xmlgraphics.io.ResourceResolver;
import org.eclipse.set.basis.OverwriteHandling;
import org.eclipse.set.basis.exceptions.UserAbortion;
import org.eclipse.set.core.services.font.FontService;
import org.eclipse.set.feature.export.fop.FopPDFDocumentHandlerMaker;
import org.eclipse.set.feature.export.fop.RelativeResourceResolver;
import org.eclipse.set.services.fop.FopService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.xml.sax.SAXException;

@Component
public class FopServiceImpl
implements FopService {
    private static final String DATA_DIR = "data";
    private FopFactory fopFactory;
    private TransformerFactory transformerFactory;
    @Reference
    FontService fontService;
    private final ResourceResolver defaultResourceResolver;
    private ResourceResolver resourceResolver;
    private final ResourceResolver proxyResourceResolver;

    public FopServiceImpl() {
        this.resourceResolver = this.defaultResourceResolver = new RelativeResourceResolver(DATA_DIR);
        this.proxyResourceResolver = new ResourceResolver(){

            public Resource getResource(URI uri) throws IOException {
                return FopServiceImpl.this.resourceResolver.getResource(uri);
            }

            public OutputStream getOutputStream(URI uri) throws IOException {
                return FopServiceImpl.this.resourceResolver.getOutputStream(uri);
            }
        };
    }

    @Activate
    public void activate() throws IOException, SAXException, ConfigurationException, URISyntaxException {
        FopFactoryBuilder fopFactoryBuilder = new FopFactoryBuilder(new File(".").toURI(), this.proxyResourceResolver);
        fopFactoryBuilder.setHyphenBaseResourceResolver(ResourceResolverFactory.createDefaultInternalResourceResolver((URI)FopServiceImpl.class.getClassLoader().getResource("hyph").toURI()));
        this.fopFactory = fopFactoryBuilder.build();
        this.fopFactory.getRendererFactory().addDocumentHandlerMaker((AbstractIFDocumentHandlerMaker)new FopPDFDocumentHandlerMaker(this.fontService));
        this.transformerFactory = TransformerFactory.newInstance();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fop(FopService.OutputFormat outputFormat, Source stylesheet, Source xmlData, Path outputPath, FopService.PdfAMode pdfAMode, OverwriteHandling overwriteHandling, ResourceResolver userResourceResolver) throws FOPException, IOException, TransformerException, UserAbortion {
        if (!overwriteHandling.test(outputPath)) {
            throw new UserAbortion();
        }
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            FileOutputStream outputStream = new FileOutputStream(outputPath.toFile());
            try {
                try (BufferedOutputStream bufferedOut = new BufferedOutputStream(outputStream);){
                    Map rendererOptions;
                    FOUserAgent userAgent = this.fopFactory.newFOUserAgent();
                    if (pdfAMode != FopService.PdfAMode.NONE) {
                        rendererOptions = userAgent.getRendererOptions();
                        rendererOptions.put("pdf-a-mode", pdfAMode.getModeString());
                    }
                    if (outputFormat == FopService.OutputFormat.IMAGE) {
                        rendererOptions = userAgent.getRendererOptions();
                        rendererOptions.put("dpi", "600");
                    }
                    Fop fop = this.fopFactory.newFop(outputFormat.getFormatString(), userAgent, (OutputStream)bufferedOut);
                    SAXResult saxResult = new SAXResult(fop.getDefaultHandler());
                    if (userResourceResolver != null) {
                        this.resourceResolver = userResourceResolver;
                    }
                    if (stylesheet == null) {
                        this.transformerFactory.newTransformer().transform(xmlData, saxResult);
                    } else {
                        this.transformerFactory.newTransformer(stylesheet).transform(xmlData, saxResult);
                    }
                    this.resourceResolver = this.defaultResourceResolver;
                }
                if (outputStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public String getBaseDir() {
        return DATA_DIR;
    }
}

