/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.export.checkboxmodel;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.eclipse.set.basis.export.CheckBoxTreeElement;

public class CheckboxTreeModel {
    private final List<CheckBoxTreeElement> elements;

    public CheckboxTreeModel(List<CheckBoxTreeElement> elements) {
        this.elements = elements;
    }

    public void deselectAll() {
        this.elements.forEach(ele -> ele.deselect());
    }

    public void selectAll() {
        this.elements.forEach(ele -> ele.select());
    }

    public CheckBoxTreeElement[] getParentElements() {
        return (CheckBoxTreeElement[])Arrays.stream(this.getAllElements()).filter(ele -> ele.isParent()).toArray(CheckBoxTreeElement[]::new);
    }

    public CheckBoxTreeElement[] getElements() {
        return (CheckBoxTreeElement[])this.elements.toArray(CheckBoxTreeElement[]::new);
    }

    public CheckBoxTreeElement[] getAllElements() {
        List parentElements = this.elements.stream().toList();
        List childElements = this.elements.stream().flatMap(ele -> ele.getChildElements().stream()).toList();
        return (CheckBoxTreeElement[])List.of(parentElements, childElements).stream().flatMap(Collection::stream).toArray(CheckBoxTreeElement[]::new);
    }

    public CheckBoxTreeElement[] getChecked() {
        return (CheckBoxTreeElement[])Arrays.stream(this.getAllElements()).filter(ele -> ele.isChecked()).toArray(CheckBoxTreeElement[]::new);
    }

    public Optional<CheckBoxTreeElement> getElement(String elementId) {
        return Arrays.stream(this.getAllElements()).filter(ele -> ele.getId().equals(elementId)).findFirst();
    }

    public Optional<CheckBoxTreeElement> getElement(String parentId, String element) {
        return Arrays.stream(this.getParentElements()).filter(parent -> parent.getId().equals(parentId)).flatMap(ele -> ele.getChildElements().stream()).filter(ele -> ele.getId().equals(element)).findFirst();
    }

    public void addElement(CheckBoxTreeElement element) {
        Optional<CheckBoxTreeElement> findElement = this.getElement(element.getId());
        if (findElement.isPresent()) {
            throw new IllegalArgumentException(String.format("Element with i: %s already exists ", element.getId()));
        }
        this.addElement(null, element);
    }

    public void addElement(CheckBoxTreeElement parent, CheckBoxTreeElement newElement) {
        if (parent == null) {
            this.elements.add(newElement);
            return;
        }
        if (parent.getChildElements().stream().anyMatch(ele -> ele.getId().equals(newElement.getId()))) {
            throw new IllegalArgumentException(String.format("Element with i: %s already exists in group: %s", newElement.getId(), parent.getId()));
        }
        CheckBoxTreeElement parentElement = this.getElement(parent.getId()).orElse(null);
        if (parentElement == null) {
            this.elements.add(parent);
        }
        parent.addChild(newElement);
    }
}

