/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.compile;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.constants.TableType;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.services.export.TableCompileService;
import org.eclipse.set.services.table.TableService;

public class TableCompileServiceImpl
implements TableCompileService {
    @Inject
    TableService tableService;

    public Map<TableType, Table> compile(String shortcut, IModelSession modelSession, Set<String> controlAreaIds) {
        EnumMap<TableType, Table> result = new EnumMap<TableType, Table>(TableType.class);
        if (PlanProSchnittstelleExtensions.isPlanning((PlanPro_Schnittstelle)modelSession.getPlanProSchnittstelle())) {
            Arrays.stream(TableType.values()).filter(type -> type != TableType.SINGLE).forEach(type -> {
                Table table = this.tableService.createCompareProjectTable(shortcut, type, controlAreaIds);
                result.put((TableType)type, table);
            });
        } else {
            Table single = this.tableService.createCompareProjectTable(shortcut, TableType.SINGLE, controlAreaIds);
            result.put(TableType.SINGLE, single);
        }
        return result;
    }
}

