/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import java.lang.runtime.SwitchBootstraps;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Aussenelementansteuerung;
import org.eclipse.set.model.planpro.Ansteuerung_Element.ESTW_Zentraleinheit;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stell_Bereich;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Stellelement;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Technik_Standort;
import org.eclipse.set.model.planpro.Ansteuerung_Element.Uebertragungsweg;
import org.eclipse.set.model.planpro.Bahnuebergang.BUE_Anlage;
import org.eclipse.set.model.planpro.Bahnuebergang.BUE_Kante;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.model.planpro.Bedienung.Bedien_Bezirk;
import org.eclipse.set.model.planpro.Bedienung.Bedien_Einrichtung_Oertlich;
import org.eclipse.set.model.planpro.Bedienung.Bedien_Standort;
import org.eclipse.set.model.planpro.Bedienung.Bedien_Zentrale;
import org.eclipse.set.model.planpro.Block.Block_Element;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Aneinander;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_DWeg;
import org.eclipse.set.model.planpro.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.model.planpro.Flankenschutz.Fla_Schutz;
import org.eclipse.set.model.planpro.Flankenschutz.Fla_Zwieschutz;
import org.eclipse.set.model.planpro.Geodaten.Oertlichkeit;
import org.eclipse.set.model.planpro.Gleis.Gleis_Abschnitt;
import org.eclipse.set.model.planpro.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.model.planpro.Nahbedienung.NB_Zone;
import org.eclipse.set.model.planpro.Ortung.FMA_Anlage;
import org.eclipse.set.model.planpro.Ortung.FMA_Komponente;
import org.eclipse.set.model.planpro.Ortung.Zugeinwirkung;
import org.eclipse.set.model.planpro.PZB.PZB_Element;
import org.eclipse.set.model.planpro.Signale.Signal;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.set.model.planpro.Weichen_und_Gleissperren.W_Kr_Gsp_Komponente;
import org.eclipse.set.model.planpro.Zugnummernmeldeanlage.ZN_ZBS;
import org.eclipse.set.ppmodel.extensions.AussenelementansteuerungExtensions;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BedienBezirkExtensions;
import org.eclipse.set.ppmodel.extensions.BedienEinrichtungOertlichExtensions;
import org.eclipse.set.ppmodel.extensions.BedienStandortExtensions;
import org.eclipse.set.ppmodel.extensions.BedienZentraleExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BlockElementExtensions;
import org.eclipse.set.ppmodel.extensions.EObjectExtensions;
import org.eclipse.set.ppmodel.extensions.ESTW_ZentraleinheitExtensions;
import org.eclipse.set.ppmodel.extensions.FlaSchutzExtensions;
import org.eclipse.set.ppmodel.extensions.FlaZwieschutzExtensions;
import org.eclipse.set.ppmodel.extensions.FmaAnlageExtensions;
import org.eclipse.set.ppmodel.extensions.FmaKomponenteExtensions;
import org.eclipse.set.ppmodel.extensions.FstrAneinanderExtensions;
import org.eclipse.set.ppmodel.extensions.FstrDWegWKrExtensions;
import org.eclipse.set.ppmodel.extensions.FstrZugRangierExtensions;
import org.eclipse.set.ppmodel.extensions.NbZoneExtensions;
import org.eclipse.set.ppmodel.extensions.PZBElementExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.StellelementExtensions;
import org.eclipse.set.ppmodel.extensions.TechnikStandortExtensions;
import org.eclipse.set.ppmodel.extensions.UebertragungswegExtensions;
import org.eclipse.set.ppmodel.extensions.UrObjectExtensions;
import org.eclipse.set.ppmodel.extensions.WKrGspElementExtensions;
import org.eclipse.set.ppmodel.extensions.ZugEinwirkungExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;

public class StellBereichExtensions {
    private StellBereichExtensions() {
    }

    public static Stell_Bereich getStellBereich(MultiContainer_AttributeGroup container, String guid) {
        return StreamSupport.stream(container.getStellBereich().spliterator(), false).filter(e -> e.getIdentitaet().getWert().equals(guid)).findFirst().orElse(null);
    }

    public static String getStellBeteichBezeichnung(Stell_Bereich area) {
        return EObjectExtensions.getNullableObject(area, e -> {
            Aussenelementansteuerung aussenElementAnsteuerung = StellBereichExtensions.getAussenElementAnsteuerung(e);
            return aussenElementAnsteuerung.getBezeichnung().getBezeichnungAEA().getWert();
        }).orElse(null);
    }

    public static String getOertlichkeitBezeichnung(Stell_Bereich area) {
        if (area == null) {
            return null;
        }
        return EObjectExtensions.getNullableObject(area, e -> {
            Aussenelementansteuerung aussenElementAnsteuerung = StellBereichExtensions.getAussenElementAnsteuerung(e);
            Oertlichkeit oertlichkeit = AussenelementansteuerungExtensions.getOertlichkeitNamensgebend(aussenElementAnsteuerung);
            return oertlichkeit.getBezeichnung().getOertlichkeitAbkuerzung().getWert();
        }).orElse(null);
    }

    public static String getAussenelementansteuerungBezeichnungAEA(Stell_Bereich area) {
        return EObjectExtensions.getNullableObject(area, e -> StellBereichExtensions.getAussenElementAnsteuerung(e).getBezeichnung().getBezeichnungAEA().getWert()).orElse(null);
    }

    public static Aussenelementansteuerung getAussenElementAnsteuerung(Stell_Bereich area) {
        return EObjectExtensions.getNullableObject(area, e -> e.getIDAussenelementansteuerung().getValue()).orElse(null);
    }

    public static List<Technik_Standort> getTechnikStandorts(Stell_Bereich area) {
        Aussenelementansteuerung aussenElementAnsteuerung = StellBereichExtensions.getAussenElementAnsteuerung(area);
        if (aussenElementAnsteuerung == null) {
            return Collections.emptyList();
        }
        List<ESTW_Zentraleinheit> estwZentraleinheits = AussenelementansteuerungExtensions.getESTWZentraleinheits(aussenElementAnsteuerung);
        estwZentraleinheits.addAll(aussenElementAnsteuerung.getIDInformationPrimaer().stream().map(id -> EObjectExtensions.getNullableObject(id, e -> e.getValue()).orElse(null)).filter(Objects::nonNull).filter(Aussenelementansteuerung.class::isInstance).map(Aussenelementansteuerung.class::cast).flatMap(e -> AussenelementansteuerungExtensions.getESTWZentraleinheits(e).stream()).toList());
        return estwZentraleinheits.stream().flatMap(estw -> ESTW_ZentraleinheitExtensions.getTechnikStandort(estw).stream()).filter(Objects::nonNull).toList();
    }

    public static List<W_Kr_Gsp_Element> getWkrGspElement(Stell_Bereich area) {
        Iterable abschnitts = UrObjectExtensions.filterObjectsInControlArea(BasisAttributExtensions.getContainer((EObject)area).getGleisAbschnitt(), area);
        return StreamSupport.stream(BasisAttributExtensions.getContainer((EObject)area).getWKrGspElement().spliterator(), false).filter(gspElement -> StreamSupport.stream(abschnitts.spliterator(), false).anyMatch(abschnitt -> WKrGspElementExtensions.getGleisAbschnitt(gspElement).contains(abschnitt))).toList();
    }

    public static boolean isInControlArea(Stell_Bereich area, Basis_Objekt object) {
        if (object == null) {
            return false;
        }
        Basis_Objekt basis_Objekt = object;
        Objects.requireNonNull(basis_Objekt);
        Basis_Objekt basis_Objekt2 = basis_Objekt;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Aussenelementansteuerung.class, ESTW_Zentraleinheit.class, Bedien_Einrichtung_Oertlich.class, FMA_Anlage.class, FMA_Komponente.class, Zugeinwirkung.class, PZB_Element.class, Signal.class, Technik_Standort.class, Bedien_Standort.class, W_Kr_Gsp_Element.class, W_Kr_Gsp_Komponente.class, Fstr_Aneinander.class, Fstr_DWeg.class, Fstr_Zug_Rangier.class, Fla_Schutz.class, Fla_Zwieschutz.class, Gleis_Abschnitt.class, Gleis_Bezeichnung.class, NB_Zone.class, Uebertragungsweg.class, Bedien_Bezirk.class, Bedien_Zentrale.class, ZN_ZBS.class, Stellelement.class, Block_Element.class, BUE_Kante.class, BUE_Anlage.class}, (Object)basis_Objekt2, 0)) {
            case 0 -> {
                Aussenelementansteuerung aussenElement = (Aussenelementansteuerung)basis_Objekt2;
                yield AussenelementansteuerungExtensions.isBelongToControlArea(aussenElement, area);
            }
            case 1 -> {
                ESTW_Zentraleinheit estwZentral = (ESTW_Zentraleinheit)basis_Objekt2;
                yield ESTW_ZentraleinheitExtensions.isBelongToControlArea(estwZentral, area);
            }
            case 2 -> {
                Bedien_Einrichtung_Oertlich oertlich = (Bedien_Einrichtung_Oertlich)basis_Objekt2;
                yield BedienEinrichtungOertlichExtensions.isBelongToControlArea(oertlich, area);
            }
            case 3 -> {
                FMA_Anlage fmaAnlage = (FMA_Anlage)basis_Objekt2;
                yield FmaAnlageExtensions.isBelongToControlArea(fmaAnlage, area);
            }
            case 4 -> {
                FMA_Komponente fmaKomponente = (FMA_Komponente)basis_Objekt2;
                yield FmaKomponenteExtensions.isBelongToControlArea(fmaKomponente, area);
            }
            case 5 -> {
                Zugeinwirkung zugeinwirkung = (Zugeinwirkung)basis_Objekt2;
                yield ZugEinwirkungExtensions.isBelongToControlArea(zugeinwirkung, area);
            }
            case 6 -> {
                PZB_Element pzb = (PZB_Element)basis_Objekt2;
                yield PZBElementExtensions.isBelongToControlArea(pzb, area);
            }
            case 7 -> {
                Signal signal = (Signal)basis_Objekt2;
                yield SignalExtensions.isBelongToControlArea(signal, area);
            }
            case 8 -> {
                Technik_Standort standort = (Technik_Standort)basis_Objekt2;
                yield TechnikStandortExtensions.isBelongToControlArea(standort, area);
            }
            case 9 -> {
                Bedien_Standort standort = (Bedien_Standort)basis_Objekt2;
                yield BedienStandortExtensions.isBelongToControlArea(standort, area);
            }
            case 10 -> {
                W_Kr_Gsp_Element gspElement = (W_Kr_Gsp_Element)basis_Objekt2;
                yield WKrGspElementExtensions.isBelongToControlArea(gspElement, area);
            }
            case 11 -> {
                W_Kr_Gsp_Komponente gspKomponent = (W_Kr_Gsp_Komponente)basis_Objekt2;
                yield StellBereichExtensions.isInControlArea(area, EObjectExtensions.getNullableObject(gspKomponent, gsp -> gsp.getIDWKrGspElement().getValue()).orElse(null));
            }
            case 12 -> {
                Fstr_Aneinander fstr = (Fstr_Aneinander)basis_Objekt2;
                yield FstrAneinanderExtensions.isBelongToControlArea(fstr, area);
            }
            case 13 -> {
                Fstr_DWeg fstr = (Fstr_DWeg)basis_Objekt2;
                yield FstrDWegWKrExtensions.isBelongToControlArea(fstr, area);
            }
            case 14 -> {
                Fstr_Zug_Rangier fstr = (Fstr_Zug_Rangier)basis_Objekt2;
                yield FstrZugRangierExtensions.isBelongToControlArea(fstr, area);
            }
            case 15 -> {
                Fla_Schutz fla = (Fla_Schutz)basis_Objekt2;
                yield FlaSchutzExtensions.isBelongToControlArea(fla, area);
            }
            case 16 -> {
                Fla_Zwieschutz fla = (Fla_Zwieschutz)basis_Objekt2;
                yield FlaZwieschutzExtensions.isBelongToControlArea(fla, area);
            }
            case 17 -> {
                Gleis_Abschnitt segment = (Gleis_Abschnitt)basis_Objekt2;
                yield BereichObjektExtensions.intersects((Bereich_Objekt)area, (Bereich_Objekt)segment);
            }
            case 18 -> {
                Gleis_Bezeichnung description = (Gleis_Bezeichnung)basis_Objekt2;
                yield StellBereichExtensions.isOverlappingControlArea(area, (Bereich_Objekt)description, 50.0);
            }
            case 19 -> {
                NB_Zone nbZone = (NB_Zone)basis_Objekt2;
                yield NbZoneExtensions.isBelongToControlArea(nbZone, area);
            }
            case 20 -> {
                Uebertragungsweg uebertrangsweg = (Uebertragungsweg)basis_Objekt2;
                yield UebertragungswegExtensions.isBelongToControlArea(uebertrangsweg, area);
            }
            case 21 -> {
                Bedien_Bezirk bedienBezirk = (Bedien_Bezirk)basis_Objekt2;
                yield BedienBezirkExtensions.isBelongToControlArea(bedienBezirk, area);
            }
            case 22 -> {
                Bedien_Zentrale controlCenter = (Bedien_Zentrale)basis_Objekt2;
                yield BedienZentraleExtensions.isBelongToControlArea(controlCenter, area);
            }
            case 23 -> {
                ZN_ZBS znZBS = (ZN_ZBS)basis_Objekt2;
                yield StellBereichExtensions.isInControlArea(area, EObjectExtensions.getNullableObject(znZBS, ele -> ele.getIDESTWZentraleinheit().getValue()).orElse(null));
            }
            case 24 -> {
                Stellelement stellelement = (Stellelement)basis_Objekt2;
                yield StellelementExtensions.isBelongToControlArea(stellelement, area);
            }
            case 25 -> {
                Block_Element blockElement = (Block_Element)basis_Objekt2;
                yield BlockElementExtensions.isBelongToControlArea(blockElement, area);
            }
            case 26 -> {
                BUE_Kante bueKante = (BUE_Kante)basis_Objekt2;
                yield BereichObjektExtensions.intersects((Bereich_Objekt)area, (Punkt_Objekt)bueKante);
            }
            case 27 -> {
                BUE_Anlage bueAnlage = (BUE_Anlage)basis_Objekt2;
                yield BereichObjektExtensions.intersects((Bereich_Objekt)area, (Punkt_Objekt)bueAnlage);
            }
            default -> throw new IllegalArgumentException();
        };
    }

    public static boolean isOverlappingControlArea(Stell_Bereich area, Bereich_Objekt bo, double coverageDegree) {
        if (bo == null || area == null) {
            return false;
        }
        if (coverageDegree <= 0.0) {
            throw new IllegalArgumentException("Coverage Dgreee must be greater than 0");
        }
        BigDecimal overlappingLength = BereichObjektExtensions.getOverlappingLength((Bereich_Objekt)area, bo);
        return BereichObjektExtensions.getLength(bo).multiply(BigDecimal.valueOf(coverageDegree / 100.0)).compareTo(overlappingLength) < 0;
    }
}

