/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.emfforms.utils;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;
import org.eclipse.set.basis.DomainElementList;
import org.eclipse.set.basis.MediaInfo;
import org.eclipse.set.emfforms.utils.DomainElementListImpl;
import org.eclipse.set.utils.VDomainModelReferenceExtensions;
import org.eclipse.set.utils.emfforms.Renderers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainModelTypeRendererService<S, T extends AbstractSWTRenderer<VControl>>
implements EMFFormsDIRendererService<VControl> {
    private static final Logger logger = LoggerFactory.getLogger(DomainModelTypeRendererService.class);
    private final Optional<Predicate<EClassifier>> additionalTypeTest;
    private final EPackage ePackage;
    private final Multiplicity multiplicity;
    private final double priority;
    private final Class<T> rendererType;
    private final Class<S> wantedDomainType;

    public static <S, I extends MediaInfo<S>> DomainElementList<S, I> getDomainElementList(Class<S> domainType, VElement vElement, ViewModelContext viewModelContext) {
        return DomainModelTypeRendererService.getDomainElementList(domainType, vElement, viewModelContext, Optional.empty());
    }

    public static <S, I extends MediaInfo<S>> DomainElementList<S, I> getDomainElementList(Class<S> domainType, VElement vElement, ViewModelContext viewModelContext, Optional<Predicate<EClassifier>> additionalTypeTest) {
        String domainTypeName;
        if (!VControl.class.isInstance(vElement)) {
            return null;
        }
        VControl control = (VControl)vElement;
        VDomainModelReference domainModelReference = control.getDomainModelReference();
        if (!(domainModelReference instanceof VFeaturePathDomainModelReference)) {
            return null;
        }
        VFeaturePathDomainModelReference featurePathDomainModelReference = (VFeaturePathDomainModelReference)domainModelReference;
        EStructuralFeature domainModelEFeature = featurePathDomainModelReference.getDomainModelEFeature();
        if (!(domainModelEFeature instanceof EReference)) {
            return null;
        }
        EReference domainModelEReference = (EReference)domainModelEFeature;
        if (domainModelEReference.getUpperBound() != -1) {
            return null;
        }
        EClassifier type = domainModelEReference.getEType();
        if (!additionalTypeTest.map(t -> t.test(type)).orElse(Boolean.TRUE).booleanValue()) {
            return null;
        }
        String instanceTypeName = type.getInstanceTypeName();
        if (!instanceTypeName.equals(domainTypeName = domainType.getName())) {
            return null;
        }
        EObject domainModel = viewModelContext.getDomainModel();
        EObject featureValueContainingTheDomainElement = VDomainModelReferenceExtensions.resolve((VDomainModelReference)featurePathDomainModelReference, (EObject)domainModel);
        return new DomainElementListImpl(featureValueContainingTheDomainElement, featurePathDomainModelReference.getDomainModelEFeature(), viewModelContext.getDomainModel().eContainingFeature());
    }

    public DomainModelTypeRendererService(EPackage ePackage, Class<S> wantedDomainType, Class<T> rendererType, double priority, Multiplicity multiplicity) {
        this(ePackage, wantedDomainType, rendererType, priority, multiplicity, null);
    }

    public DomainModelTypeRendererService(EPackage ePackage, Class<S> wantedDomainType, Class<T> rendererType, double priority, Multiplicity multiplicity, Predicate<EClassifier> additionalTypeTest) {
        this.ePackage = ePackage;
        this.wantedDomainType = wantedDomainType;
        this.rendererType = rendererType;
        this.multiplicity = multiplicity;
        this.priority = priority;
        this.additionalTypeTest = Optional.ofNullable(additionalTypeTest);
    }

    public Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return this.rendererType;
    }

    public double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        if (this.multiplicity == Multiplicity.ZERO_OR_ONE && this.isElementApplicableForType(vElement)) {
            logger.debug("{} is as element applicable for {}", (Object)this.rendererType.getSimpleName(), (Object)vElement.getName());
            return this.priority;
        }
        if (this.multiplicity == Multiplicity.MANY && DomainModelTypeRendererService.getDomainElementList(this.wantedDomainType, vElement, viewModelContext, this.additionalTypeTest) != null) {
            logger.debug("{} is as list applicable for {}", (Object)this.rendererType.getSimpleName(), (Object)vElement.getName());
            return this.priority;
        }
        return Double.NaN;
    }

    private boolean isElementApplicableForType(VElement vElement) {
        if (vElement instanceof VControl) {
            Optional type;
            block4: {
                try {
                    type = Renderers.getFeaturePathDomainType((VElement)vElement, (boolean)true);
                    if (type.isPresent()) break block4;
                    return false;
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            return this.modelTest((EClassifier)type.get()) && this.wantedDomainType.isAssignableFrom(((EClassifier)type.get()).getInstanceClass()) && this.additionalTypeTest.map(t -> t.test((EClassifier)type.get())).orElse(Boolean.TRUE) != false;
        }
        return false;
    }

    private boolean modelTest(EClassifier eClassifier) {
        boolean result;
        boolean bl = result = this.ePackage == eClassifier.getEPackage();
        if (!result) {
            logger.debug("Renderer disqualified because {} does not belong to {} package.", (Object)eClassifier.getName(), (Object)this.ePackage.getName());
        }
        return result;
    }

    public static enum Multiplicity {
        MANY,
        ZERO_OR_ONE;

    }
}

