/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.transforms;

import org.eclipse.equinox.internal.transforms.ReplaceTransformer;
import org.eclipse.equinox.internal.transforms.StreamTransformer;
import org.eclipse.equinox.internal.transforms.TransformInstanceListData;
import org.eclipse.equinox.internal.transforms.TransformTuple;
import org.eclipse.equinox.internal.transforms.TransformedBundleFile;
import org.eclipse.equinox.internal.transforms.TransformerBundleExtender;
import org.eclipse.equinox.internal.transforms.TransformerList;
import org.eclipse.osgi.internal.hookregistry.ActivatorHookFactory;
import org.eclipse.osgi.internal.hookregistry.BundleFileWrapperFactoryHook;
import org.eclipse.osgi.internal.hookregistry.HookConfigurator;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.log.EquinoxLogServices;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;

public class TransformerHook
implements BundleFileWrapperFactoryHook,
HookConfigurator,
ActivatorHookFactory,
BundleActivator {
    private volatile TransformerList transformers;
    private volatile TransformInstanceListData templates;
    private EquinoxLogServices logServices;

    public BundleFileWrapper wrapBundleFile(BundleFile bundleFile, BundleInfo.Generation generation, boolean base) {
        if (this.transformers == null || this.templates == null) {
            return null;
        }
        return new TransformedBundleFile(this, generation, bundleFile);
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addActivatorHookFactory((ActivatorHookFactory)this);
        hookRegistry.addBundleFileWrapperFactoryHook((BundleFileWrapperFactoryHook)this);
        this.logServices = hookRegistry.getContainer().getLogServices();
    }

    public void start(BundleContext context) throws BundleException {
        try {
            ReplaceTransformer.register(context, this);
            TransformerBundleExtender.start(context);
            this.transformers = new TransformerList(context, this.logServices);
        }
        catch (InvalidSyntaxException e) {
            throw new BundleException("Problem registering service tracker: transformers", (Throwable)e);
        }
        try {
            this.templates = new TransformInstanceListData(context, this.logServices);
        }
        catch (InvalidSyntaxException e) {
            this.transformers.close();
            this.transformers = null;
            throw new BundleException("Problem registering service tracker: templates", (Throwable)e);
        }
    }

    public void stop(BundleContext context) {
        this.transformers.close();
        this.templates.close();
    }

    void log(int severity, String msg, Throwable t) {
        if (this.logServices == null) {
            System.err.println(msg);
            t.printStackTrace();
            return;
        }
        this.logServices.log("org.eclipse.osgi", severity, msg, t);
    }

    public BundleActivator createActivator() {
        return this;
    }

    public String[] getTransformTypes() {
        TransformInstanceListData current = this.templates;
        return current == null ? new String[]{} : current.getTransformTypes();
    }

    public StreamTransformer getTransformer(String type) {
        TransformerList current = this.transformers;
        return current == null ? null : current.getTransformer(type);
    }

    public TransformTuple[] getTransformsFor(String type) {
        TransformInstanceListData current = this.templates;
        return current == null ? null : current.getTransformsFor(type);
    }

    public boolean hasTransformers() {
        TransformerList current = this.transformers;
        return current == null ? false : current.hasTransformers();
    }

    public boolean hasTransformsFor(Bundle bundle) {
        TransformInstanceListData current = this.templates;
        return current == null ? false : current.hasTransformsFor(bundle);
    }
}

