/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.projectdata.utils;

import java.util.List;
import org.eclipse.nebula.jface.tablecomboviewer.TableComboViewer;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.files.ToolboxFileFilter;
import org.eclipse.set.core.services.dialog.DialogService;
import org.eclipse.set.feature.projectdata.Messages;
import org.eclipse.set.feature.projectdata.ppimport.ContainerComboSelection;
import org.eclipse.set.feature.projectdata.ppimport.SubworkComboSelection;
import org.eclipse.set.utils.widgets.ComboValues;
import org.eclipse.set.utils.widgets.FileField;
import org.eclipse.set.utils.widgets.MultiSelectionCombo;
import org.eclipse.set.utils.widgets.SelectionCombo;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ImportComboFileField
extends FileField {
    private final MultiSelectionCombo<SubworkComboSelection> subworkCombo;
    private final SelectionCombo<ContainerComboSelection> containerCombo;
    private final Messages messages;

    public ImportComboFileField(Composite parent, List<ToolboxFileFilter> filters, DialogService dialogService, Messages messages) {
        super(parent, filters, dialogService);
        this.composite.setLayout((Layout)new GridLayout(4, false));
        this.subworkCombo = new MultiSelectionCombo(this.composite, messages.PlanProImportPart_Subwork_All);
        this.containerCombo = new SelectionCombo(this.composite, 0);
        this.messages = messages;
    }

    public void setEnabled(boolean value) {
        super.setEnabled(value);
        this.updateSubworkComboState();
        this.updateContainerComboState();
    }

    public MultiSelectionCombo<SubworkComboSelection> getSubworkCombo() {
        return this.subworkCombo;
    }

    public void setSubworkComboValues(ComboValues<SubworkComboSelection> values) {
        this.subworkCombo.setComboValues(values);
        this.updateSubworkComboState();
    }

    private void updateSubworkComboState() {
        if (this.subworkCombo.isDisposed()) {
            return;
        }
        this.subworkCombo.setEnabled(this.isEnabled() && this.subworkCombo.getComboValues() != null && this.subworkCombo.getComboValues().getComboValues().length > 1);
    }

    public SelectionCombo<ContainerComboSelection> getContainerCombo() {
        return this.containerCombo;
    }

    public void setContainerComboValues(ComboValues<ContainerComboSelection> values) {
        if (this.containerCombo.isDisposed()) {
            return;
        }
        this.containerCombo.setComboValues(values);
        this.updateContainerComboState();
    }

    private void updateContainerComboState() {
        if (this.containerCombo.isDisposed()) {
            return;
        }
        this.containerCombo.setEnabled(this.isEnabled() && this.containerCombo.isEnabled() && this.containerCombo.getComboValues() != null && this.containerCombo.getComboValues().getComboValues().length > 1 && !this.isNotSelected((TableComboViewer)this.subworkCombo));
    }

    public void setDefaultCombo() {
        Object comboValues;
        if (!this.subworkCombo.isDisposed()) {
            comboValues = SubworkComboSelection.getComboValues(null, PlanProFileNature.INVALID, this.messages);
            this.subworkCombo.setComboValues(comboValues);
            this.subworkCombo.add((Object)comboValues.getMaxLengthItem());
            this.subworkCombo.setEnabled(false);
            this.subworkCombo.select(0);
        }
        if (!this.containerCombo.isDisposed()) {
            comboValues = ContainerComboSelection.getComboValues(PlanProFileNature.INVALID, this.messages);
            this.containerCombo.setComboValues(comboValues);
            this.containerCombo.add(comboValues.getMaxLengthItem());
            this.containerCombo.setEnabled(false);
            this.containerCombo.select(0);
        }
    }

    public boolean isValid() {
        return this.isEnabled() && !this.getText().getText().isEmpty() && !this.subworkCombo.isDisposed() && !this.isNotSelected((TableComboViewer)this.subworkCombo) && (this.containerCombo.isDisposed() || !this.isNotSelected((Combo)this.containerCombo));
    }

    public boolean isNotSelected(TableComboViewer combo) {
        if (this.subworkCombo.getItems().length == 1 && ((SubworkComboSelection)((Object)this.subworkCombo.getComboValues().getValue(0))).getName().equals(SubworkComboSelection.NOT_SET_SUBWORK)) {
            return false;
        }
        return this.subworkCombo.getSelectionValues().isEmpty();
    }

    public boolean isNotSelected(Combo combo) {
        return ((ContainerComboSelection)((Object)this.containerCombo.getSelectionValue())).equals((Object)ContainerComboSelection.NOT_SELECTED);
    }
}

