/**
 * Copyright (c) 2023 DB Netz AG and others.
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 * 
 */
package org.eclipse.set.model.model11001.ATO.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.model.model11001.ATO.util.ATOAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ATOItemProviderAdapterFactory extends ATOAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ATOItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.Abstand_ATO_Halt_Vor_EoA_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.Abstand_ATO_Halt_Vor_EoA_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAbstand_ATO_Halt_Vor_EoA_TypeClassAdapter() {
		if (abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider == null) {
			abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider = new Abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider(this);
		}

		return abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_Segment_Profile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_Segment_ProfileItemProvider atO_Segment_ProfileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_Segment_Profile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_Segment_ProfileAdapter() {
		if (atO_Segment_ProfileItemProvider == null) {
			atO_Segment_ProfileItemProvider = new ATO_Segment_ProfileItemProvider(this);
		}

		return atO_Segment_ProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_Segment_Profile_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_Segment_Profile_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_Segment_Profile_Bezeichnung_AttributeGroupAdapter() {
		if (atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider == null) {
			atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider = new ATO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_Timing_PointItemProvider atO_Timing_PointItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_Timing_PointAdapter() {
		if (atO_Timing_PointItemProvider == null) {
			atO_Timing_PointItemProvider = new ATO_Timing_PointItemProvider(this);
		}

		return atO_Timing_PointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_Timing_Point_Allg_AttributeGroupItemProvider atO_Timing_Point_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_Timing_Point_Allg_AttributeGroupAdapter() {
		if (atO_Timing_Point_Allg_AttributeGroupItemProvider == null) {
			atO_Timing_Point_Allg_AttributeGroupItemProvider = new ATO_Timing_Point_Allg_AttributeGroupItemProvider(this);
		}

		return atO_Timing_Point_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point_Bezeichnung_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_Timing_Point_Bezeichnung_AttributeGroupItemProvider atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_Timing_Point_Bezeichnung_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_Timing_Point_Bezeichnung_AttributeGroupAdapter() {
		if (atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider == null) {
			atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider = new ATO_Timing_Point_Bezeichnung_AttributeGroupItemProvider(this);
		}

		return atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_TS_Instanz} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_TS_InstanzItemProvider atO_TS_InstanzItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_TS_Instanz}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_TS_InstanzAdapter() {
		if (atO_TS_InstanzItemProvider == null) {
			atO_TS_InstanzItemProvider = new ATO_TS_InstanzItemProvider(this);
		}

		return atO_TS_InstanzItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.ATO_TS_Instanz_Adresse_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ATO_TS_Instanz_Adresse_AttributeGroupItemProvider atO_TS_Instanz_Adresse_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.ATO_TS_Instanz_Adresse_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createATO_TS_Instanz_Adresse_AttributeGroupAdapter() {
		if (atO_TS_Instanz_Adresse_AttributeGroupItemProvider == null) {
			atO_TS_Instanz_Adresse_AttributeGroupItemProvider = new ATO_TS_Instanz_Adresse_AttributeGroupItemProvider(this);
		}

		return atO_TS_Instanz_Adresse_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.Bezeichnung_ATO_TP_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bezeichnung_ATO_TP_TypeClassItemProvider bezeichnung_ATO_TP_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.Bezeichnung_ATO_TP_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBezeichnung_ATO_TP_TypeClassAdapter() {
		if (bezeichnung_ATO_TP_TypeClassItemProvider == null) {
			bezeichnung_ATO_TP_TypeClassItemProvider = new Bezeichnung_ATO_TP_TypeClassItemProvider(this);
		}

		return bezeichnung_ATO_TP_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.Erreichungstoleranz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Erreichungstoleranz_TypeClassItemProvider erreichungstoleranz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.Erreichungstoleranz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErreichungstoleranz_TypeClassAdapter() {
		if (erreichungstoleranz_TypeClassItemProvider == null) {
			erreichungstoleranz_TypeClassItemProvider = new Erreichungstoleranz_TypeClassItemProvider(this);
		}

		return erreichungstoleranz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.Haltetoleranz_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Haltetoleranz_TypeClassItemProvider haltetoleranz_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.Haltetoleranz_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHaltetoleranz_TypeClassAdapter() {
		if (haltetoleranz_TypeClassItemProvider == null) {
			haltetoleranz_TypeClassItemProvider = new Haltetoleranz_TypeClassItemProvider(this);
		}

		return haltetoleranz_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.NID_ATOTS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_ATOTS_TypeClassItemProvider niD_ATOTS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.NID_ATOTS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_ATOTS_TypeClassAdapter() {
		if (niD_ATOTS_TypeClassItemProvider == null) {
			niD_ATOTS_TypeClassItemProvider = new NID_ATOTS_TypeClassItemProvider(this);
		}

		return niD_ATOTS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.NID_C_ATOTS_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_C_ATOTS_TypeClassItemProvider niD_C_ATOTS_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.NID_C_ATOTS_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_C_ATOTS_TypeClassAdapter() {
		if (niD_C_ATOTS_TypeClassItemProvider == null) {
			niD_C_ATOTS_TypeClassItemProvider = new NID_C_ATOTS_TypeClassItemProvider(this);
		}

		return niD_C_ATOTS_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.NID_SP_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_SP_TypeClassItemProvider niD_SP_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.NID_SP_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_SP_TypeClassAdapter() {
		if (niD_SP_TypeClassItemProvider == null) {
			niD_SP_TypeClassItemProvider = new NID_SP_TypeClassItemProvider(this);
		}

		return niD_SP_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.model.model11001.ATO.NID_TP_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NID_TP_TypeClassItemProvider niD_TP_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.model.model11001.ATO.NID_TP_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNID_TP_TypeClassAdapter() {
		if (niD_TP_TypeClassItemProvider == null) {
			niD_TP_TypeClassItemProvider = new NID_TP_TypeClassItemProvider(this);
		}

		return niD_TP_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider != null) abstand_ATO_Halt_Vor_EoA_TypeClassItemProvider.dispose();
		if (atO_Segment_ProfileItemProvider != null) atO_Segment_ProfileItemProvider.dispose();
		if (atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider != null) atO_Segment_Profile_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (atO_Timing_PointItemProvider != null) atO_Timing_PointItemProvider.dispose();
		if (atO_Timing_Point_Allg_AttributeGroupItemProvider != null) atO_Timing_Point_Allg_AttributeGroupItemProvider.dispose();
		if (atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider != null) atO_Timing_Point_Bezeichnung_AttributeGroupItemProvider.dispose();
		if (atO_TS_InstanzItemProvider != null) atO_TS_InstanzItemProvider.dispose();
		if (atO_TS_Instanz_Adresse_AttributeGroupItemProvider != null) atO_TS_Instanz_Adresse_AttributeGroupItemProvider.dispose();
		if (bezeichnung_ATO_TP_TypeClassItemProvider != null) bezeichnung_ATO_TP_TypeClassItemProvider.dispose();
		if (erreichungstoleranz_TypeClassItemProvider != null) erreichungstoleranz_TypeClassItemProvider.dispose();
		if (haltetoleranz_TypeClassItemProvider != null) haltetoleranz_TypeClassItemProvider.dispose();
		if (niD_ATOTS_TypeClassItemProvider != null) niD_ATOTS_TypeClassItemProvider.dispose();
		if (niD_C_ATOTS_TypeClassItemProvider != null) niD_C_ATOTS_TypeClassItemProvider.dispose();
		if (niD_SP_TypeClassItemProvider != null) niD_SP_TypeClassItemProvider.dispose();
		if (niD_TP_TypeClassItemProvider != null) niD_TP_TypeClassItemProvider.dispose();
	}

}
