/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.delegate;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rap.tools.launch.rwt.internal.config.RWTLaunchConfig;
import org.eclipse.rap.tools.launch.rwt.internal.delegate.RWTLaunch;
import org.eclipse.rap.tools.launch.rwt.internal.util.IOUtil;
import org.eclipse.rap.tools.launch.rwt.internal.util.TemplateParser;

class WebXmlProvider {
    private static final String ENTRY_POINTS_PARAM_NAME = "org.eclipse.rwt.entryPoints";
    private static final String APP_CONFIG_PARAM_NAME = "org.eclipse.rap.applicationConfiguration";
    private final RWTLaunchConfig config;
    private final File destination;

    WebXmlProvider(RWTLaunch launch) {
        this.config = launch.getLaunchConfig();
        this.destination = launch.getWebXmlPath();
    }

    File provide(IProgressMonitor monitor) {
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 1);
        subMonitor.beginTask("Provisioning web.xml...", 1);
        try {
            this.internalProvide();
            subMonitor.worked(1);
        }
        finally {
            subMonitor.done();
        }
        return this.destination;
    }

    private void internalProvide() {
        if (RWTLaunchConfig.LaunchTarget.WEB_XML.equals((Object)this.config.getLaunchTarget())) {
            this.provideCustomWebXml();
        } else {
            this.provideGeneratedWebXml();
        }
    }

    private void provideCustomWebXml() {
        String source = this.config.getWebXmlLocation();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFile absoluteSourcce = root.getFile(Path.fromPortableString((String)source));
        IOUtil.copy(new File(absoluteSourcce.getLocationURI()), this.destination);
    }

    private void provideGeneratedWebXml() {
        String webXmlContent = this.generateWebXmlContent();
        byte[] bytes = WebXmlProvider.getBytes(webXmlContent);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        IOUtil.copy(inputStream, this.destination);
    }

    private String generateWebXmlContent() {
        TemplateParser templateParser = new TemplateParser(this.getWebXmlTemplate());
        templateParser.registerVariable("webAppName", this.config.getName());
        String paramName = this.isEntryPointLauncher() ? ENTRY_POINTS_PARAM_NAME : APP_CONFIG_PARAM_NAME;
        String className = this.isEntryPointLauncher() ? this.config.getEntryPoint() : this.config.getAppConfig();
        templateParser.registerVariable("paramName", paramName);
        templateParser.registerVariable("className", className);
        templateParser.registerVariable("servletPath", this.getServletPath());
        templateParser.registerVariable("sessionTimeout", this.getSessionTimeout());
        return templateParser.parse();
    }

    private boolean isEntryPointLauncher() {
        return RWTLaunchConfig.LaunchTarget.ENTRY_POINT.equals((Object)this.config.getLaunchTarget());
    }

    private String getWebXmlTemplate() {
        InputStream inputStream = this.getClass().getResourceAsStream("template-web.xml");
        try {
            String string = IOUtil.readContent(inputStream);
            return string;
        }
        finally {
            IOUtil.closeInputStream(inputStream);
        }
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private String getServletPath() {
        String servletPath = this.config.getServletPath().trim();
        return servletPath.equals("/") ? "" : servletPath;
    }

    private String getSessionTimeout() {
        return this.config.getUseSessionTimeout() ? String.valueOf(this.config.getSessionTimeout()) : "0";
    }
}

