/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.BufferedContentSink;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;

public class ContentSinkOutputStream
extends OutputStream {
    private final Blocker.Shared _blocking = new Blocker.Shared();
    private final Content.Sink sink;

    public ContentSinkOutputStream(Content.Sink sink) {
        this.sink = sink;
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        try (Blocker.Callback callback = this._blocking.callback();){
            this.sink.write(false, ByteBuffer.wrap(b, off, len), (Callback)callback);
            callback.block();
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    @Override
    public void flush() throws IOException {
        try (Blocker.Callback callback = this._blocking.callback();){
            this.sink.write(false, BufferedContentSink.FLUSH_BUFFER, (Callback)callback);
            callback.block();
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    @Override
    public void close() throws IOException {
        try (Blocker.Callback callback = this._blocking.callback();){
            this.close((Callback)callback);
            callback.block();
        }
        catch (Throwable x) {
            throw IO.rethrow((Throwable)x);
        }
    }

    public void close(Callback callback) throws IOException {
        this.sink.write(true, null, callback);
    }
}

