/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.contexts;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.commands.contexts.ContextManagerEvent;
import org.eclipse.core.commands.contexts.IContextManagerListener;
import org.eclipse.ui.AbstractSourceProvider;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.services.IServiceLocator;

public final class ActiveContextSourceProvider
extends AbstractSourceProvider
implements IContextManagerListener {
    private static final String[] PROVIDED_SOURCE_NAMES = new String[]{"activeContexts"};
    private IContextService contextService;

    public final void contextManagerChanged(ContextManagerEvent event) {
        if (event.isActiveContextsChanged()) {
            Map currentState = this.getCurrentState();
            if (DEBUG) {
                this.logDebuggingInfo("Contexts changed to " + String.valueOf(currentState.get("activeContexts")));
            }
            this.fireSourceChanged(64, currentState);
        }
    }

    @Override
    public final void dispose() {
        this.contextService.removeContextManagerListener(this);
    }

    @Override
    public final Map getCurrentState() {
        TreeMap<String, Collection> currentState = new TreeMap<String, Collection>();
        Collection activeContextIds = this.contextService.getActiveContextIds();
        currentState.put("activeContexts", activeContextIds);
        return currentState;
    }

    @Override
    public final String[] getProvidedSourceNames() {
        return PROVIDED_SOURCE_NAMES;
    }

    @Override
    public void initialize(IServiceLocator locator) {
        this.contextService = locator.getService(IContextService.class);
        this.contextService.addContextManagerListener(this);
    }
}

