/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.model.beans;

import org.eclipse.rap.e4.apache.jxpath.JXPathContext;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.CollectionPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.NullPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.NullPropertyPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.PropertyPointer;

public class NullElementPointer
extends CollectionPointer {
    private static final long serialVersionUID = 8714236818791036721L;

    public NullElementPointer(NodePointer parent, int index) {
        super(parent, (Object)null);
        this.index = index;
    }

    @Override
    public QName getName() {
        return null;
    }

    @Override
    public Object getBaseValue() {
        return null;
    }

    @Override
    public Object getImmediateNode() {
        return null;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    public PropertyPointer getPropertyPointer() {
        return new NullPropertyPointer(this);
    }

    @Override
    public NodePointer getValuePointer() {
        return new NullPointer((NodePointer)this, this.getName());
    }

    @Override
    public void setValue(Object value) {
        throw new UnsupportedOperationException("Collection element does not exist: " + this);
    }

    @Override
    public boolean isActual() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        return this.parent.createChild(context, null, this.index);
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        return this.parent.createChild(context, null, this.index, value);
    }

    @Override
    public int hashCode() {
        return this.getImmediateParentPointer().hashCode() + this.index;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof NullElementPointer)) {
            return false;
        }
        NullElementPointer other = (NullElementPointer)object;
        return this.getImmediateParentPointer() == other.getImmediateParentPointer() && this.index == other.index;
    }

    @Override
    public int getLength() {
        return 0;
    }

    @Override
    public String asPath() {
        StringBuffer buffer = new StringBuffer();
        NodePointer parent = this.getImmediateParentPointer();
        if (parent != null) {
            buffer.append(parent.asPath());
        }
        if (this.index != Integer.MIN_VALUE) {
            if (parent != null && parent.getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            } else if (parent != null && parent.getImmediateParentPointer() != null && parent.getImmediateParentPointer().getIndex() != Integer.MIN_VALUE) {
                buffer.append("/.");
            }
            buffer.append("[").append(this.index + 1).append(']');
        }
        return buffer.toString();
    }
}

