/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.e4.apache.jxpath.ri.model.beans;

import java.util.Locale;
import org.eclipse.rap.e4.apache.jxpath.JXPathBeanInfo;
import org.eclipse.rap.e4.apache.jxpath.JXPathIntrospector;
import org.eclipse.rap.e4.apache.jxpath.ri.QName;
import org.eclipse.rap.e4.apache.jxpath.ri.model.NodePointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.BeanPropertyPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.PropertyOwnerPointer;
import org.eclipse.rap.e4.apache.jxpath.ri.model.beans.PropertyPointer;

public class BeanPointer
extends PropertyOwnerPointer {
    private QName name;
    private Object bean;
    private JXPathBeanInfo beanInfo;
    private static final long serialVersionUID = -8227317938284982440L;

    public BeanPointer(QName name, Object bean, JXPathBeanInfo beanInfo, Locale locale) {
        super(null, locale);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    public BeanPointer(NodePointer parent, QName name, Object bean, JXPathBeanInfo beanInfo) {
        super(parent);
        this.name = name;
        this.bean = bean;
        this.beanInfo = beanInfo;
    }

    @Override
    public PropertyPointer getPropertyPointer() {
        return new BeanPropertyPointer((NodePointer)this, this.beanInfo);
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public Object getBaseValue() {
        return this.bean;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getLength() {
        return 1;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    public int hashCode() {
        return this.name == null ? 0 : this.name.hashCode();
    }

    public boolean equals(Object object) {
        int iOther;
        if (object == this) {
            return true;
        }
        if (!(object instanceof BeanPointer)) {
            return false;
        }
        BeanPointer other = (BeanPointer)object;
        if (!(this.parent == other.parent || this.parent != null && this.parent.equals(other.parent))) {
            return false;
        }
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        int iThis = this.index == Integer.MIN_VALUE ? 0 : this.index;
        int n = iOther = other.index == Integer.MIN_VALUE ? 0 : other.index;
        if (iThis != iOther) {
            return false;
        }
        if (this.bean instanceof Number || this.bean instanceof String || this.bean instanceof Boolean) {
            return this.bean.equals(other.bean);
        }
        return this.bean == other.bean;
    }

    @Override
    public String asPath() {
        if (this.parent != null) {
            return super.asPath();
        }
        if (this.bean == null) {
            return "null()";
        }
        if (this.bean instanceof Number) {
            String string = this.bean.toString();
            if (string.endsWith(".0")) {
                string = string.substring(0, string.length() - 2);
            }
            return string;
        }
        if (this.bean instanceof Boolean) {
            return (Boolean)this.bean != false ? "true()" : "false()";
        }
        if (this.bean instanceof String) {
            return "'" + this.bean + "'";
        }
        return "/";
    }
}

