/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.inject.methods;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Map;
import org.apache.felix.scr.impl.inject.BaseParameter;
import org.apache.felix.scr.impl.inject.MethodResult;
import org.apache.felix.scr.impl.inject.internal.ClassUtils;
import org.apache.felix.scr.impl.inject.methods.SuitableMethodNotAccessibleException;
import org.apache.felix.scr.impl.logger.ComponentLogger;
import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.metadata.DSVersion;

public abstract class BaseMethod<P extends BaseParameter, T> {
    private final DSVersion dsVersion;
    private final boolean configurableServiceProperties;
    private final String m_methodName;
    private final Class<?> m_componentClass;
    private volatile Method m_method;
    private final boolean m_methodRequired;
    private volatile State m_state;

    protected BaseMethod(String methodName, boolean methodRequired, Class<?> componentClass, DSVersion dsVersion, boolean configurableServiceProperties) {
        this.m_methodName = methodName;
        this.m_methodRequired = methodRequired;
        this.m_componentClass = componentClass;
        this.dsVersion = dsVersion;
        this.configurableServiceProperties = configurableServiceProperties;
        this.m_state = this.m_methodName == null ? NotApplicable.INSTANCE : NotResolved.INSTANCE;
    }

    protected final DSVersion getDSVersion() {
        return this.dsVersion;
    }

    protected final boolean isDS12Felix() {
        return this.configurableServiceProperties;
    }

    protected final String getMethodName() {
        return this.m_methodName;
    }

    final Method getMethod() {
        return this.m_method;
    }

    protected final Class<?> getComponentClass() {
        return this.m_componentClass;
    }

    protected abstract void setTypes(T var1);

    synchronized void setMethod(MethodInfo<T> methodInfo, ComponentLogger logger) {
        Method method = this.m_method = methodInfo == null ? null : methodInfo.getMethod();
        if (this.m_method != null) {
            this.setTypes(methodInfo.getTypes());
            this.m_state = Resolved.INSTANCE;
            logger.log(InternalLogger.Level.DEBUG, "Found {0} method: {1}", null, this.getMethodNamePrefix(), this.m_method);
        } else if (this.m_methodRequired) {
            this.m_state = NotFound.INSTANCE;
            logger.log(InternalLogger.Level.ERROR, "{0} method [{1}] not found; Component will fail", null, this.getMethodNamePrefix(), this.getMethodName());
        } else {
            logger.log(InternalLogger.Level.DEBUG, "{0} method [{1}] not found, ignoring", null, this.getMethodNamePrefix(), this.getMethodName());
            this.m_state = NotApplicable.INSTANCE;
        }
    }

    State getState() {
        return this.m_state;
    }

    private MethodInfo<T> findMethod(ComponentLogger logger) throws InvocationTargetException {
        boolean acceptPrivate = this.getDSVersion().isDS11();
        boolean acceptPackage = this.getDSVersion().isDS11();
        Class<?> targetClass = this.getComponentClass();
        ClassLoader targetClasslLoader = targetClass.getClassLoader();
        String targetPackage = BaseMethod.getPackageName(targetClass);
        Class<?> theClass = targetClass;
        if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
            logger.log(InternalLogger.Level.DEBUG, "Locating method " + this.getMethodName() + " within class " + theClass.getName(), null);
        }
        while (true) {
            if (logger.isLogEnabled(InternalLogger.Level.TRACE)) {
                logger.log(InternalLogger.Level.TRACE, "Locating method " + this.getMethodName() + " in class " + theClass.getName(), null);
            }
            try {
                MethodInfo<T> method = this.doFindMethod(theClass, acceptPrivate, acceptPackage, logger);
                if (method != null) {
                    return method;
                }
            }
            catch (SuitableMethodNotAccessibleException ex) {
                logger.log(InternalLogger.Level.ERROR, "findMethod: Suitable but non-accessible method {0} found in class {1}, subclass of {2}", null, this.getMethodName(), theClass.getName(), targetClass.getName());
                break;
            }
            theClass = theClass.getSuperclass();
            if (theClass == null) break;
            acceptPackage &= targetClasslLoader == theClass.getClassLoader() && targetPackage.equals(BaseMethod.getPackageName(theClass));
            acceptPrivate = false;
        }
        return null;
    }

    protected abstract MethodInfo<T> doFindMethod(Class<?> var1, boolean var2, boolean var3, ComponentLogger var4) throws SuitableMethodNotAccessibleException, InvocationTargetException;

    private String[] getParametersForLogging(Object[] params) {
        if (params == null) {
            return null;
        }
        String[] result = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            result[i] = params[i] == null ? null : params[i].getClass().getName();
        }
        return result;
    }

    private MethodResult invokeMethod(Object componentInstance, P rawParameter) throws InvocationTargetException {
        ComponentLogger logger = ((BaseParameter)rawParameter).getComponentContext().getLogger();
        try {
            if (componentInstance != null) {
                Object[] params = this.getParameters(this.m_method, rawParameter);
                if (logger.isLogEnabled(InternalLogger.Level.DEBUG)) {
                    logger.log(InternalLogger.Level.DEBUG, "invoking {0}: {1}: parameters {2}", null, this.getMethodNamePrefix(), this.getMethodName(), Arrays.asList(this.getParametersForLogging(params)));
                }
                Map result = (Map)this.m_method.invoke(componentInstance, params);
                logger.log(InternalLogger.Level.DEBUG, "invoked {0}: {1}", null, this.getMethodNamePrefix(), this.getMethodName());
                return new MethodResult(this.m_method.getReturnType() != Void.TYPE, result);
            }
            ((BaseParameter)rawParameter).getComponentContext().getLogger().log(InternalLogger.Level.WARN, "Method {0}: {1} cannot be called on null object", null, this.getMethodNamePrefix(), this.getMethodName());
        }
        catch (IllegalStateException ise) {
            ((BaseParameter)rawParameter).getComponentContext().getLogger().log(InternalLogger.Level.DEBUG, ise.getMessage(), null);
            return null;
        }
        catch (IllegalAccessException ex) {
            ((BaseParameter)rawParameter).getComponentContext().getLogger().log(InternalLogger.Level.DEBUG, "Method {0} cannot be called", ex, this.getMethodName());
        }
        catch (InvocationTargetException ex) {
            throw ex;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
        return MethodResult.VOID;
    }

    protected boolean returnValue() {
        return this.isDS12Felix();
    }

    protected abstract Object[] getParameters(Method var1, P var2);

    protected String getMethodNamePrefix() {
        return "";
    }

    public Method getMethod(Class<?> clazz, String name, Class<?>[] parameterTypes, boolean acceptPrivate, boolean acceptPackage, ComponentLogger logger) throws SuitableMethodNotAccessibleException, InvocationTargetException {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            if (BaseMethod.accept(method, acceptPrivate, acceptPackage, this.returnValue())) {
                return method;
            }
            throw new SuitableMethodNotAccessibleException();
        }
        catch (NoSuchMethodException nsme) {
            if (logger.isLogEnabled(InternalLogger.Level.TRACE)) {
                String argList = parameterTypes != null ? Arrays.asList(parameterTypes).toString() : "";
                logger.log(InternalLogger.Level.TRACE, "Declared Method {0}.{1}({2}) not found", null, clazz.getName(), name, argList);
            }
        }
        catch (NoClassDefFoundError cdfe) {
            if (logger.isLogEnabled(InternalLogger.Level.WARN)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Failure loooking up method ").append(name).append('(');
                for (int i = 0; parameterTypes != null && i < parameterTypes.length; ++i) {
                    buf.append(parameterTypes[i].getName());
                    if (i <= 0) continue;
                    buf.append(", ");
                }
                buf.append(") in class class ").append(clazz.getName()).append(". Assuming no such method.");
                logger.log(InternalLogger.Level.WARN, buf.toString(), cdfe);
            }
        }
        catch (SuitableMethodNotAccessibleException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InvocationTargetException(throwable, "Unexpected problem trying to get method " + name);
        }
        return null;
    }

    protected static boolean accept(Method method, boolean acceptPrivate, boolean acceptPackage, boolean allowReturnValue) {
        if (!(Void.TYPE == method.getReturnType() || ClassUtils.MAP_CLASS == method.getReturnType() && allowReturnValue)) {
            return false;
        }
        int mod = method.getModifiers();
        if (Modifier.isStatic(mod)) {
            return false;
        }
        if (Modifier.isPublic(mod) || Modifier.isProtected(mod)) {
            BaseMethod.setAccessible(method);
            return true;
        }
        if (Modifier.isPrivate(mod)) {
            if (acceptPrivate) {
                BaseMethod.setAccessible(method);
                return true;
            }
            return false;
        }
        if (acceptPackage) {
            BaseMethod.setAccessible(method);
            return true;
        }
        return false;
    }

    private static void setAccessible(final Method method) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                method.setAccessible(true);
                return null;
            }
        });
    }

    public static String getPackageName(Class<?> clazz) {
        String name = clazz.getName();
        int dot = name.lastIndexOf(46);
        return dot > 0 ? name.substring(0, dot) : "";
    }

    public MethodResult invoke(Object componentInstance, P rawParameter, MethodResult methodCallFailureResult) {
        try {
            return this.m_state.invoke(this, componentInstance, rawParameter);
        }
        catch (InvocationTargetException ite) {
            ((BaseParameter)rawParameter).getComponentContext().getLogger().log(InternalLogger.Level.ERROR, "The {0} method has thrown an exception", ite.getCause(), this.getMethodName());
            if (methodCallFailureResult != null && methodCallFailureResult.getResult() != null) {
                methodCallFailureResult.getResult().put("exception", ite.getCause());
            }
            return methodCallFailureResult;
        }
    }

    public boolean methodExists(ComponentLogger logger) {
        return this.m_state.methodExists(this, logger);
    }

    protected static final class MethodInfo<T> {
        private final Method m_method;
        private final T m_types;

        public MethodInfo(Method m) {
            this(m, null);
        }

        public MethodInfo(Method m, T types) {
            this.m_method = m;
            this.m_types = types;
        }

        public Method getMethod() {
            return this.m_method;
        }

        public T getTypes() {
            return this.m_types;
        }
    }

    private static class NotApplicable
    implements State {
        private static final State INSTANCE = new NotApplicable();

        private NotApplicable() {
        }

        @Override
        public <P extends BaseParameter, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter) {
            return MethodResult.VOID;
        }

        @Override
        public <P extends BaseParameter, T> boolean methodExists(BaseMethod<P, T> baseMethod, ComponentLogger logger) {
            return true;
        }
    }

    private static interface State {
        public <P extends BaseParameter, T> MethodResult invoke(BaseMethod<P, T> var1, Object var2, P var3) throws InvocationTargetException;

        public <P extends BaseParameter, T> boolean methodExists(BaseMethod<P, T> var1, ComponentLogger var2);
    }

    private static class NotResolved
    implements State {
        private static final State INSTANCE = new NotResolved();

        private NotResolved() {
        }

        private <P extends BaseParameter, T> void resolve(BaseMethod<P, T> baseMethod, ComponentLogger logger) {
            logger.log(InternalLogger.Level.TRACE, "getting {0}: {1}", null, baseMethod.getMethodNamePrefix(), baseMethod.getMethodName());
            MethodInfo method = null;
            try {
                method = ((BaseMethod)baseMethod).findMethod(logger);
            }
            catch (InvocationTargetException ex) {
                logger.log(InternalLogger.Level.WARN, "{0} cannot be found", ex.getTargetException(), baseMethod.getMethodName());
            }
            baseMethod.setMethod(method, logger);
        }

        @Override
        public <P extends BaseParameter, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter) throws InvocationTargetException {
            this.resolve(baseMethod, rawParameter.getComponentContext().getLogger());
            return baseMethod.getState().invoke(baseMethod, componentInstance, rawParameter);
        }

        @Override
        public <P extends BaseParameter, T> boolean methodExists(BaseMethod<P, T> baseMethod, ComponentLogger logger) {
            this.resolve(baseMethod, logger);
            return baseMethod.getState().methodExists(baseMethod, logger);
        }
    }

    private static class Resolved
    implements State {
        private static final State INSTANCE = new Resolved();

        private Resolved() {
        }

        @Override
        public <P extends BaseParameter, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter) throws InvocationTargetException {
            return ((BaseMethod)baseMethod).invokeMethod(componentInstance, rawParameter);
        }

        @Override
        public <P extends BaseParameter, T> boolean methodExists(BaseMethod<P, T> baseMethod, ComponentLogger logger) {
            return true;
        }
    }

    private static class NotFound
    implements State {
        private static final State INSTANCE = new NotFound();

        private NotFound() {
        }

        @Override
        public <P extends BaseParameter, T> MethodResult invoke(BaseMethod<P, T> baseMethod, Object componentInstance, P rawParameter) {
            rawParameter.getComponentContext().getLogger().log(InternalLogger.Level.ERROR, "{0} method [{1}] not found", null, baseMethod.getMethodNamePrefix(), baseMethod.getMethodName());
            return null;
        }

        @Override
        public <P extends BaseParameter, T> boolean methodExists(BaseMethod<P, T> baseMethod, ComponentLogger logger) {
            return false;
        }
    }
}

