/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.SimpleLifeCycle;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.remote.AbstractOperationHandler;
import org.eclipse.rap.rwt.remote.RemoteObject;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private static final String REMOTE_TYPE = "rwt.client.Clipboard";
    private static final String PROP_TEXT = "text";
    private static final String PROP_OPERATION = "operation";
    private static final String PROP_RESULT = "result";
    private static final String PROP_ERROR_MESSAGE = "errorMessage";
    private static final String METHOD_OPERATION_SUCCEEDED = "operationSucceeded";
    private static final String METHOD_OPERATION_FAILED = "operationFailed";
    private static final String METHOD_READ_TEXT = "readText";
    private static final String METHOD_WRITE_TEXT = "writeText";
    private Display display;
    private final RemoteObject remoteObject;
    private ClipboardListener listener;
    private boolean operationPending;
    private Object operationResult;

    public Clipboard(Display display) {
        this.checkSubclass();
        this.display = display;
        if (this.display == null) {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = Display.getDefault();
            }
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.remoteObject = RWT.getUISession().getConnection().createRemoteObject(REMOTE_TYPE);
        this.remoteObject.setHandler(new ClipboardOperationHandler());
    }

    void setClipboardListener(ClipboardListener listener) {
        this.checkWidget();
        if (listener == null) {
            DND.error(4);
        }
        this.listener = listener;
    }

    void writeText(String text) {
        this.checkWidget();
        if (text == null) {
            DND.error(4);
        }
        this.remoteObject.call(METHOD_WRITE_TEXT, new JsonObject().add(PROP_TEXT, text));
    }

    void readText() {
        this.checkWidget();
        this.remoteObject.call(METHOD_READ_TEXT, null);
    }

    public Object getContents(Transfer transfer) {
        Clipboard.checkOperationMode();
        this.checkWidget();
        if (transfer == null) {
            DND.error(4);
        }
        if (!(transfer instanceof TextTransfer)) {
            DND.error(5);
        }
        if (this.operationPending) {
            throw new IllegalStateException("Another clipboard operation is already pending");
        }
        this.operationPending = true;
        this.operationResult = null;
        this.readText();
        while (this.operationResult == null) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.operationPending = false;
        return this.operationResult instanceof SWTException ? null : this.operationResult;
    }

    public void setContents(Object[] data, Transfer[] dataTypes) {
        Clipboard.checkOperationMode();
        this.checkWidget();
        if (data == null || dataTypes == null || data.length != dataTypes.length || data.length != 1) {
            DND.error(5);
        }
        int i = 0;
        while (i < data.length) {
            if (data[i] == null || dataTypes[i] == null || !(dataTypes[i] instanceof TextTransfer) || !dataTypes[i].validate(data[i])) {
                DND.error(5);
            }
            ++i;
        }
        if (this.operationPending) {
            throw new IllegalStateException("Another clipboard operation is already pending");
        }
        this.operationPending = true;
        this.operationResult = null;
        this.writeText((String)data[0]);
        while (this.operationResult == null) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.operationPending = false;
        if (this.operationResult instanceof SWTException) {
            DND.error(2002);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = null;
        this.remoteObject.destroy();
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    protected void checkWidget() {
        if (this.display == null) {
            DND.error(24);
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (this.display.isDisposed()) {
            DND.error(24);
        }
    }

    protected void checkSubclass() {
        String name = this.getClass().getName();
        String validName = Clipboard.class.getName();
        if (!validName.equals(name)) {
            DND.error(43);
        }
    }

    private static void checkOperationMode() {
        if (ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle() instanceof SimpleLifeCycle) {
            throw new UnsupportedOperationException("Method not supported in JEE_COMPATIBILITY mode.");
        }
    }

    private static interface ClipboardListener {
        public void operationSucceeded(ClipboardOperation var1, String var2);

        public void operationFailed(ClipboardOperation var1, String var2);
    }

    static enum ClipboardOperation {
        WRITE_TEXT,
        READ_TEXT;

    }

    private class ClipboardOperationHandler
    extends AbstractOperationHandler {
        private ClipboardOperationHandler() {
        }

        @Override
        public void handleCall(String methodName, JsonObject properties) {
            if (Clipboard.METHOD_OPERATION_SUCCEEDED.equals(methodName)) {
                final ClipboardOperation operation = this.getOperation(properties);
                final String result = properties.get(Clipboard.PROP_RESULT).asString();
                Clipboard.this.operationResult = result;
                if (Clipboard.this.listener != null) {
                    ProcessActionRunner.add(new Runnable(){

                        @Override
                        public void run() {
                            Clipboard.this.listener.operationSucceeded(operation, result);
                        }
                    });
                }
            } else if (Clipboard.METHOD_OPERATION_FAILED.equals(methodName)) {
                final ClipboardOperation operation = this.getOperation(properties);
                final String errorMessage = properties.get(Clipboard.PROP_ERROR_MESSAGE).asString();
                if (ClipboardOperation.WRITE_TEXT.equals((Object)operation)) {
                    Clipboard.this.operationResult = new SWTException(13, errorMessage);
                } else if (ClipboardOperation.READ_TEXT.equals((Object)operation)) {
                    Clipboard.this.operationResult = new SWTException(12, errorMessage);
                } else {
                    Clipboard.this.operationResult = new SWTException(errorMessage);
                }
                if (Clipboard.this.listener != null) {
                    ProcessActionRunner.add(new Runnable(){

                        @Override
                        public void run() {
                            Clipboard.this.listener.operationFailed(operation, errorMessage);
                        }
                    });
                }
            }
        }

        private ClipboardOperation getOperation(JsonObject properties) {
            String operation = properties.get(Clipboard.PROP_OPERATION).asString();
            if (Clipboard.METHOD_WRITE_TEXT.equals(operation)) {
                return ClipboardOperation.WRITE_TEXT;
            }
            if (Clipboard.METHOD_READ_TEXT.equals(operation)) {
                return ClipboardOperation.READ_TEXT;
            }
            return null;
        }
    }
}

