/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.Util;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.quickaccess.PreviousPicksProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessEntry;
import org.eclipse.ui.internal.quickaccess.QuickAccessMatcher;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public abstract class QuickAccessContents {
    private static final String QUICK_ACCESS_COMMAND_ID = "org.eclipse.ui.window.quickAccess";
    protected Text filterText;
    private QuickAccessProvider[] providers;
    private Map<String, QuickAccessProvider> providerMap = new HashMap<String, QuickAccessProvider>();
    private Map<QuickAccessElement, QuickAccessProvider> elementsToProviders = new HashMap<QuickAccessElement, QuickAccessProvider>();
    protected Table table;
    protected Label infoLabel;
    private LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());
    protected String rememberedText;
    private Color grayColor;
    private boolean showAllMatches = false;
    protected boolean resized = false;
    private TriggerSequence keySequence;
    private Job computeProposalsJob;
    int numberOfFilteredResults;
    Pattern categoryPattern;
    Label hintText;
    private boolean displayHintText;

    public QuickAccessContents(QuickAccessProvider[] providers) {
        this.providers = providers;
    }

    private int computeNumberOfItems() {
        Rectangle rect = this.table.getClientArea();
        int itemHeight = this.table.getItemHeight();
        int headerHeight = this.table.getHeaderHeight();
        return (rect.height - headerHeight + itemHeight - 1) / (itemHeight + this.table.getGridLineWidth());
    }

    public void updateProposals(final String filter) {
        if (this.computeProposalsJob != null) {
            this.computeProposalsJob.cancel();
            this.computeProposalsJob = null;
        }
        if (this.table == null || this.table.isDisposed()) {
            return;
        }
        final Display display = this.table.getDisplay();
        final QuickAccessElement perfectMatch = this.getPerfectMatch(filter);
        final String computingMessage = NLS.bind((String)QuickAccessMessages.get().QuickaAcessContents_computeMatchingEntries, (Object)filter);
        final int maxNumberOfItemsInTable = this.computeNumberOfItems();
        final AtomicReference entries = new AtomicReference();
        final UIJob currentComputeEntriesJob = new UIJob(this.table.getDisplay(), computingMessage){

            @Override
            public IStatus runInUIThread(IProgressMonitor theMonitor) {
                entries.set(QuickAccessContents.this.computeMatchingEntries(filter, perfectMatch, maxNumberOfItemsInTable, theMonitor));
                return theMonitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            }
        };
        currentComputeEntriesJob.setPriority(10);
        final UIJob computingFeedbackJob = new UIJob(this.table.getDisplay(), QuickAccessMessages.get().QuickAccessContents_computeMatchingEntries_displayFeedback_jobName){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (currentComputeEntriesJob.getResult() == null && !monitor.isCanceled() && !QuickAccessContents.this.table.isDisposed()) {
                    QuickAccessContents.this.showHintText(computingMessage, QuickAccessContents.this.grayColor);
                    return Status.OK_STATUS;
                }
                return Status.CANCEL_STATUS;
            }
        };
        currentComputeEntriesJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                computingFeedbackJob.cancel();
                if (QuickAccessContents.this.computeProposalsJob == currentComputeEntriesJob && event.getResult().isOK() && !QuickAccessContents.this.table.isDisposed()) {
                    display.asyncExec(() -> {
                        computingFeedbackJob.cancel();
                        QuickAccessContents.this.refreshTable(perfectMatch, (List[])entries.get(), filter);
                    });
                }
            }
        });
        this.computeProposalsJob = currentComputeEntriesJob;
        currentComputeEntriesJob.schedule();
    }

    protected abstract QuickAccessElement getPerfectMatch(String var1);

    protected abstract void updateFeedback(boolean var1, boolean var2);

    public void setShowAllMatches(boolean showAll) {
        if (this.showAllMatches != showAll) {
            this.showAllMatches = showAll;
            this.updateInfoLabel();
            this.updateProposals(this.filterText.getText().toLowerCase());
        }
    }

    private void updateInfoLabel() {
        if (this.infoLabel != null) {
            boolean forceHide;
            TriggerSequence sequence = this.getTriggerSequence();
            boolean bl = forceHide = this.getNumberOfFilteredResults() == 0 || this.showAllMatches && this.table.getItemCount() <= this.computeNumberOfItems();
            if (sequence == null || forceHide) {
                this.infoLabel.setText("");
            } else if (this.showAllMatches) {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.get().QuickAccessContents_PressKeyToLimitResults, (Object)sequence.format()));
            } else {
                this.infoLabel.setText(NLS.bind((String)QuickAccessMessages.get().QuickAccess_PressKeyToShowAllMatches, (Object)sequence.format()));
            }
            this.infoLabel.getParent().layout(true);
        }
    }

    public TriggerSequence getTriggerSequence() {
        if (this.keySequence == null) {
            IBindingService bindingService = (IBindingService)Adapters.adapt((Object)PlatformUI.getWorkbench(), IBindingService.class);
            this.keySequence = bindingService.getBestActiveBindingFor(QUICK_ACCESS_COMMAND_ID);
        }
        return this.keySequence;
    }

    public boolean getShowAllMatches() {
        return this.showAllMatches;
    }

    private void refreshTable(QuickAccessElement perfectMatch, List<QuickAccessEntry>[] entries, String filter) {
        if (this.table.isDisposed()) {
            return;
        }
        if (this.table.getItemCount() > entries.length && this.table.getItemCount() - entries.length > 20) {
            this.table.removeAll();
        }
        TableItem[] items = this.table.getItems();
        int selectionIndex = -1;
        int index = 0;
        List<QuickAccessEntry>[] listArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            List<QuickAccessEntry> entriesForCurrentCategory = listArray[n2];
            if (entriesForCurrentCategory != null) {
                boolean firstEntry = true;
                Iterator<QuickAccessEntry> it = entriesForCurrentCategory.iterator();
                while (it.hasNext()) {
                    TableItem item;
                    QuickAccessEntry entry = it.next();
                    entry.firstInCategory = firstEntry;
                    firstEntry = false;
                    if (!it.hasNext()) {
                        entry.lastInCategory = true;
                    }
                    if (index < items.length) {
                        item = items[index];
                        this.table.clear(index);
                    } else {
                        item = new TableItem(this.table, 0);
                    }
                    if (perfectMatch == entry.element && selectionIndex == -1) {
                        selectionIndex = index;
                    }
                    item.setData((Object)entry);
                    item.setText(0, entry.firstInCategory ? entry.provider.getName() : "");
                    item.setText(1, entry.element.getLabel());
                    if (Util.isWpf()) {
                        item.setImage(1, entry.getImage(entry.element, (ResourceManager)this.resourceManager));
                    }
                    ++index;
                }
            }
            ++n2;
        }
        if (index < items.length) {
            this.table.remove(index, items.length - 1);
        }
        if (selectionIndex == -1) {
            selectionIndex = 0;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selectionIndex);
            this.hideHintText();
        } else if (filter.isEmpty()) {
            this.showHintText(QuickAccessMessages.get().QuickAccess_StartTypingToFindMatches, this.grayColor);
        } else {
            this.showHintText(QuickAccessMessages.get().QuickAccessContents_NoMatchingResults, this.grayColor);
        }
        this.updateInfoLabel();
        this.updateFeedback(filter.isEmpty(), this.showAllMatches);
    }

    protected int getNumberOfFilteredResults() {
        return this.numberOfFilteredResults;
    }

    /*
     * WARNING - void declaration
     */
    private List<QuickAccessEntry>[] computeMatchingEntries(String filter, QuickAccessElement perfectMatch, int maxNumberOfItemsInTable, IProgressMonitor aMonitor) {
        void var10_23;
        void var10_19;
        if (aMonitor == null) {
            aMonitor = new NullProgressMonitor();
        }
        Matcher categoryMatcher = this.getCategoryPattern().matcher(filter);
        String category = null;
        if (categoryMatcher.matches()) {
            category = categoryMatcher.group(1);
            filter = String.valueOf(category) + " " + categoryMatcher.group(2);
        }
        String finalFilter = filter;
        LinkedHashMap<QuickAccessProvider, List> elementsForProviders = new LinkedHashMap<QuickAccessProvider, List>(this.providers.length);
        QuickAccessProvider[] quickAccessProviderArray = this.providers;
        int n = this.providers.length;
        boolean bl = false;
        while (var10_19 < n) {
            QuickAccessProvider provider2 = quickAccessProviderArray[var10_19];
            if (aMonitor.isCanceled()) break;
            boolean isPreviousPickProvider = provider2 instanceof PreviousPicksProvider;
            if ((category == null || category.equalsIgnoreCase(provider2.getName()) || isPreviousPickProvider) && (!filter.isEmpty() || isPreviousPickProvider || this.showAllMatches)) {
                AtomicReference<List<QuickAccessElement>> sortedElementRef = new AtomicReference<List<QuickAccessElement>>();
                if (provider2.requiresUiAccess()) {
                    Display.getCurrent().syncExec(() -> sortedElementRef.set(Arrays.asList(provider2.getElementsSorted(finalFilter, (IProgressMonitor)new NullProgressMonitor()))));
                } else {
                    sortedElementRef.set(Arrays.asList(provider2.getElementsSorted(filter, aMonitor)));
                }
                List<QuickAccessElement> sortedElements = (List<QuickAccessElement>)sortedElementRef.get();
                if (sortedElements == null) {
                    sortedElements = Collections.emptyList();
                }
                if (!(provider2 instanceof PreviousPicksProvider)) {
                    for (QuickAccessElement element2 : sortedElements) {
                        this.elementsToProviders.put(element2, provider2);
                    }
                }
                if (!filter.isEmpty() && !sortedElements.isEmpty()) {
                    sortedElements = QuickAccessContents.putPrefixMatchFirst(sortedElements, filter);
                }
                elementsForProviders.put(provider2, new ArrayList<QuickAccessElement>(sortedElements));
            }
            ++var10_19;
        }
        ArrayList prevPickIds = new ArrayList();
        for (Map.Entry entry : elementsForProviders.entrySet()) {
            if (!(entry.getKey() instanceof PreviousPicksProvider)) continue;
            prevPickIds.addAll(((List)entry.getValue()).stream().map(QuickAccessElement::getId).collect(Collectors.toList()));
        }
        for (Map.Entry entry : elementsForProviders.entrySet()) {
            if (entry.getKey() instanceof PreviousPicksProvider) continue;
            ArrayList filteredElements = new ArrayList((Collection)entry.getValue());
            filteredElements.removeIf(element -> prevPickIds.contains(element.getId()));
            entry.setValue(filteredElements);
        }
        Object var10_22 = null;
        if (perfectMatch != null) {
            for (Map.Entry entry : elementsForProviders.entrySet()) {
                ArrayList<QuickAccessElement> filteredElements;
                if (var10_23 == null || !(filteredElements = new ArrayList<QuickAccessElement>((Collection)entry.getValue())).removeIf(element -> prevPickIds.contains(element.getId()))) continue;
                entry.setValue(filteredElements);
                QuickAccessProvider quickAccessProvider = (QuickAccessProvider)entry.getKey();
            }
        }
        LinkedHashMap<QuickAccessProvider, List<Object>> linkedHashMap = new LinkedHashMap<QuickAccessProvider, List<Object>>(elementsForProviders.size());
        if (this.showAllMatches) {
            for (Map.Entry elementsPerProvider : elementsForProviders.entrySet()) {
                QuickAccessProvider provider3 = (QuickAccessProvider)elementsPerProvider.getKey();
                List entries = ((List)elementsPerProvider.getValue()).stream().map(QuickAccessMatcher::new).map(matcher -> matcher.match(finalFilter, provider3)).filter(Objects::nonNull).collect(Collectors.toList());
                if (entries.isEmpty()) continue;
                linkedHashMap.put(provider3, entries);
            }
        } else {
            int numberOfSlotsLeft = perfectMatch != null ? maxNumberOfItemsInTable - 1 : maxNumberOfItemsInTable;
            while (!elementsForProviders.isEmpty() && numberOfSlotsLeft > 0) {
                QuickAccessEntry entry;
                int nbEntriesPerProvider = numberOfSlotsLeft / elementsForProviders.size();
                if (nbEntriesPerProvider > 0) {
                    for (Map.Entry elementsPerProvider : elementsForProviders.entrySet()) {
                        QuickAccessProvider provider4 = (QuickAccessProvider)elementsPerProvider.getKey();
                        List elements2 = (List)elementsPerProvider.getValue();
                        int toPickEntries = nbEntriesPerProvider;
                        while (toPickEntries > 0 && !elements2.isEmpty()) {
                            QuickAccessElement element3 = (QuickAccessElement)elements2.remove(0);
                            entry = new QuickAccessMatcher(element3).match(filter, provider4);
                            if (entry == null) continue;
                            --numberOfSlotsLeft;
                            --toPickEntries;
                            if (!linkedHashMap.containsKey(provider4)) {
                                linkedHashMap.put(provider4, new LinkedList());
                            }
                            ((List)linkedHashMap.get(provider4)).add(entry);
                        }
                    }
                } else {
                    for (Map.Entry elementsForProvider : elementsForProviders.entrySet()) {
                        if (numberOfSlotsLeft <= 0) continue;
                        QuickAccessProvider provider2 = (QuickAccessProvider)elementsForProvider.getKey();
                        List elements2 = (List)elementsForProvider.getValue();
                        boolean entryPicked = false;
                        while (!entryPicked && !elements2.isEmpty()) {
                            QuickAccessElement element2 = (QuickAccessElement)elements2.remove(0);
                            entry = new QuickAccessMatcher(element2).match(filter, provider2);
                            if (entry == null) continue;
                            --numberOfSlotsLeft;
                            entryPicked = true;
                            if (!linkedHashMap.containsKey(provider2)) {
                                linkedHashMap.put(provider2, new LinkedList());
                            }
                            ((List)linkedHashMap.get(provider2)).add(entry);
                        }
                    }
                }
                HashSet exhaustedProviders = new HashSet();
                elementsForProviders.forEach((provider, elements) -> {
                    if (elements.isEmpty()) {
                        exhaustedProviders.add(provider);
                    }
                });
                exhaustedProviders.forEach(elementsForProviders::remove);
            }
        }
        ArrayList<List<QuickAccessEntry>> res = new ArrayList<List<QuickAccessEntry>>();
        if (perfectMatch != null) {
            res.add(Collections.singletonList(new QuickAccessEntry(perfectMatch, (QuickAccessProvider)(var10_23 != null ? var10_23 : this.providers[0]), new int[0][0], new int[0][0], 0)));
        }
        res.addAll(linkedHashMap.values());
        return res.toArray(new List[res.size()]);
    }

    private static List<QuickAccessElement> putPrefixMatchFirst(List<QuickAccessElement> elements, String prefix) {
        ArrayList<QuickAccessElement> res = new ArrayList<QuickAccessElement>(elements);
        ArrayList<Integer> matchingIndexes = new ArrayList<Integer>();
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i).getLabel().toLowerCase().startsWith(prefix.toLowerCase())) {
                matchingIndexes.add(i);
            }
            ++i;
        }
        int currentMatchIndex = 0;
        int currentNonMatchIndex = matchingIndexes.size();
        int i2 = 0;
        while (i2 < res.size()) {
            boolean isMatch;
            boolean bl = isMatch = !matchingIndexes.isEmpty() && (Integer)matchingIndexes.iterator().next() == i2;
            if (isMatch) {
                matchingIndexes.remove(0);
                res.set(currentMatchIndex, elements.get(i2));
                ++currentMatchIndex;
            } else {
                res.set(currentNonMatchIndex, elements.get(i2));
                ++currentNonMatchIndex;
            }
            ++i2;
        }
        return res;
    }

    protected Pattern getCategoryPattern() {
        if (this.categoryPattern == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("^(:?");
            int i = 0;
            while (i < this.providers.length) {
                if (i != 0) {
                    sb.append("|");
                }
                sb.append(this.providers[i].getName());
                ++i;
            }
            sb.append("):\\s?(.*)");
            String regex = sb.toString();
            this.categoryPattern = Pattern.compile(regex, 2);
        }
        return this.categoryPattern;
    }

    private void doDispose() {
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
    }

    protected String getId() {
        return "org.eclipse.ui.internal.QuickAccess";
    }

    protected abstract void handleElementSelected(String var1, Object var2);

    private void handleSelection() {
        QuickAccessElement selectedElement = null;
        String text = this.filterText.getText().toLowerCase();
        if (this.table.getSelectionCount() == 1) {
            QuickAccessEntry entry = (QuickAccessEntry)this.table.getSelection()[0].getData();
            QuickAccessElement quickAccessElement = selectedElement = entry == null ? null : entry.element;
        }
        if (selectedElement != null) {
            this.doClose();
            this.handleElementSelected(text, selectedElement);
        }
    }

    public void preOpen() {
        this.setShowAllMatches(false);
        this.keySequence = null;
        this.updateInfoLabel();
    }

    protected abstract void doClose();

    public void hookFilterText(Text filterText) {
        this.filterText = filterText;
        filterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                switch (e.keyCode) {
                    case 13: 
                    case 0x1000050: {
                        QuickAccessContents.this.handleSelection();
                        break;
                    }
                    case 0x1000002: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || QuickAccessContents.this.table.getItemCount() <= index + 1) break;
                        QuickAccessContents.this.table.setSelection(index + 1);
                        break;
                    }
                    case 0x1000001: {
                        int index = QuickAccessContents.this.table.getSelectionIndex();
                        if (index == -1 || index < 1) break;
                        QuickAccessContents.this.table.setSelection(index - 1);
                        break;
                    }
                    case 27: {
                        QuickAccessContents.this.doClose();
                    }
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        filterText.addModifyListener((ModifyListener & Serializable)e -> {
            String text = ((Text)e.widget).getText();
            this.updateProposals(text);
        });
    }

    Label createHintText(Composite composite, int defaultOrientation) {
        this.hintText = new Label(composite, 4);
        this.hintText.setOrientation(defaultOrientation);
        this.displayHintText = true;
        return this.hintText;
    }

    private void hideHintText() {
        if (this.displayHintText) {
            this.setHintTextToDisplay(false);
        }
    }

    private void showHintText(String text, Color color) {
        if (this.hintText == null || this.hintText.isDisposed()) {
            return;
        }
        this.hintText.setText(text);
        if (color != null) {
            this.hintText.setForeground(color);
        }
        if (!this.displayHintText) {
            this.setHintTextToDisplay(true);
        }
    }

    private void setHintTextToDisplay(boolean toDisplay) {
        GridData data = (GridData)this.hintText.getLayoutData();
        data.exclude = !toDisplay;
        this.hintText.setVisible(toDisplay);
        this.hintText.requestLayout();
        this.displayHintText = toDisplay;
    }

    public Table createTable(Composite composite, int defaultOrientation) {
        composite.addDisposeListener((DisposeListener & Serializable)e -> this.doDispose());
        Composite tableComposite = new Composite(composite, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tableComposite);
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        tableComposite.setLayout((Layout)tableColumnLayout);
        this.table = new Table(tableComposite, 65540);
        this.table.setLinesVisible(true);
        Font boldFont = this.resourceManager.createFont(FontDescriptor.createFrom((Font)this.table.getFont()).setStyle(1));
        int maxProviderWidth = 0;
        GC gc = new GC((Drawable)this.table.getDisplay());
        try {
            gc.setFont(boldFont);
            QuickAccessProvider[] quickAccessProviderArray = this.providers;
            int n = this.providers.length;
            int n2 = 0;
            while (n2 < n) {
                QuickAccessProvider provider = quickAccessProviderArray[n2];
                int width = gc.textExtent((String)provider.getName()).x;
                if (width > maxProviderWidth) {
                    maxProviderWidth = width;
                }
                ++n2;
            }
        }
        finally {
            gc.dispose();
        }
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(0, maxProviderWidth));
        tableColumnLayout.setColumnData((Widget)new TableColumn(this.table, 0), (ColumnLayoutData)new ColumnWeightData(100, 100));
        this.table.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                if (!QuickAccessContents.this.showAllMatches && !QuickAccessContents.this.resized) {
                    QuickAccessContents.this.resized = true;
                    e.display.timerExec(100, () -> {
                        if (QuickAccessContents.this.table != null && !QuickAccessContents.this.table.isDisposed() && QuickAccessContents.this.filterText != null && !QuickAccessContents.this.filterText.isDisposed()) {
                            QuickAccessContents.this.updateProposals(QuickAccessContents.this.filterText.getText().toLowerCase());
                        }
                        QuickAccessContents.this.resized = false;
                    });
                }
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && QuickAccessContents.this.table.getSelectionIndex() == 0) {
                    QuickAccessContents.this.filterText.setFocus();
                } else if (e.character == '\u001b') {
                    QuickAccessContents.this.doClose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (QuickAccessContents.this.table.getSelectionCount() < 1) {
                    return;
                }
                if (e.button != 1) {
                    return;
                }
                if (QuickAccessContents.this.table.equals(e.getSource())) {
                    TableItem o = QuickAccessContents.this.table.getItem(new Point(e.x, e.y));
                    TableItem selection = QuickAccessContents.this.table.getSelection()[0];
                    if (selection.equals(o)) {
                        QuickAccessContents.this.handleSelection();
                    }
                }
            }
        });
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickAccessContents.this.handleSelection();
            }
        });
        return this.table;
    }

    public Label createInfoLabel(Composite parent) {
        this.infoLabel = new Label(parent, 0);
        this.infoLabel.setFont(parent.getFont());
        this.infoLabel.setForeground(this.grayColor);
        this.infoLabel.setBackground(this.table.getBackground());
        GridData gd = new GridData(768);
        gd.horizontalAlignment = 131072;
        gd.grabExcessHorizontalSpace = false;
        this.infoLabel.setLayoutData((Object)gd);
        this.updateInfoLabel();
        return this.infoLabel;
    }

    QuickAccessProvider getProvider(String providerId) {
        if (this.providers == null || this.providers.length == 0) {
            return null;
        }
        if (this.providerMap == null || this.providerMap.size() != this.providers.length) {
            this.providerMap = Arrays.stream(this.providers).collect(Collectors.toMap(QuickAccessProvider::getId, Function.identity()));
        }
        return this.providerMap.get(providerId);
    }

    QuickAccessProvider getProviderFor(QuickAccessElement quickAccessElement) {
        return this.elementsToProviders.get(quickAccessElement);
    }

    void registerProviderFor(QuickAccessElement quickAccessElement, QuickAccessProvider quickAccessProvider) {
        if (quickAccessElement == null || quickAccessProvider == null) {
            return;
        }
        this.elementsToProviders.put(quickAccessElement, quickAccessProvider);
    }

    public Text getFilterText() {
        return this.filterText;
    }

    public Table getTable() {
        return this.table;
    }
}

