/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.set;

import org.eclipse.core.databinding.observable.DecoratingObservableCollection;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;
import org.eclipse.core.databinding.observable.set.SetDiff;

public class DecoratingObservableSet<E>
extends DecoratingObservableCollection<E>
implements IObservableSet<E> {
    private IObservableSet<E> decorated;
    private ISetChangeListener<E> setChangeListener;

    public DecoratingObservableSet(IObservableSet<E> decorated, boolean disposeDecoratedOnDispose) {
        super(decorated, disposeDecoratedOnDispose);
        this.decorated = decorated;
    }

    @Override
    public void clear() {
        this.getterCalled();
        this.decorated.clear();
    }

    @Override
    public synchronized void addSetChangeListener(ISetChangeListener<? super E> listener) {
        this.addListener(SetChangeEvent.TYPE, listener);
    }

    @Override
    public synchronized void removeSetChangeListener(ISetChangeListener<? super E> listener) {
        this.removeListener(SetChangeEvent.TYPE, listener);
    }

    protected void fireSetChange(SetDiff<E> diff) {
        super.fireChange();
        this.fireEvent(new SetChangeEvent<E>(this, diff));
    }

    @Override
    protected void fireChange() {
        throw new RuntimeException("fireChange should not be called, use fireSetChange() instead");
    }

    @Override
    protected void firstListenerAdded() {
        if (this.setChangeListener == null) {
            this.setChangeListener = this::handleSetChange;
        }
        this.decorated.addSetChangeListener(this.setChangeListener);
        super.firstListenerAdded();
    }

    @Override
    protected void lastListenerRemoved() {
        super.lastListenerRemoved();
        if (this.setChangeListener != null) {
            this.decorated.removeSetChangeListener(this.setChangeListener);
            this.setChangeListener = null;
        }
    }

    protected void handleSetChange(SetChangeEvent<? extends E> event) {
        this.fireSetChange(Diffs.unmodifiableDiff(event.diff));
    }

    @Override
    public synchronized void dispose() {
        if (this.decorated != null && this.setChangeListener != null) {
            this.decorated.removeSetChangeListener(this.setChangeListener);
        }
        this.decorated = null;
        this.setChangeListener = null;
        super.dispose();
    }
}

