/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.rap.rwt.Adaptable;
import org.eclipse.rap.rwt.internal.lifecycle.SimpleLifeCycle;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.textsize.TextSizeUtil;
import org.eclipse.rap.rwt.widgets.DialogCallback;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public abstract class Dialog
implements Adaptable,
SerializableCompatibility {
    private static final int HORIZONTAL_DIALOG_UNIT_PER_CHAR = 4;
    final int style;
    final Shell parent;
    protected Shell shell;
    protected int returnCode;
    String title;

    public Dialog(Shell parent) {
        this(parent, 32768);
    }

    public Dialog(Shell parent, int style) {
        Dialog.checkParent(parent);
        this.parent = parent;
        this.style = style;
        this.title = "";
    }

    public Shell getParent() {
        return this.parent;
    }

    public int getStyle() {
        return this.style;
    }

    public String getText() {
        return this.title;
    }

    public void setText(String string) {
        if (string == null) {
            SWT.error(4);
        }
        this.title = string;
    }

    public void open(final DialogCallback dialogCallback) {
        this.prepareOpen();
        this.returnCode = 256;
        this.shell.open();
        this.shell.addShellListener(new ShellAdapter(){

            @Override
            public void shellClosed(ShellEvent event) {
                if (dialogCallback != null) {
                    dialogCallback.dialogClosed(Dialog.this.returnCode);
                }
            }
        });
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    protected void prepareOpen() {
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            SWT.error(43);
        }
    }

    protected void checkOperationMode() {
        if (ContextProvider.getApplicationContext().getLifeCycleFactory().getLifeCycle() instanceof SimpleLifeCycle) {
            throw new UnsupportedOperationException("Method not supported in JEE_COMPATIBILITY mode.");
        }
    }

    protected void runEventLoop(Shell shell) {
        shell.open();
        Display display = shell.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    static int convertHorizontalDLUsToPixels(Control control, int dlus) {
        Font dialogFont = control.getFont();
        float charWidth = TextSizeUtil.getAvgCharWidth(dialogFont);
        float width = charWidth * (float)dlus + 2.0f;
        return (int)(width / 4.0f);
    }

    static int checkStyle(Shell parent, int style) {
        int result = style;
        int mask = 229376;
        if ((result & 0x10000000) != 0 && ((result &= 0xEFFFFFFF) & mask) == 0) {
            result |= parent == null ? 65536 : 32768;
        }
        if ((result & mask) == 0) {
            result |= 0x10000;
        }
        if ((result & 0x2000000) == 0 && parent != null && (parent.style & 0x2000000) != 0) {
            result |= 0x2000000;
        }
        return result;
    }

    private static void checkParent(Shell parent) {
        if (parent == null) {
            SWT.error(4);
        }
        parent.checkWidget();
    }
}

