/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.WorkingDirectoryBlock;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;

public class WorkingDirectorySection
extends WorkingDirectoryBlock {
    protected WorkingDirectorySection() {
        super(RWTLaunchConfig.WORKING_DIRECTORY);
    }

    protected IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        RWTLaunchConfig config = new RWTLaunchConfig(configuration);
        IProject result = null;
        IProject project = WorkingDirectorySection.findProject(config.getProjectName());
        if (project != null && project.exists() && project.isOpen()) {
            result = project;
        }
        return result;
    }

    protected void log(CoreException exception) {
        this.setErrorMessage(exception.getMessage());
    }

    private static IProject findProject(String projectName) {
        IProject result;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            result = workspaceRoot.getProject(projectName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            result = null;
        }
        return result;
    }
}

