/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.intro.target;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.rap.ui.internal.intro.Images;
import org.eclipse.rap.ui.internal.intro.target.IntroMessages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class InstallTargetDialog
extends TitleAreaDialog {
    private static final String TARGET_REPOSITORY_LATEST_BUILD = "http://download.eclipse.org/rt/rap/targets/runtime-latest-stable.target";
    private static final String TARGET_REPOSITORY_LATEST_RELEASE = "http://download.eclipse.org/rt/rap/targets/runtime-latest-release.target";
    private static final String TARGET_QUALIFIER_LATEST_BUILD = "latest-stable-build.target";
    private static final String TARGET_QUALIFIER_LATEST_RELEASE = "latest-release.target";
    private static boolean isLatestBuild = true;
    private boolean shouldSwitchTarget = true;
    private Image titleImage;

    public InstallTargetDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(112);
        this.setHelpAvailable(false);
        isLatestBuild = true;
    }

    public boolean shouldSwitchTarget() {
        return this.shouldSwitchTarget;
    }

    public String getTargetRepository() {
        return isLatestBuild ? TARGET_REPOSITORY_LATEST_BUILD : TARGET_REPOSITORY_LATEST_RELEASE;
    }

    public static String getTargetFileName() {
        return isLatestBuild ? TARGET_QUALIFIER_LATEST_BUILD : TARGET_QUALIFIER_LATEST_RELEASE;
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        return new Point(initialSize.x, initialSize.y - 150);
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        this.configureDialog();
        this.createTargetDescription(result);
        this.createTargetLocationArea(result);
        this.createSwitchTargetArea(result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public boolean close() {
        if (this.titleImage != null) {
            this.titleImage.dispose();
        }
        return super.close();
    }

    private void configureDialog() {
        this.getShell().setText(IntroMessages.InstallDialog_ShellTitle);
        this.setTitle(IntroMessages.InstallDialog_DialogTitle);
        if (this.titleImage == null) {
            this.titleImage = Images.EXTRACT_TARGET.createImage(false);
        }
        this.setTitleImage(this.titleImage);
        this.setMessage(IntroMessages.InstallDialog_Message_selectLocation);
    }

    private void createTargetDescription(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        container.setLayout((Layout)new GridLayout());
        Label targetDescriptionLabel = new Label(container, 64);
        targetDescriptionLabel.setLayoutData((Object)this.getLayoutDataForDescriptions());
        targetDescriptionLabel.setText(IntroMessages.InstallTargetDialog_TargetDescriptionMsg);
    }

    private void createTargetLocationArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 128, true, false));
        container.setLayout((Layout)new GridLayout());
        Group targetSelectionGroup = new Group(container, 0);
        targetSelectionGroup.setLayout((Layout)new GridLayout(1, true));
        targetSelectionGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        String targetVersionGroupTitle = IntroMessages.InstallTargetDialog_TargetVersionGroupTitle;
        targetSelectionGroup.setText(targetVersionGroupTitle);
        this.createButtons(targetSelectionGroup);
    }

    private void createButtons(Group targetSelectionGroup) {
        Button latestStableBuildBtn = new Button((Composite)targetSelectionGroup, 16);
        String latestBuildText = IntroMessages.InstallTargetDialog_LatestBuildText;
        latestStableBuildBtn.setText(latestBuildText);
        latestStableBuildBtn.setSelection(true);
        latestStableBuildBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                isLatestBuild = true;
            }
        });
        Button latestReleaseBtn = new Button((Composite)targetSelectionGroup, 16);
        String latestReleaseText = IntroMessages.InstallTargetDialog_LatestReleaseText;
        latestReleaseBtn.setText(latestReleaseText);
        latestReleaseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                isLatestBuild = false;
            }
        });
    }

    private void createSwitchTargetArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(4, 4, true, false));
        Group grgTarget = new Group(container, 0);
        grgTarget.setLayout((Layout)new GridLayout());
        grgTarget.setLayoutData((Object)new GridData(4, 128, true, false));
        grgTarget.setText(IntroMessages.InstallDialog_TargetGroup);
        final Button switchTarget = new Button((Composite)grgTarget, 32);
        switchTarget.setText(IntroMessages.InstallDialog_switchTarget);
        switchTarget.setSelection(true);
        switchTarget.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstallTargetDialog.this.shouldSwitchTarget = switchTarget.getSelection();
            }
        });
        Label lblDescription = new Label((Composite)grgTarget, 64);
        lblDescription.setLayoutData((Object)this.getLayoutDataForDescriptions());
        lblDescription.setText(IntroMessages.InstallDialog_TargetDescription);
    }

    private GridData getLayoutDataForDescriptions() {
        GridData gridData = new GridData(768);
        gridData.widthHint = 120;
        return gridData;
    }
}

