/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.theme;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.engine.RWTFactory;
import org.eclipse.rwt.internal.lifecycle.LifeCycleAdapterUtil;
import org.eclipse.rwt.internal.resources.ResourceUtil;
import org.eclipse.rwt.internal.theme.AppearancesUtil;
import org.eclipse.rwt.internal.theme.IThemeCssElement;
import org.eclipse.rwt.internal.theme.QxCursor;
import org.eclipse.rwt.internal.theme.QxImage;
import org.eclipse.rwt.internal.theme.QxTheme;
import org.eclipse.rwt.internal.theme.QxType;
import org.eclipse.rwt.internal.theme.ResourceLoader;
import org.eclipse.rwt.internal.theme.Theme;
import org.eclipse.rwt.internal.theme.ThemeDefinitionReader;
import org.eclipse.rwt.internal.theme.ThemeManagerException;
import org.eclipse.rwt.internal.theme.ThemePropertyAdapterRegistry;
import org.eclipse.rwt.internal.theme.ThemeStoreWriter;
import org.eclipse.rwt.internal.theme.ThemeableWidget;
import org.eclipse.rwt.internal.theme.ThemeableWidgetHolder;
import org.eclipse.rwt.internal.theme.css.CssElementHolder;
import org.eclipse.rwt.internal.theme.css.CssFileReader;
import org.eclipse.rwt.internal.util.ParamCheck;
import org.eclipse.rwt.resources.IResourceManager;

public final class ThemeManager {
    public static final String DEFAULT_THEME_ID = "org.eclipse.rap.rwt.theme.Default";
    private static final String DEFAULT_THEME_NAME = "RAP Default Theme";
    public static ResourceLoader STANDARD_RESOURCE_LOADER = new ResourceLoader(){
        ClassLoader classLoader = this.getClass().getClassLoader();

        public InputStream getResourceAsStream(String resourceName) throws IOException {
            return this.classLoader.getResourceAsStream(resourceName);
        }
    };
    private static final String CHARSET = "UTF-8";
    private static final String LOG_SYSTEM_PROPERTY;
    private static final boolean DEBUG;
    private static final String CLIENT_LIBRARY_VARIANT = "org.eclipse.rwt.clientLibraryVariant";
    private static final String DEBUG_CLIENT_LIBRARY_VARIANT = "DEBUG";
    private static final String WIDGET_THEME_PATH = "resource/widget/rap";
    static final String IMAGE_DEST_PATH = "themes/images";
    private static final String CURSOR_DEST_PATH = "themes/cursors";
    private static final Class[] THEMEABLE_WIDGETS;
    private final Set customAppearances;
    private final Map themes;
    private final Set registeredThemeFiles;
    private boolean initialized = false;
    private boolean widgetsInitialized = false;
    private Theme defaultTheme;
    private ThemeableWidgetHolder themeableWidgets = new ThemeableWidgetHolder();
    private final CssElementHolder registeredCssElements;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;
    static /* synthetic */ Class class$17;
    static /* synthetic */ Class class$18;
    static /* synthetic */ Class class$19;
    static /* synthetic */ Class class$20;
    static /* synthetic */ Class class$21;
    static /* synthetic */ Class class$22;
    static /* synthetic */ Class class$23;
    static /* synthetic */ Class class$24;
    static /* synthetic */ Class class$25;
    static /* synthetic */ Class class$26;
    static /* synthetic */ Class class$27;
    static /* synthetic */ Class class$28;
    static /* synthetic */ Class class$29;
    static /* synthetic */ Class class$30;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.internal.theme.ThemeManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_SYSTEM_PROPERTY = System.getProperty(String.valueOf(clazz.getName()) + ".log");
        DEBUG = "true".equals(LOG_SYSTEM_PROPERTY);
        Class[] classArray = new Class[30];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz2;
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.swt.widgets.Control");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz3;
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.swt.widgets.Composite");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[2] = clazz4;
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("org.eclipse.swt.widgets.Button");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[3] = clazz5;
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("org.eclipse.swt.widgets.Combo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[4] = clazz6;
        Class<?> clazz7 = class$6;
        if (clazz7 == null) {
            try {
                clazz7 = class$6 = Class.forName("org.eclipse.swt.widgets.CoolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[5] = clazz7;
        Class<?> clazz8 = class$7;
        if (clazz8 == null) {
            try {
                clazz8 = class$7 = Class.forName("org.eclipse.swt.custom.CTabFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[6] = clazz8;
        Class<?> clazz9 = class$8;
        if (clazz9 == null) {
            try {
                clazz9 = class$8 = Class.forName("org.eclipse.swt.widgets.Group");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[7] = clazz9;
        Class<?> clazz10 = class$9;
        if (clazz10 == null) {
            try {
                clazz10 = class$9 = Class.forName("org.eclipse.swt.widgets.Label");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[8] = clazz10;
        Class<?> clazz11 = class$10;
        if (clazz11 == null) {
            try {
                clazz11 = class$10 = Class.forName("org.eclipse.swt.widgets.Link");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[9] = clazz11;
        Class<?> clazz12 = class$11;
        if (clazz12 == null) {
            try {
                clazz12 = class$11 = Class.forName("org.eclipse.swt.widgets.List");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[10] = clazz12;
        Class<?> clazz13 = class$12;
        if (clazz13 == null) {
            try {
                clazz13 = class$12 = Class.forName("org.eclipse.swt.widgets.Menu");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[11] = clazz13;
        Class<?> clazz14 = class$13;
        if (clazz14 == null) {
            try {
                clazz14 = class$13 = Class.forName("org.eclipse.swt.widgets.ProgressBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[12] = clazz14;
        Class<?> clazz15 = class$14;
        if (clazz15 == null) {
            try {
                clazz15 = class$14 = Class.forName("org.eclipse.swt.widgets.Shell");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[13] = clazz15;
        Class<?> clazz16 = class$15;
        if (clazz16 == null) {
            try {
                clazz16 = class$15 = Class.forName("org.eclipse.swt.widgets.Spinner");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[14] = clazz16;
        Class<?> clazz17 = class$16;
        if (clazz17 == null) {
            try {
                clazz17 = class$16 = Class.forName("org.eclipse.swt.widgets.TabFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[15] = clazz17;
        Class<?> clazz18 = class$17;
        if (clazz18 == null) {
            try {
                clazz18 = class$17 = Class.forName("org.eclipse.swt.widgets.Table");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[16] = clazz18;
        Class<?> clazz19 = class$18;
        if (clazz19 == null) {
            try {
                clazz19 = class$18 = Class.forName("org.eclipse.swt.widgets.Text");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[17] = clazz19;
        Class<?> clazz20 = class$19;
        if (clazz20 == null) {
            try {
                clazz20 = class$19 = Class.forName("org.eclipse.swt.widgets.ToolBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[18] = clazz20;
        Class<?> clazz21 = class$20;
        if (clazz21 == null) {
            try {
                clazz21 = class$20 = Class.forName("org.eclipse.swt.widgets.Tree");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[19] = clazz21;
        Class<?> clazz22 = class$21;
        if (clazz22 == null) {
            try {
                clazz22 = class$21 = Class.forName("org.eclipse.swt.widgets.Scale");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[20] = clazz22;
        Class<?> clazz23 = class$22;
        if (clazz23 == null) {
            try {
                clazz23 = class$22 = Class.forName("org.eclipse.swt.widgets.DateTime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[21] = clazz23;
        Class<?> clazz24 = class$23;
        if (clazz24 == null) {
            try {
                clazz24 = class$23 = Class.forName("org.eclipse.swt.widgets.ExpandBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[22] = clazz24;
        Class<?> clazz25 = class$24;
        if (clazz25 == null) {
            try {
                clazz25 = class$24 = Class.forName("org.eclipse.swt.widgets.Sash");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[23] = clazz25;
        Class<?> clazz26 = class$25;
        if (clazz26 == null) {
            try {
                clazz26 = class$25 = Class.forName("org.eclipse.swt.widgets.Slider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[24] = clazz26;
        Class<?> clazz27 = class$26;
        if (clazz27 == null) {
            try {
                clazz27 = class$26 = Class.forName("org.eclipse.swt.widgets.ToolTip");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[25] = clazz27;
        Class<?> clazz28 = class$27;
        if (clazz28 == null) {
            try {
                clazz28 = class$27 = Class.forName("org.eclipse.swt.custom.CCombo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[26] = clazz28;
        Class<?> clazz29 = class$28;
        if (clazz29 == null) {
            try {
                clazz29 = class$28 = Class.forName("org.eclipse.swt.custom.CLabel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[27] = clazz29;
        Class<?> clazz30 = class$29;
        if (clazz30 == null) {
            try {
                clazz30 = class$29 = Class.forName("org.eclipse.swt.browser.Browser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[28] = clazz30;
        Class<?> clazz31 = class$30;
        if (clazz31 == null) {
            try {
                clazz31 = class$30 = Class.forName("org.eclipse.swt.widgets.ScrollBar");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[29] = clazz31;
        THEMEABLE_WIDGETS = classArray;
    }

    ThemeManager() {
        this.customAppearances = new HashSet();
        this.registeredThemeFiles = new HashSet();
        this.registeredCssElements = new CssElementHolder();
        this.defaultTheme = new Theme(DEFAULT_THEME_ID, DEFAULT_THEME_NAME, null);
        this.themes = new HashMap();
        this.themes.put(DEFAULT_THEME_ID, this.defaultTheme);
    }

    public static ThemeManager getInstance() {
        return RWTFactory.getThemeManager().getInstance();
    }

    public static void resetInstance() {
        RWTFactory.getThemeManager().resetInstance();
    }

    public void initialize() {
        if (!this.initialized) {
            this.initializeThemeableWidgets();
            Collection allThemes = this.themes.values();
            Iterator iterator = allThemes.iterator();
            ThemeableWidget[] allThemeableWidgets = this.themeableWidgets.getAll();
            while (iterator.hasNext()) {
                Theme theme = (Theme)iterator.next();
                theme.initialize(allThemeableWidgets);
            }
            this.initialized = true;
        }
    }

    public void initializeThemeableWidgets() {
        if (!this.widgetsInitialized) {
            this.addDefaultThemableWidgets();
            ThemeableWidget[] widgets = this.themeableWidgets.getAll();
            int i = 0;
            while (i < widgets.length) {
                this.processThemeableWidget(widgets[i]);
                ++i;
            }
            this.widgetsInitialized = true;
        }
    }

    public void addThemeableWidget(Class widget, ResourceLoader loader) {
        this.checkNotInitialized();
        ParamCheck.notNull(widget, "widget");
        ParamCheck.notNull(loader, "loader");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.widgets.Widget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!clazz.isAssignableFrom(widget)) {
            String message = "Themeable widget is not a subtype of Widget: " + widget.getName();
            throw new IllegalArgumentException(message);
        }
        this.themeableWidgets.add(new ThemeableWidget(widget, loader));
    }

    public void registerTheme(Theme theme) {
        this.checkNotInitialized();
        String id = theme.getId();
        if (this.themes.containsKey(id)) {
            String pattern = "Theme with id ''{0}'' exists already";
            Object[] arguments = new Object[]{id};
            String msg = MessageFormat.format(pattern, arguments);
            throw new IllegalArgumentException(msg);
        }
        this.themes.put(id, theme);
    }

    public boolean hasTheme(String themeId) {
        return this.themes.containsKey(themeId);
    }

    public Theme getTheme(String themeId) {
        Theme result = null;
        if (this.themes.containsKey(themeId)) {
            result = (Theme)this.themes.get(themeId);
        }
        return result;
    }

    public String[] getRegisteredThemeIds() {
        String[] result = new String[this.themes.size()];
        return this.themes.keySet().toArray(result);
    }

    public void registerResources() {
        this.checkInitialized();
        Iterator iterator = this.themes.keySet().iterator();
        this.registerThemeFiles(this.defaultTheme);
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Theme theme = (Theme)this.themes.get(key);
            if (theme == this.defaultTheme) continue;
            this.registerThemeFiles(theme);
        }
    }

    ThemeableWidget getThemeableWidget(Class widget) {
        return this.themeableWidgets.get(widget);
    }

    private void checkNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("ThemeManager is already initialized");
        }
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("ThemeManager not initialized");
        }
    }

    private void addDefaultThemableWidgets() {
        int i = 0;
        while (i < THEMEABLE_WIDGETS.length) {
            this.addThemeableWidget(THEMEABLE_WIDGETS[i], STANDARD_RESOURCE_LOADER);
            ++i;
        }
    }

    private void processThemeableWidget(ThemeableWidget themeWidget) {
        String className = LifeCycleAdapterUtil.getSimpleClassName(themeWidget.widget);
        String[] variants = LifeCycleAdapterUtil.getKitPackageVariants(themeWidget.widget);
        boolean found = false;
        try {
            int i = 0;
            while (i < variants.length && !found) {
                found |= this.loadThemeDef(themeWidget, variants[i], className);
                found |= this.loadAppearanceJs(themeWidget, variants[i], className);
                found |= this.loadDefaultCss(themeWidget, variants[i], className);
                ++i;
            }
            if (themeWidget.elements == null) {
                ThemeManager.log("WARNING: No elements defined for themeable widget: " + themeWidget.widget.getName());
            }
            if (themeWidget.defaultStyleSheet != null) {
                this.defaultTheme.addStyleSheet(themeWidget.defaultStyleSheet);
            }
        }
        catch (IOException e) {
            String msg = "Failed to initialize themeable widget: " + themeWidget.widget.getName();
            throw new ThemeManagerException(msg, e);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadThemeDef(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".theme.xml";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found theme definition file: " + fileName);
        result = true;
        try {
            try {
                ThemeDefinitionReader reader = new ThemeDefinitionReader(inStream, fileName);
                reader.read();
                themeWidget.elements = reader.getThemeCssElements();
                int i = 0;
                while (i < themeWidget.elements.length) {
                    this.registeredCssElements.addElement(themeWidget.elements[i]);
                    ++i;
                }
            }
            catch (Exception e) {
                String message = "Failed to parse theme definition file " + fileName;
                throw new ThemeManagerException(message, e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        inStream.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadAppearanceJs(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".appearances.js";
        InputStream inStream = themeWidget.loader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found appearance js file: " + fileName);
        try {
            String content = AppearancesUtil.readAppearanceFile(inStream);
            this.customAppearances.add(content);
            result = true;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        inStream.close();
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean loadDefaultCss(ThemeableWidget themeWidget, String pkgName, String className) throws IOException {
        boolean result = false;
        ResourceLoader resLoader = themeWidget.loader;
        String resPkgName = pkgName.replace('.', '/');
        String fileName = String.valueOf(resPkgName) + "/" + className + ".default.css";
        InputStream inStream = resLoader.getResourceAsStream(fileName);
        if (inStream == null) return result;
        ThemeManager.log("Found default css file: " + fileName);
        try {
            themeWidget.defaultStyleSheet = CssFileReader.readStyleSheet(inStream, fileName, resLoader);
            result = true;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            inStream.close();
            throw throwable;
        }
        {
            Object var9_11 = null;
        }
        inStream.close();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerThemeFiles(Theme theme) {
        boolean compress = !ThemeManager.isDebugVariant();
        Set set = this.registeredThemeFiles;
        synchronized (set) {
            String themeId = theme.getId();
            if (!this.registeredThemeFiles.contains(themeId)) {
                String jsId = theme.getJsId();
                this.registerThemeableWidgetImages(theme);
                this.registerThemeableWidgetCursors(theme);
                StringBuffer sb = new StringBuffer();
                sb.append(this.createQxThemes(theme));
                IThemeCssElement[] elements = this.registeredCssElements.getAllElements();
                ThemeStoreWriter storeWriter = new ThemeStoreWriter(elements);
                storeWriter.addTheme(theme, theme == this.defaultTheme);
                sb.append(storeWriter.createJs());
                String themeCode = sb.toString();
                ThemeManager.log("-- REGISTERED THEME CODE FOR " + themeId + " ( " + themeCode.length() + " )--");
                ThemeManager.log(themeCode);
                ThemeManager.log("-- END REGISTERED THEME CODE --");
                String name = String.valueOf(jsId.replace('.', '/')) + ".js";
                ThemeManager.registerJsLibrary(name, themeCode, compress);
                this.registeredThemeFiles.add(themeId);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerThemeableWidgetImages(Theme theme) {
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            QxType value = values[i];
            if (value instanceof QxImage) {
                QxImage image = (QxImage)value;
                if (!image.none) {
                    Object var11_12;
                    InputStream inputStream;
                    try {
                        inputStream = image.loader.getResourceAsStream(image.path);
                    }
                    catch (IOException e) {
                        String message = "Failed to load resource " + image.path;
                        throw new ThemeManagerException(message, e);
                    }
                    if (inputStream == null) {
                        String pattern = "Resource ''{0}'' not found for theme ''{1}''";
                        Object[] arguments = new Object[]{image.path, theme.getName()};
                        String mesg = MessageFormat.format(pattern, arguments);
                        throw new IllegalArgumentException(mesg);
                    }
                    try {
                        ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
                        ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                        String key = adapter.getKey(value);
                        String registerPath = "themes/images/" + key;
                        RWT.getResourceManager().register(registerPath, inputStream);
                    }
                    catch (Throwable throwable) {
                        var11_12 = null;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    {
                        var11_12 = null;
                    }
                    try {}
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    inputStream.close();
                }
            }
            ++i;
        }
        return;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void registerThemeableWidgetCursors(Theme theme) {
        QxType[] values = theme.getValuesMap().getAllValues();
        int i = 0;
        while (i < values.length) {
            QxCursor cursor;
            QxType value = values[i];
            if (value instanceof QxCursor && (cursor = (QxCursor)value).isCustomCursor()) {
                Object var14_15;
                InputStream inputStream;
                ThemePropertyAdapterRegistry registry = ThemePropertyAdapterRegistry.getInstance();
                ThemePropertyAdapterRegistry.ThemePropertyAdapter adapter = registry.getPropertyAdapter(value.getClass());
                String key = adapter.getKey(value);
                String path = cursor.value;
                ThemeManager.log(" register theme cursor " + key + ", path=" + path);
                try {
                    inputStream = cursor.loader.getResourceAsStream(path);
                }
                catch (IOException e) {
                    String message = "Failed to load resource " + path;
                    throw new ThemeManagerException(message, e);
                }
                if (inputStream == null) {
                    String pattern = "Resource ''{0}'' not found for theme ''{1}''";
                    Object[] arguments = new Object[]{path, theme.getName()};
                    String mesg = MessageFormat.format(pattern, arguments);
                    throw new IllegalArgumentException(mesg);
                }
                try {
                    String widgetDestPath = CURSOR_DEST_PATH;
                    String registerPath = String.valueOf(widgetDestPath) + "/" + key;
                    RWT.getResourceManager().register(registerPath, inputStream);
                    String location = RWT.getResourceManager().getLocation(registerPath);
                    ThemeManager.log(" theme cursor registered @ " + location);
                }
                catch (Throwable throwable) {
                    var14_15 = null;
                    try {
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                {
                    var14_15 = null;
                }
                try {}
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                inputStream.close();
            }
            ++i;
        }
        return;
    }

    private static void registerJsLibrary(String name, String code, boolean compress) {
        IResourceManager.RegisterOptions option;
        IResourceManager resourceManager = RWT.getResourceManager();
        IResourceManager.RegisterOptions registerOptions = option = compress ? IResourceManager.RegisterOptions.VERSION_AND_COMPRESS : IResourceManager.RegisterOptions.VERSION;
        if (code != null) {
            byte[] buffer;
            try {
                buffer = code.getBytes(CHARSET);
            }
            catch (UnsupportedEncodingException shouldNotHappen) {
                throw new RuntimeException(shouldNotHappen);
            }
            ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
            resourceManager.register(name, inputStream, CHARSET, option);
        } else {
            resourceManager.register(name, CHARSET, option);
        }
        ResourceUtil.useJsLibrary(name);
    }

    private String createQxThemes(Theme theme) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.createQxTheme(theme, 2));
        buffer.append(this.createQxTheme(theme, 3));
        buffer.append(this.createQxTheme(theme, 4));
        buffer.append(this.createQxTheme(theme, 1));
        return buffer.toString();
    }

    private String createQxTheme(Theme theme, int type) {
        String jsId = theme.getJsId();
        String base = null;
        if (type == 4) {
            base = "org.eclipse.swt.theme.AppearancesBase";
        }
        QxTheme qxTheme = new QxTheme(jsId, theme.getName(), type, base);
        if (type == 3 || type == 2) {
            String uri = "rwt-resources/resource/widget/rap";
            qxTheme.appendUri(uri);
        } else if (type == 4) {
            Iterator iterator = this.customAppearances.iterator();
            while (iterator.hasNext()) {
                String appearance = (String)iterator.next();
                qxTheme.appendValues(appearance);
            }
        } else if (type == 1) {
            qxTheme.appendTheme("icon", String.valueOf(jsId) + "Icons");
            qxTheme.appendTheme("widget", String.valueOf(jsId) + "Widgets");
            qxTheme.appendTheme("appearance", String.valueOf(jsId) + "Appearances");
        }
        return qxTheme.getJsCode();
    }

    private static boolean isDebugVariant() {
        String libraryVariant = System.getProperty(CLIENT_LIBRARY_VARIANT);
        return DEBUG_CLIENT_LIBRARY_VARIANT.equals(libraryVariant);
    }

    private static void log(String mesg) {
        if (DEBUG) {
            System.out.println(mesg);
        }
    }
}

