/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.service;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.LifeCycleServiceHandler;
import org.eclipse.rwt.internal.service.ServiceHandlerRegistry;
import org.eclipse.rwt.service.IServiceHandler;
import org.eclipse.rwt.service.IServiceManager;

public class ServiceManager
implements IServiceManager {
    private final ServiceHandlerRegistry customHandlers;
    private final IServiceHandler handlerDispatcher = new HandlerDispatcher();
    private IServiceHandler lifeCycleRequestHandler;

    public ServiceManager() {
        this.customHandlers = new ServiceHandlerRegistry();
    }

    public void registerServiceHandler(String id, IServiceHandler handler) {
        this.customHandlers.put(id, handler);
    }

    public void unregisterServiceHandler(String id) {
        this.customHandlers.remove(id);
    }

    public IServiceHandler getHandler() {
        return this.handlerDispatcher;
    }

    private static String getCustomHandlerId() {
        HttpServletRequest request = ContextProvider.getRequest();
        return request.getParameter("custom_service_handler");
    }

    private IServiceHandler getLifeCycleRequestHandler() {
        if (this.lifeCycleRequestHandler == null) {
            this.lifeCycleRequestHandler = new LifeCycleServiceHandler();
        }
        return this.lifeCycleRequestHandler;
    }

    private boolean isCustomHandler() {
        return this.customHandlers.isCustomHandler(ServiceManager.getCustomHandlerId());
    }

    private IServiceHandler getCustomHandler() {
        return this.customHandlers.get(ServiceManager.getCustomHandlerId());
    }

    private final class HandlerDispatcher
    implements IServiceHandler {
        private HandlerDispatcher() {
        }

        public void service() throws ServletException, IOException {
            if (ServiceManager.this.isCustomHandler()) {
                IServiceHandler customHandler = ServiceManager.this.getCustomHandler();
                customHandler.service();
            } else {
                ServiceManager.this.getLifeCycleRequestHandler().service();
            }
        }
    }
}

