/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.service.IServiceStateInfo;
import org.eclipse.rwt.internal.util.ClassUtil;
import org.eclipse.rwt.service.ISessionStore;

public abstract class SessionSingletonBase {
    public static final String LOCK;
    private static final String PREFIX = "com_w4t_session_singleton_";
    private static final String LOCK_POSTFIX = "#typeLock";
    private static final Map instanceKeyMap;
    private static final Map lockKeyMap;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rwt.SessionSingletonBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOCK = String.valueOf(clazz.getName()) + ".Lock";
        instanceKeyMap = new Hashtable();
        lockKeyMap = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getInstance(Class type) {
        IServiceStateInfo stateInfo = ContextProvider.getStateInfo();
        Object result = null;
        if (stateInfo != null) {
            result = stateInfo.getAttribute(SessionSingletonBase.getInstanceKey(type));
        }
        if (result == null) {
            Object object = SessionSingletonBase.getInstanceLock(type);
            synchronized (object) {
                result = SessionSingletonBase.getInstanceInternal(type);
            }
            if (stateInfo != null) {
                stateInfo.setAttribute(SessionSingletonBase.getInstanceKey(type), result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getInstanceLock(Class type) {
        Object result;
        ISessionStore session = ContextProvider.getSession();
        Object object = session.getAttribute(LOCK);
        synchronized (object) {
            result = session.getAttribute(SessionSingletonBase.getLockKey(type));
            if (result == null) {
                result = new Object();
                session.setAttribute(SessionSingletonBase.getLockKey(type), result);
            }
        }
        return result;
    }

    static String getInstanceKey(Class type) {
        String name = type.getName();
        String result = (String)instanceKeyMap.get(name);
        if (result == null) {
            StringBuffer key = new StringBuffer(PREFIX);
            key.append(name);
            result = key.toString();
            instanceKeyMap.put(name, result);
        }
        return result;
    }

    static String getLockKey(Class type) {
        String name = type.getName();
        String result = (String)lockKeyMap.get(name);
        if (result == null) {
            StringBuffer key = new StringBuffer(PREFIX);
            key.append(name);
            key.append(LOCK_POSTFIX);
            result = key.toString();
            lockKeyMap.put(name, result);
        }
        return result;
    }

    private static Object getInstanceInternal(Class type) {
        Object result = SessionSingletonBase.getAttribute(SessionSingletonBase.getInstanceKey(type));
        if (result == null) {
            result = ClassUtil.newInstance(type);
            SessionSingletonBase.setAttribute(SessionSingletonBase.getInstanceKey(type), result);
        }
        return result;
    }

    private static Object getAttribute(String name) {
        return ContextProvider.getSession().getAttribute(name);
    }

    private static void setAttribute(String name, Object object) {
        ContextProvider.getSession().setAttribute(name, object);
    }
}

