/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.widgets.spinnerkit;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import org.eclipse.rwt.Adaptable;
import org.eclipse.rwt.RWT;
import org.eclipse.rwt.internal.util.NumberFormatUtil;
import org.eclipse.rwt.lifecycle.AbstractWidgetLCA;
import org.eclipse.rwt.lifecycle.ControlLCAUtil;
import org.eclipse.rwt.lifecycle.IWidgetAdapter;
import org.eclipse.rwt.lifecycle.JSWriter;
import org.eclipse.rwt.lifecycle.WidgetLCAUtil;
import org.eclipse.rwt.lifecycle.WidgetUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public final class SpinnerLCA
extends AbstractWidgetLCA {
    private static final String QX_TYPE = "org.eclipse.swt.widgets.Spinner";
    static final String PROP_SELECTION = "selection";
    static final String PROP_MAXIMUM = "maximum";
    static final String PROP_MINIMUM = "minimum";
    static final String PROP_DIGITS = "digits";
    static final String PROP_INCREMENT = "increment";
    static final String PROP_PAGE_INCREMENT = "pageIncrement";
    static final String PROP_MODIFY_LISTENER = "modifyListener";
    static final String PROP_SELECTION_LISTENER = "selectionListener";
    static final String PROP_TEXT_LIMIT = "textLimit";
    static final String PROP_DECIMAL_SEPARATOR = "decimalSeparator";
    private static final Integer DEFAULT_SELECTION = new Integer(0);
    private static final Integer DEFAULT_MAXIMUM = new Integer(100);
    private static final Integer DEFAULT_MINIMUM = new Integer(0);
    private static final Integer DEFAULT_DIGITS = new Integer(0);
    private static final Integer DEFAULT_PAGE_INCREMENT = new Integer(10);
    private static final Integer DEFAULT_INCREMENT = new Integer(1);
    private static final Integer DEFAULT_TEXT_LIMIT = new Integer(Integer.MAX_VALUE);
    private static final String DEFAULT_DECIMAL_SEPARATOR = ".";

    public void preserveValues(Widget widget) {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.preserveValues((Control)spinner);
        IWidgetAdapter adapter = WidgetUtil.getAdapter((Widget)widget);
        adapter.preserve(PROP_SELECTION, (Object)new Integer(spinner.getSelection()));
        adapter.preserve(PROP_MINIMUM, (Object)new Integer(spinner.getMinimum()));
        adapter.preserve(PROP_MAXIMUM, (Object)new Integer(spinner.getMaximum()));
        adapter.preserve(PROP_DIGITS, (Object)new Integer(spinner.getDigits()));
        adapter.preserve(PROP_INCREMENT, (Object)new Integer(spinner.getIncrement()));
        adapter.preserve(PROP_PAGE_INCREMENT, (Object)new Integer(spinner.getPageIncrement()));
        adapter.preserve(PROP_MODIFY_LISTENER, (Object)ModifyEvent.hasListener((Adaptable)spinner));
        adapter.preserve(PROP_SELECTION_LISTENER, (Object)SelectionEvent.hasListener((Adaptable)spinner));
        adapter.preserve(PROP_TEXT_LIMIT, (Object)new Integer(spinner.getTextLimit()));
        adapter.preserve(PROP_DECIMAL_SEPARATOR, (Object)SpinnerLCA.getDecimalSeparator());
        WidgetLCAUtil.preserveCustomVariant((Widget)spinner);
    }

    public void readData(Widget widget) {
        Spinner spinner = (Spinner)widget;
        String value = WidgetLCAUtil.readPropertyValue(widget, PROP_SELECTION);
        if (value != null) {
            spinner.setSelection(NumberFormatUtil.parseInt((String)value));
        }
        ControlLCAUtil.processSelection(widget, null, false);
        ControlLCAUtil.processMouseEvents((Control)spinner);
        ControlLCAUtil.processKeyEvents((Control)spinner);
        ControlLCAUtil.processMenuDetect((Control)spinner);
        WidgetLCAUtil.processHelp((Widget)spinner);
    }

    public void renderInitialization(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        writer.newWidget(QX_TYPE);
        ControlLCAUtil.writeStyleFlags((Control)spinner);
        SpinnerLCA.writeReadOnly(spinner);
        SpinnerLCA.writeWrap(spinner);
    }

    public void renderChanges(Widget widget) throws IOException {
        Spinner spinner = (Spinner)widget;
        ControlLCAUtil.writeChanges((Control)spinner);
        SpinnerLCA.writeMinMaxSelection(spinner);
        SpinnerLCA.writeValues(spinner);
        SpinnerLCA.writeTextLimit(spinner);
        SpinnerLCA.writeModifyListener(spinner);
        SpinnerLCA.writeSelectionListener(spinner);
        SpinnerLCA.writeDecimalSeparator(spinner);
        WidgetLCAUtil.writeCustomVariant((Widget)spinner);
    }

    public void renderDispose(Widget widget) throws IOException {
        JSWriter writer = JSWriter.getWriterFor(widget);
        writer.dispose();
    }

    private static void writeValues(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        writer.set(PROP_DIGITS, PROP_DIGITS, new Integer(spinner.getDigits()), DEFAULT_DIGITS);
        writer.set(PROP_INCREMENT, "incrementAmount", new Integer(spinner.getIncrement()), DEFAULT_INCREMENT);
        writer.set(PROP_INCREMENT, "wheelIncrementAmount", new Integer(spinner.getIncrement()), DEFAULT_INCREMENT);
        writer.set(PROP_PAGE_INCREMENT, "pageIncrementAmount", new Integer(spinner.getPageIncrement()), DEFAULT_PAGE_INCREMENT);
    }

    private static void writeMinMaxSelection(Spinner spinner) throws IOException {
        Integer newMin = new Integer(spinner.getMinimum());
        Integer newMax = new Integer(spinner.getMaximum());
        Integer newSel = new Integer(spinner.getSelection());
        boolean minChanged = WidgetLCAUtil.hasChanged((Widget)spinner, PROP_MINIMUM, newMin, DEFAULT_MINIMUM);
        boolean maxChanged = WidgetLCAUtil.hasChanged((Widget)spinner, PROP_MAXIMUM, newMax, DEFAULT_MAXIMUM);
        boolean selChanged = WidgetLCAUtil.hasChanged((Widget)spinner, PROP_SELECTION, newSel, DEFAULT_SELECTION);
        if (minChanged || maxChanged || selChanged) {
            JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
            Object[] args = new Integer[]{newMin, newMax, newSel};
            writer.call("setMinMaxSelection", args);
        }
    }

    private static void writeTextLimit(Spinner spinner) throws IOException {
        Integer defValue;
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_TEXT_LIMIT;
        Integer newValue = new Integer(spinner.getTextLimit());
        if (WidgetLCAUtil.hasChanged((Widget)spinner, prop, newValue, defValue = DEFAULT_TEXT_LIMIT)) {
            if (newValue < 0) {
                newValue = null;
            }
            writer.set("maxLength", newValue);
        }
    }

    private static void writeReadOnly(Spinner spinner) throws IOException {
        boolean readOnly = (spinner.getStyle() & 8) != 0;
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        writer.set("editable", !readOnly);
    }

    private static void writeWrap(Spinner spinner) throws IOException {
        if ((spinner.getStyle() & 0x40) != 0) {
            JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
            writer.set("wrap", true);
        }
    }

    private static void writeModifyListener(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_MODIFY_LISTENER;
        Boolean newValue = ModifyEvent.hasListener((Adaptable)spinner);
        Boolean defValue = Boolean.FALSE;
        writer.set(prop, "hasModifyListener", newValue, defValue);
    }

    private static void writeSelectionListener(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_SELECTION_LISTENER;
        Boolean newValue = SelectionEvent.hasListener((Adaptable)spinner);
        Boolean defValue = Boolean.FALSE;
        writer.set(prop, "hasSelectionListener", newValue, defValue);
    }

    private static void writeDecimalSeparator(Spinner spinner) throws IOException {
        JSWriter writer = JSWriter.getWriterFor((Widget)spinner);
        String prop = PROP_DECIMAL_SEPARATOR;
        String newValue = SpinnerLCA.getDecimalSeparator();
        String defValue = DEFAULT_DECIMAL_SEPARATOR;
        writer.set(prop, PROP_DECIMAL_SEPARATOR, newValue, defValue);
    }

    private static String getDecimalSeparator() {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(RWT.getLocale());
        return String.valueOf(symbols.getDecimalSeparator());
    }
}

