/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AsOfClause
extends AbstractExpression {
    private AbstractExpression expression;
    private boolean hasSpaceAfterCategory;
    private boolean hasSpaceAfterIdentifier;
    private String identifier;
    private String scnIdentifier;
    private String timestampIdentifier;

    public AsOfClause(AbstractExpression parent) {
        super(parent, "AS OF");
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        this.acceptUnknownVisitor(visitor);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getExpression().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getExpression());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression("AS OF"));
        if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.scnIdentifier != null) {
            children.add(this.buildStringExpression("SCN"));
        } else if (this.timestampIdentifier != null) {
            children.add(this.buildStringExpression("TIMESTAMP"));
        }
        if (this.hasSpaceAfterCategory) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.expression != null) {
            children.add(this.expression);
        }
    }

    @Override
    public JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.expression != null && this.expression.isAncestor(expression)) {
            return this.getQueryBNF("scalar_expression");
        }
        return super.findQueryBNF(expression);
    }

    public String getActualIdentifier() {
        return this.identifier;
    }

    public String getActualScnIdentifier() {
        return this.scnIdentifier != null ? this.scnIdentifier : "";
    }

    public String getActualTimestampIdentifier() {
        return this.timestampIdentifier != null ? this.timestampIdentifier : "";
    }

    public Expression getExpression() {
        if (this.expression == null) {
            this.expression = this.buildNullExpression();
        }
        return this.expression;
    }

    @Override
    public JPQLQueryBNF getQueryBNF() {
        return this.getQueryBNF("as_of_clause");
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isNull();
    }

    public boolean hasScn() {
        return this.scnIdentifier != null;
    }

    public boolean hasSpaceAfterCategory() {
        return this.hasSpaceAfterCategory;
    }

    public boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    public boolean hasTimestamp() {
        return this.timestampIdentifier != null;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward("AS OF");
        boolean bl = this.hasSpaceAfterIdentifier = wordParser.skipLeadingWhitespace() > 0;
        if (wordParser.startsWithIdentifier("SCN")) {
            this.scnIdentifier = wordParser.moveForward("SCN");
            this.hasSpaceAfterCategory = wordParser.skipLeadingWhitespace() > 0;
        } else if (wordParser.startsWithIdentifier("TIMESTAMP")) {
            this.timestampIdentifier = wordParser.moveForward("TIMESTAMP");
            this.hasSpaceAfterCategory = wordParser.skipLeadingWhitespace() > 0;
        }
        this.expression = this.parse(wordParser, "scalar_expression", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : "AS OF");
        if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        if (this.scnIdentifier != null) {
            writer.append(actual ? this.scnIdentifier : "SCN");
        }
        if (this.timestampIdentifier != null) {
            writer.append(actual ? this.timestampIdentifier : "TIMESTAMP");
        }
        if (this.hasSpaceAfterCategory) {
            writer.append(' ');
        }
        if (this.expression != null) {
            this.expression.toParsedText(writer, actual);
        }
    }
}

