/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jpa.jpql.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.persistence.jpa.jpql.WordParser;
import org.eclipse.persistence.jpa.jpql.parser.AbstractExpression;
import org.eclipse.persistence.jpa.jpql.parser.CollectionExpression;
import org.eclipse.persistence.jpa.jpql.parser.Expression;
import org.eclipse.persistence.jpa.jpql.parser.ExpressionVisitor;
import org.eclipse.persistence.jpa.jpql.parser.JPQLQueryBNF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrderByClause
extends AbstractExpression {
    private boolean hasSpaceAfterIdentifier;
    private String identifier;
    private AbstractExpression orderByItems;

    protected AbstractOrderByClause(AbstractExpression parent, String identifier) {
        super(parent, identifier);
    }

    @Override
    public void acceptChildren(ExpressionVisitor visitor) {
        this.getOrderByItems().accept(visitor);
    }

    @Override
    protected void addChildrenTo(Collection<Expression> children) {
        children.add(this.getOrderByItems());
    }

    @Override
    protected void addOrderedChildrenTo(List<Expression> children) {
        children.add(this.buildStringExpression(this.getText()));
        if (this.hasSpaceAfterIdentifier) {
            children.add(this.buildStringExpression(' '));
        }
        if (this.orderByItems != null) {
            children.add(this.orderByItems);
        }
    }

    public final CollectionExpression buildCollectionExpression() {
        ArrayList<AbstractExpression> children = new ArrayList<AbstractExpression>(1);
        children.add((AbstractExpression)this.getOrderByItems());
        ArrayList<Boolean> commas = new ArrayList<Boolean>(1);
        commas.add(Boolean.FALSE);
        ArrayList<Boolean> spaces = new ArrayList<Boolean>(1);
        spaces.add(Boolean.FALSE);
        return new CollectionExpression(this, children, spaces, commas, true);
    }

    @Override
    public final JPQLQueryBNF findQueryBNF(Expression expression) {
        if (this.orderByItems != null && this.orderByItems.isAncestor(expression)) {
            return this.getQueryBNF("orderby_item");
        }
        return super.findQueryBNF(expression);
    }

    public final String getActualIdentifier() {
        return this.identifier;
    }

    public final Expression getOrderByItems() {
        if (this.orderByItems == null) {
            this.orderByItems = this.buildNullExpression();
        }
        return this.orderByItems;
    }

    public final boolean hasOrderByItems() {
        return this.orderByItems != null && !this.orderByItems.isNull();
    }

    public final boolean hasSpaceAfterIdentifier() {
        return this.hasSpaceAfterIdentifier;
    }

    @Override
    protected void parse(WordParser wordParser, boolean tolerant) {
        this.identifier = wordParser.moveForward(this.getText());
        this.hasSpaceAfterIdentifier = wordParser.skipLeadingWhitespace() > 0;
        this.orderByItems = this.parse(wordParser, "orderby_item", tolerant);
    }

    @Override
    protected void toParsedText(StringBuilder writer, boolean actual) {
        writer.append(actual ? this.identifier : this.getText());
        if (this.hasSpaceAfterIdentifier) {
            writer.append(' ');
        }
        if (this.orderByItems != null) {
            this.orderByItems.toParsedText(writer, actual);
        }
    }
}

