/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.CascadeLockingPolicy;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteAllQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected transient Vector<DatabaseField> targetForeignKeyFields;
    protected transient Vector<DatabaseField> sourceKeyFields;
    protected transient Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys = new HashMap<DatabaseField, DatabaseField>(2);
    protected transient Map<DatabaseField, DatabaseField> sourceKeysToTargetForeignKeys = new HashMap<DatabaseField, DatabaseField>(2);

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addTargetForeignKeyField(DatabaseField targetForeignKeyField, DatabaseField sourceKeyField) {
        this.getTargetForeignKeyFields().addElement(targetForeignKeyField);
        this.getSourceKeyFields().addElement(sourceKeyField);
    }

    public void addTargetForeignKeyFieldName(String targetForeignKeyFieldName, String sourceKeyFieldName) {
        this.addTargetForeignKeyField(new DatabaseField(targetForeignKeyFieldName), new DatabaseField(sourceKeyFieldName));
    }

    protected Expression buildDefaultSelectionCriteria() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        for (DatabaseField targetForeignKey : this.getTargetForeignKeysToSourceKeys().keySet()) {
            DatabaseField sourceKey = this.getTargetForeignKeysToSourceKeys().get(targetForeignKey);
            Expression partialSelectionCriteria = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        return selectionCriteria;
    }

    public Expression buildSelectionCriteria() {
        Expression selectionCriteria = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        Enumeration<DatabaseField> sourceKeys = this.getSourceKeyFields().elements();
        Enumeration<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().elements();
        while (targetForeignKeys.hasMoreElements()) {
            DatabaseField targetForeignKey = targetForeignKeys.nextElement();
            DatabaseField sourceKey = sourceKeys.nextElement();
            Expression partialSelectionCriteria = ((Expression)builder).getField(targetForeignKey).equal(builder.getParameter(sourceKey));
            selectionCriteria = partialSelectionCriteria.and(selectionCriteria);
        }
        return selectionCriteria;
    }

    @Override
    public Object clone() {
        OneToManyMapping clone = (OneToManyMapping)super.clone();
        clone.setTargetForeignKeysToSourceKeys(new HashMap<DatabaseField, DatabaseField>(this.getTargetForeignKeysToSourceKeys()));
        return clone;
    }

    protected void deleteAll(DeleteObjectQuery query) throws DatabaseException {
        Object attribute = this.getAttributeAccessor().getAttributeValueFromObject(query.getObject());
        if (this.usesIndirection() && (attribute == null || !this.getIndirectionPolicy().objectIsInstantiated(attribute))) {
            ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), new Vector(0));
            return;
        }
        Object referenceObjects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(query.getSession().getSessionForClass(this.getReferenceClass()), query.getTranslationRow(), this.getContainerPolicy().vectorFor(referenceObjects, query.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        Object objects = this.readPrivateOwnedForObject(query);
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            query.getSession().deleteObject(cp.next(iter, query.getSession()));
        }
    }

    protected Hashtable executeBatchQuery(DatabaseQuery query, AbstractSession session, AbstractRecord row) {
        ContainerPolicy mappingCP = this.getContainerPolicy();
        ContainerPolicy queryCP = ((ReadAllQuery)query).getContainerPolicy();
        Object queryResult = null;
        queryResult = session.executeQuery(query, row);
        Hashtable batchedObjects = new Hashtable(queryCP.sizeFor(queryResult));
        Object iter = queryCP.iteratorFor(queryResult);
        while (queryCP.hasNext(iter)) {
            Object eachReferenceObject = queryCP.next(iter, session);
            CacheKey eachForeignKey = new CacheKey(this.extractForeignKeyFromReferenceObject(eachReferenceObject, session));
            Object container = batchedObjects.get(eachForeignKey);
            if (container == null) {
                container = mappingCP.containerInstance();
                batchedObjects.put(eachForeignKey, container);
            }
            mappingCP.addInto(eachReferenceObject, container, session);
        }
        return batchedObjects;
    }

    protected Vector extractForeignKeyFromReferenceObject(Object object, AbstractSession session) {
        Vector<Object> foreignKey = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (Map.Entry<DatabaseField, DatabaseField> entry : this.getTargetForeignKeysToSourceKeys().entrySet()) {
            DatabaseField targetField = entry.getKey();
            DatabaseField sourceField = entry.getValue();
            if (object == null) {
                foreignKey.addElement(null);
                continue;
            }
            Object value = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, targetField, session);
            try {
                value = session.getDatasourcePlatform().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(sourceField));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            foreignKey.addElement(value);
        }
        return foreignKey;
    }

    protected Vector extractKeyFromRow(AbstractRecord row, AbstractSession session) {
        Vector<Object> key = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        for (DatabaseField field : this.getTargetForeignKeysToSourceKeys().values()) {
            Object value = row.get(field);
            try {
                value = session.getDatasourcePlatform().convertObject(value, this.getDescriptor().getObjectBuilder().getFieldClassification(field));
            }
            catch (ConversionException e) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), e);
            }
            key.addElement(value);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord row, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable batchedObjects = null;
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            batchedObjects = this.getBatchReadObjects(query, session);
            if (batchedObjects == null) {
                batchedObjects = this.executeBatchQuery(query, session, argumentRow);
                this.setBatchReadObjects(batchedObjects, query, session);
            }
        }
        Object result = batchedObjects.get(new CacheKey(this.extractKeyFromRow(row, session)));
        if (result == null) {
            return this.getContainerPolicy().containerInstance();
        }
        return result;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getSourceKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getSourceKeysToTargetForeignKeys() {
        return this.sourceKeysToTargetForeignKeys;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> fieldNames = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration<DatabaseField> fieldsEnum = this.getTargetForeignKeyFields().elements();
        while (fieldsEnum.hasMoreElements()) {
            fieldNames.addElement(fieldsEnum.nextElement().getQualifiedName());
        }
        return fieldNames;
    }

    public Vector<DatabaseField> getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map<DatabaseField, DatabaseField> getTargetForeignKeysToSourceKeys() {
        return this.targetForeignKeysToSourceKeys;
    }

    public Map getTargetForeignKeyToSourceKeys() {
        return this.getTargetForeignKeysToSourceKeys();
    }

    @Override
    public boolean hasInverseConstraintDependency() {
        return true;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteria());
        }
        this.initializeDeleteAllQuery();
        if (this.getReferenceDescriptor() != null && this.getReferenceDescriptor().hasTablePerClassPolicy()) {
            this.getReferenceDescriptor().getTablePerClassPolicy().prepareChildrenSelectionQuery(this, session);
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteria());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        DatabaseField field;
        int index;
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (index = 0; index < this.getTargetForeignKeyFields().size(); ++index) {
            field = this.getReferenceDescriptor().buildField(this.getTargetForeignKeyFields().get(index));
            this.getTargetForeignKeyFields().set(index, field);
        }
        for (index = 0; index < this.getSourceKeyFields().size(); ++index) {
            field = this.getDescriptor().buildField(this.getSourceKeyFields().get(index));
            this.getSourceKeyFields().set(index, field);
        }
        Iterator<DatabaseField> targetForeignKeys = this.getTargetForeignKeyFields().iterator();
        Iterator<DatabaseField> sourceKeys = this.getSourceKeyFields().iterator();
        while (targetForeignKeys.hasNext()) {
            DatabaseField targetForeignKey = targetForeignKeys.next();
            DatabaseField sourcePrimaryKey = sourceKeys.next();
            this.getTargetForeignKeysToSourceKeys().put(targetForeignKey, sourcePrimaryKey);
            this.getSourceKeysToTargetForeignKeys().put(sourcePrimaryKey, targetForeignKey);
        }
    }

    @Override
    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object object = cp.next(iter, query.getSession());
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
                continue;
            }
            if (query.getSession().getCommitManager().isCommitInPreModify(object)) continue;
            WriteObjectQuery writeQuery = new WriteObjectQuery();
            writeQuery.setIsExecutionClone(true);
            writeQuery.setObject(object);
            writeQuery.setCascadePolicy(query.getCascadePolicy());
            query.getSession().executeQuery(writeQuery);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        Object objectsInMemory = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        Object objectsInDB = this.readPrivateOwnedForObject(query);
        this.compareObjectsAndWrite(objectsInDB, objectsInMemory, query);
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object iter = cp.iteratorFor(objects);
            while (cp.hasNext(iter)) {
                DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                deleteQuery.setIsExecutionClone(true);
                deleteQuery.setObject(cp.next(iter, query.getSession()));
                deleteQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(deleteQuery);
            }
            if (!query.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(query);
            }
        } else {
            this.deleteAll(query);
        }
    }

    @Override
    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy policy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        policy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        this.getReferenceDescriptor().addCascadeLockingPolicy(policy);
    }

    @Override
    public void setDeleteAllSQLString(String sqlString) {
        DeleteAllQuery query = new DeleteAllQuery();
        query.setSQLString(sqlString);
        this.setCustomDeleteAllQuery(query);
    }

    public void setSourceKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setSourceKeyFields(fields);
    }

    public void setSourceKeyFields(Vector<DatabaseField> sourceKeyFields) {
        this.sourceKeyFields = sourceKeyFields;
    }

    public void setTargetForeignKeyFieldName(String targetForeignKeyFieldName) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(targetForeignKeyFieldName));
    }

    public void setTargetForeignKeyFieldNames(String[] targetForeignKeyFieldNames, String[] sourceKeyFieldNames) {
        if (targetForeignKeyFieldNames.length != sourceKeyFieldNames.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < targetForeignKeyFieldNames.length; ++i) {
            this.addTargetForeignKeyFieldName(targetForeignKeyFieldNames[i], sourceKeyFieldNames[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector fieldNames) {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance(fieldNames.size());
        Enumeration fieldNamesEnum = fieldNames.elements();
        while (fieldNamesEnum.hasMoreElements()) {
            ((Vector)fields).addElement(new DatabaseField((String)fieldNamesEnum.nextElement()));
        }
        this.setTargetForeignKeyFields(fields);
    }

    public void setTargetForeignKeyFields(Vector<DatabaseField> targetForeignKeyFields) {
        this.targetForeignKeyFields = targetForeignKeyFields;
    }

    protected void setTargetForeignKeysToSourceKeys(Map<DatabaseField, DatabaseField> targetForeignKeysToSourceKeys) {
        this.targetForeignKeysToSourceKeys = targetForeignKeysToSourceKeys;
    }

    @Override
    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery query) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return query.shouldCascadeAllParts();
    }

    @Override
    public boolean isCascadedLockingSupported() {
        return true;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean verifyDelete(Object object, AbstractSession session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object objects = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object iter = containerPolicy.iteratorFor(objects);
            while (containerPolicy.hasNext(iter)) {
                if (session.verifyDelete(containerPolicy.next(iter, session))) continue;
                return false;
            }
        }
        return true;
    }
}

