/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.EntityManagerSetupException;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetDeclaredFields;
import org.eclipse.persistence.internal.security.PrivilegedGetMethods;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;

public class MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";

    static Field[] getFields(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Field[])AccessController.doPrivileged(new PrivilegedGetDeclaredFields(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getDeclaredFields(cls);
    }

    static Method[] getMethods(Class cls) {
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (Method[])AccessController.doPrivileged(new PrivilegedGetMethods(cls));
            }
            catch (PrivilegedActionException exception) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getMethods(cls);
    }

    static boolean havePersistenceAnnotationsDefined(AnnotatedElement[] annotatedElements) {
        for (AnnotatedElement annotatedElement : annotatedElements) {
            for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    static Object invokeMethod(String methodName, Object target) {
        Method method = null;
        try {
            method = Helper.getDeclaredMethod(target.getClass(), methodName);
        }
        catch (NoSuchMethodException e) {
            EntityManagerSetupException.methodInvocationFailed(method, target, e);
        }
        if (method != null) {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        return AccessController.doPrivileged(new PrivilegedMethodInvoker(method, target));
                    }
                    catch (PrivilegedActionException exception) {
                        Exception throwableException = exception.getException();
                        if (throwableException instanceof IllegalAccessException) {
                            throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
                        }
                        throw EntityManagerSetupException.methodInvocationFailed(method, target, throwableException);
                    }
                }
                return PrivilegedAccessHelper.invokeMethod(method, target);
            }
            catch (IllegalAccessException ex1) {
                throw EntityManagerSetupException.cannotAccessMethodOnObject(method, target);
            }
            catch (InvocationTargetException ex2) {
                throw EntityManagerSetupException.methodInvocationFailed(method, target, ex2);
            }
        }
        return null;
    }
}

