/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.testing.tests.unitofwork;

import java.util.Vector;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.UnitOfWork;
import org.eclipse.persistence.testing.framework.AutoVerifyTestCase;
import org.eclipse.persistence.testing.framework.TestErrorException;
import org.eclipse.persistence.testing.models.employee.domain.Employee;
import org.eclipse.persistence.testing.models.employee.domain.PhoneNumber;
import org.eclipse.persistence.testing.tests.unitofwork.Contact;
import org.eclipse.persistence.testing.tests.unitofwork.MailAddress;

public class UnitOfWorkConformExceptionTest
extends AutoVerifyTestCase {
    protected Employee bob;
    protected UnitOfWork uow;
    boolean pass;
    ReadObjectQuery phoneNumberQuery;
    ReadAllQuery phoneNumbersQuery;
    ReadAllQuery contactsQuery;

    public UnitOfWorkConformExceptionTest() {
        this.setDescription("Test that exceptions are thrown when attempts to conform query results in a unit of work fail.");
    }

    public void setup() {
        this.getAbstractSession().beginTransaction();
        this.phoneNumberQuery = new ReadObjectQuery();
        this.phoneNumbersQuery = new ReadAllQuery();
        this.phoneNumberQuery.setReferenceClass(PhoneNumber.class);
        this.phoneNumbersQuery.setReferenceClass(PhoneNumber.class);
        Expression exp = new ExpressionBuilder().get("owner").get("firstName").equal((Object)"Bob");
        this.phoneNumberQuery.setSelectionCriteria(exp);
        this.phoneNumbersQuery.setSelectionCriteria(exp);
        this.phoneNumberQuery.conformResultsInUnitOfWork();
        this.phoneNumbersQuery.conformResultsInUnitOfWork();
        this.contactsQuery = new ReadAllQuery();
        this.contactsQuery.setReferenceClass(Contact.class);
        exp = new ExpressionBuilder().get("mailAddress").get("mailAddress").like("t%");
        this.contactsQuery.setSelectionCriteria(exp);
        this.contactsQuery.conformResultsInUnitOfWork();
    }

    public void reset() {
        this.getAbstractSession().rollbackTransaction();
        this.getSession().getIdentityMapAccessor().initializeAllIdentityMaps();
    }

    public void test() {
        this.testThrowNoConformException();
        this.testThrowConformExceptionWithIndirection();
        this.testThrowConformExceptionInAllCases();
    }

    protected void setupTrial(int value) {
        this.pass = false;
        this.uow = this.getSession().acquireUnitOfWork();
        this.uow.setShouldThrowConformExceptions(value);
    }

    protected void tearDownTrial() {
        this.uow.release();
    }

    protected void testThrowNoConformException() {
        block6: {
            this.setupTrial(0);
            this.changeBobToFred();
            try {
                String owner = this.getAPhoneNumberOfBob().getOwner().getFirstName();
                if (owner.equals("Fred")) {
                    break block6;
                }
                throw new TestErrorException("The first name was not conformed to UOW changes: " + owner);
            }
            catch (Exception e) {
                throw new TestErrorException("An exception should not be thrown in the default case: " + e);
            }
            finally {
                this.tearDownTrial();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testThrowConformExceptionWithIndirection() {
        this.setupTrial(1);
        this.changeBobToFred();
        try {
            this.getAPhoneNumberOfBob();
        }
        catch (QueryException e) {
            this.pass = true;
        }
        finally {
            this.tearDownTrial();
        }
        if (!this.pass) {
            throw new TestErrorException("A conforming query exception should have been thrown in update case.");
        }
        this.setupTrial(1);
        this.deleteBob();
        try {
            this.getAPhoneNumberOfBob();
        }
        catch (QueryException e) {
            this.pass = true;
        }
        finally {
            this.tearDownTrial();
        }
        if (!this.pass) {
            throw new TestErrorException("A conforming query exception should have been thrown in delete case.");
        }
        this.setupTrial(1);
        this.addPhoneNumberToBob();
        try {
            this.getAPhoneNumberOfBob();
        }
        catch (QueryException e) {
            this.pass = true;
        }
        finally {
            this.tearDownTrial();
        }
        if (!this.pass) {
            throw new TestErrorException("A conforming query exception should be thrown in insertion case.");
        }
        this.setupTrial(1);
        this.changeBobToFred();
        try {
            this.getASinglePhoneNumberOfBob();
        }
        catch (QueryException e) {
            this.pass = true;
        }
        finally {
            this.tearDownTrial();
        }
        if (!this.pass) {
            throw new TestErrorException("A conforming query exception should have been thrown in read single object case.");
        }
        this.setupTrial(1);
        this.changeAMailAddress();
        try {
            this.getContacts();
        }
        catch (QueryException e) {
            throw new TestErrorException("A conforming query exception should not have be thrown when indirection not used.");
        }
        finally {
            this.tearDownTrial();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testThrowConformExceptionInAllCases() {
        this.setupTrial(1);
        this.changeBobToFred();
        try {
            this.getAPhoneNumberOfBob();
        }
        catch (QueryException e) {
            this.pass = true;
        }
        finally {
            this.tearDownTrial();
        }
        if (!this.pass) {
            throw new TestErrorException("A conforming query exception should have been thrown with an update.");
        }
        this.setupTrial(1);
        this.changeAMailAddress();
        try {
            try {
                Vector v = this.getContacts();
                String s = "";
                if (v.size() > 0) {
                    Contact contact = (Contact)v.firstElement();
                    s = contact.getMailAddress().mailAddress;
                }
                throw new TestErrorException("A conforming query exception should have been thrown even when indirection not involved: " + s + v.size());
            }
            catch (QueryException queryException) {
                this.tearDownTrial();
            }
        }
        catch (Throwable throwable) {
            this.tearDownTrial();
            throw throwable;
        }
    }

    private void changeBobToFred() {
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.bob = (Employee)this.uow.readObject(Employee.class, exp);
        this.bob.setFirstName("Fred");
    }

    private void deleteBob() {
        Expression exp = new ExpressionBuilder().get("firstName").equal((Object)"Bob");
        this.bob = (Employee)this.uow.readObject(Employee.class, exp);
        this.uow.deleteObject((Object)this.bob);
    }

    private void addPhoneNumberToBob() throws QueryException {
        PhoneNumber phoneNumber = (PhoneNumber)this.uow.newInstance(PhoneNumber.class);
        this.bob.addPhoneNumber(phoneNumber);
        phoneNumber.setOwner(this.bob);
    }

    private PhoneNumber getAPhoneNumberOfBob() throws QueryException {
        Vector phoneNumbers = (Vector)this.uow.executeQuery((DatabaseQuery)this.phoneNumbersQuery);
        return (PhoneNumber)phoneNumbers.firstElement();
    }

    private PhoneNumber getASinglePhoneNumberOfBob() throws QueryException {
        return (PhoneNumber)this.uow.executeQuery((DatabaseQuery)this.phoneNumberQuery);
    }

    private void changeAMailAddress() {
        Expression exp = new ExpressionBuilder().get("mailAddress").equal((Object)"three@object.com");
        MailAddress mailAddress = (MailAddress)this.uow.readObject(MailAddress.class, exp);
        mailAddress.mailAddress = new String("four@object.com");
    }

    private Vector getContacts() throws QueryException {
        return (Vector)this.uow.executeQuery((DatabaseQuery)this.contactsQuery);
    }
}

